/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.upload.ui;

import com.toedter.calendar.IDateEditor;
import com.toedter.calendar.JDateChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang.time.DateUtils;
import org.nrg.upload.ui.JDateChooserTextFieldDataEditor;
import org.nrg.upload.ui.UIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfirmSessionDateDialog
extends JDialog {
    private static final Logger _log = LoggerFactory.getLogger(ConfirmSessionDateDialog.class);
    private static final int DEFAULT_WIDTH = 300;
    private static final int DEFAULT_HEIGHT = 140;
    private static final String TITLE = "Confirm Session Date";
    private static final String CONFIRM_LABEL = "Confirm";
    private static final String CANCEL_LABEL = "Cancel";
    private static final String DATE_LABEL = "Date:";
    private static final String MISMATCHED_DATES_MESSAGE = "<html><p>The date you submitted earlier in the upload process</p><p>doesn't match the date of the selected session. Please</p><p>re-enter the session date to confirm that this is the</p><p> session that you want to upload.</p></html>";
    private static final String MATCHED_DATES_MESSAGE = "<html><p>The date you've entered matches the date of the</p><p>selected session. Click <b>Confirm</b> to proceed. You can</p><p>also click <b>Cancel</b> to return to the upload applet if</p><p>you believe you've selected the wrong session.</p></html>";
    private final Dimension _size;
    private final Date _date;
    private boolean _confirm;

    public static boolean showDialog(Component page, Date sessionDate, Date confirmDate) {
        return ConfirmSessionDateDialog.showDialog(page, sessionDate, confirmDate, new Dimension(300, 140));
    }

    public static boolean showDialog(Component page, Date sessionDate, Date confirmDate, Dimension size) {
        ConfirmSessionDateDialog dialog = new ConfirmSessionDateDialog(page, sessionDate, confirmDate, size);
        dialog.setVisible(true);
        return dialog._confirm;
    }

    private ConfirmSessionDateDialog(Component page, Date date, Date confirmDate, Dimension size) {
        super(UIUtils.findParentFrame(page), TITLE, true);
        this._date = date;
        this._size = size;
        this.setLocationRelativeTo(this.getOwner());
        this.setContentPane(this.getContents(confirmDate));
        this.pack();
        _log.debug("Created dialog to confirm session date of: " + this._date);
    }

    private JPanel getContents(Date confirmDate) {
        JPanel contents = new JPanel(new GridBagLayout()){
            {
                this.setPreferredSize(ConfirmSessionDateDialog.this._size);
            }
        };
        JLabel label = this.makeLabel(DATE_LABEL);
        final JLabel message = this.makeMessage();
        final JButton confirmButton = new JButton(CONFIRM_LABEL){
            {
                this.setEnabled(false);
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent ev) {
                        if (ConfirmSessionDateDialog.this._confirm) {
                            ConfirmSessionDateDialog.this.dispose();
                        }
                    }
                });
            }
        };
        JButton cancelButton = new JButton(CANCEL_LABEL){
            {
                this.setEnabled(true);
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent ev) {
                        ConfirmSessionDateDialog.this._confirm = false;
                        ConfirmSessionDateDialog.this.dispose();
                    }
                });
            }
        };
        JDateChooser dateChooser = new JDateChooser(confirmDate, "d MMM yyyy", (IDateEditor)JDateChooserTextFieldDataEditor.getInstance()){
            {
                super(x0, x1, x2);
                this.setMinimumSize(this.getPreferredSize());
                this.addPropertyChangeListener("date", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent event) {
                        ConfirmSessionDateDialog.this._confirm = DateUtils.isSameDay((Date)ConfirmSessionDateDialog.this._date, (Date)this.getDate());
                        message.setForeground(ConfirmSessionDateDialog.this._confirm ? Color.BLACK : Color.RED);
                        message.setText(ConfirmSessionDateDialog.this._confirm ? ConfirmSessionDateDialog.MATCHED_DATES_MESSAGE : ConfirmSessionDateDialog.MISMATCHED_DATES_MESSAGE);
                        confirmButton.setEnabled(ConfirmSessionDateDialog.this._confirm);
                    }
                });
            }
        };
        contents.add((Component)label, this.makeLabelConstraints(0));
        contents.add((Component)dateChooser, this.makeValueConstraints(0));
        contents.add((Component)message, this.makeMessageConstraints(1));
        contents.add((Component)cancelButton, this.makeButtonConstraints(1, 2));
        contents.add((Component)confirmButton, this.makeButtonConstraints(2, 2));
        return contents;
    }

    private JLabel makeLabel(String text) {
        JLabel label = new JLabel(text);
        label.setHorizontalAlignment(4);
        label.setHorizontalTextPosition(4);
        return label;
    }

    private JLabel makeMessage() {
        JLabel label = new JLabel(MISMATCHED_DATES_MESSAGE);
        label.setFont(new Font("Dialog", 0, 10));
        label.setHorizontalAlignment(2);
        label.setHorizontalTextPosition(2);
        label.setForeground(Color.RED);
        return label;
    }

    private GridBagConstraints makeLabelConstraints(int row) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = row;
        gbc.insets = new Insets(4, 8, 0, 0);
        return gbc;
    }

    private GridBagConstraints makeValueConstraints(int row) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.gridy = row;
        gbc.insets = new Insets(2, 2, 2, 2);
        return gbc;
    }

    private GridBagConstraints makeButtonConstraints(int col, int row) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = col;
        gbc.gridy = row;
        gbc.insets = new Insets(2, 2, 2, 2);
        return gbc;
    }

    private GridBagConstraints makeMessageConstraints(int row) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridwidth = 3;
        gbc.gridy = row;
        gbc.ipadx = 10;
        gbc.ipady = 10;
        return gbc;
    }

    public static void main(String[] a) {
        Date date = new Date();
        boolean confirm = ConfirmSessionDateDialog.showDialog(new JFrame(), date, DateUtils.addDays((Date)date, (int)-2));
        System.exit(confirm ? 0 : -1);
    }
}

