/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.upload.ui;

import com.toedter.calendar.IDateEditor;
import com.toedter.calendar.JDateChooser;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardPage;
import org.netbeans.spi.wizard.WizardPanelNavResult;
import org.nrg.upload.ui.JDateChooserTextFieldDataEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfirmSessionDatePage
extends WizardPage
implements PropertyChangeListener,
ChangeListener {
    public static final String PRODUCT_NAME = "*session-date*";
    private static final String STEP_DESCRIPTION = "Confirm session date";
    private static final String LONG_DESCRIPTION = "Enter the date of the session you plan to upload";
    public static final String SESSION_DATE_MESSAGE = "<html><p>Please enter the date for the session you wish to upload. This date</p><p>must match the session's date or you will <i>not</i> be able to upload the</p><p>session to the XNAT server. The date will be verified once you have</p><p>selected the session you want to upload.</p></html>";
    public static final String SESSION_DATE_LABEL = "<html><b>Verify session date:</b></html>";
    public static final String SESSION_DATE_PROBLEM = "Enter a date for the session you intend to upload.";
    public static final String NO_DATE_DESCRIPTION = "I don't know the date or my session doesn't have a date.";
    private final Logger logger = LoggerFactory.getLogger(ConfirmSessionDatePage.class);
    private final JDateChooser _dateChooser = new JDateChooser(null, "d MMM yyyy", (IDateEditor)JDateChooserTextFieldDataEditor.getInstance());
    private final JCheckBox _noDate = new JCheckBox("I don't know the date or my session doesn't have a date.", false);

    public static String getDescription() {
        return STEP_DESCRIPTION;
    }

    public ConfirmSessionDatePage() {
        this.setLayout(new GridBagLayout());
        this.setLongDescription(LONG_DESCRIPTION);
        this._dateChooser.addPropertyChangeListener("date", (PropertyChangeListener)this);
        this._noDate.addChangeListener(this);
    }

    public WizardPanelNavResult allowNext(String stepName, Map settings, Wizard wizard) {
        if (this._noDate.isSelected()) {
            return WizardPanelNavResult.PROCEED;
        }
        Date date = this._dateChooser.getDate();
        if (date == null) {
            this.setProblem("You must enter a valid value for the session date.");
            return WizardPanelNavResult.REMAIN_ON_PAGE;
        }
        return WizardPanelNavResult.PROCEED;
    }

    public WizardPanelNavResult allowFinish(String stepName, Map settings, Wizard wizard) {
        return WizardPanelNavResult.REMAIN_ON_PAGE;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.logger.debug("Got event: " + event);
        if (!this._noDate.isSelected()) {
            this.putWizardData(PRODUCT_NAME, this._dateChooser.getDate());
            this.userInputReceived((Component)((Object)this), event);
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.logger.debug("Got event: " + event);
        if (this._noDate == null || this._dateChooser == null) {
            return;
        }
        if (this._noDate.isSelected()) {
            this.putWizardData(PRODUCT_NAME, "no_session_date");
            this._dateChooser.setDate(null);
            this._dateChooser.setEnabled(false);
        } else {
            this._dateChooser.setEnabled(true);
        }
        this.userInputReceived((Component)((Object)this), event);
    }

    protected void recycle() {
        this.removeAll();
    }

    protected void renderingPage() {
        this.logger.trace("rendering");
        final Insets standardInsets = new Insets(5, 5, 5, 5);
        this.add(new JLabel(SESSION_DATE_LABEL), new GridBagConstraints(){
            {
                this.gridx = 0;
                this.gridy = 0;
                this.ipady = 5;
                this.ipadx = 5;
                this.anchor = 23;
                this.insets = standardInsets;
            }
        });
        this.add((Component)this._dateChooser, new GridBagConstraints(){
            {
                this.gridx = 1;
                this.gridy = 0;
                this.ipady = 5;
                this.ipadx = 5;
                this.anchor = 23;
                this.insets = standardInsets;
            }
        });
        this.add(new JLabel(SESSION_DATE_MESSAGE), new GridBagConstraints(){
            {
                this.gridx = 1;
                this.gridy = 1;
                this.ipady = 5;
                this.ipadx = 5;
                this.anchor = 23;
                this.fill = 2;
                this.insets = standardInsets;
            }
        });
        this.add(this._noDate, new GridBagConstraints(){
            {
                this.gridx = 1;
                this.gridy = 2;
                this.ipady = 5;
                this.ipadx = 5;
                this.anchor = 23;
                this.fill = 2;
                this.insets = standardInsets;
            }
        });
        this.setProblem(SESSION_DATE_PROBLEM);
    }

    protected String validateContents(Component component, Object event) {
        if (this._dateChooser.getDate() != null || this._noDate.isSelected()) {
            return null;
        }
        return "";
    }
}

