/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.upload.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.json.JSONException;
import org.netbeans.spi.wizard.WizardPage;
import org.nrg.net.RestServer;
import org.nrg.upload.data.Project;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SelectProjectPage
extends WizardPage
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    public static final String PRODUCT_NAME = "project";
    private static final String STEP_DESCRIPTION = "Select project";
    private static final String LONG_DESCRIPTION = "Select the project to which you will upload a session";
    private final Logger logger = LoggerFactory.getLogger(SelectProjectPage.class);
    private final transient RestServer xnat;
    private final JList list;
    private final Dimension dimension;

    public static String getDescription() {
        return STEP_DESCRIPTION;
    }

    public SelectProjectPage(RestServer xnat, Dimension dimension) throws IOException, JSONException {
        this.xnat = xnat;
        String path = "/REST/projects?format=json&owner=true&member=true";
        this.logger.trace("initializing SelectProjectPage; querying XNAT for project labels");
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.list = new JList<Object>(new Vector<Object>(xnat.getValues("/REST/projects?format=json&owner=true&member=true", "id")));
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(this);
        this.dimension = dimension;
        this.setOpaque(true);
        this.setLongDescription(LONG_DESCRIPTION);
        this.setCursor(Cursor.getDefaultCursor());
        this.logger.trace("SelectProjectPage ready with projects " + Arrays.toString(this.list.getComponents()));
    }

    public void recycle() {
        this.removeAll();
    }

    public void renderingPage() {
        this.logger.trace("rendering SelectProjectPage");
        JScrollPane pane = new JScrollPane(this.list);
        if (null != this.dimension) {
            pane.setPreferredSize(this.dimension);
        }
        this.add(pane);
    }

    protected String validateContents(Component component, Object o) {
        if (1 != this.list.getSelectedIndices().length) {
            return "";
        }
        return null;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            Project old = (Project)this.getWizardData(PRODUCT_NAME);
            if (null != old) {
                old.dispose();
            }
            this.putWizardData(PRODUCT_NAME, new Project((String)this.list.getSelectedValue(), this.xnat, this.getWizardDataMap()));
        }
    }

    public String toString() {
        Project old = (Project)this.getWizardData(PRODUCT_NAME);
        return null == old ? "" : old.toString();
    }
}

