/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.upload.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import org.netbeans.spi.wizard.WizardPage;
import org.nrg.upload.data.Session;
import org.nrg.upload.ui.SessionReviewPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SelectSessionScansPage
extends WizardPage {
    public static final String PRODUCT_NAME = "*scan*";
    private static final String STEP_DESCRIPTION = "Review session scans";
    private static final String LONG_DESCRIPTION = "Review session scan information";
    private static final Logger logger = LoggerFactory.getLogger(SelectSessionScansPage.class);

    public static String getDescription() {
        return STEP_DESCRIPTION;
    }

    public SelectSessionScansPage() {
        this.setLayout(new BorderLayout());
        this.setLongDescription(LONG_DESCRIPTION);
        logger.debug("Created a SelectSessionScansPage");
    }

    protected void recycle() {
        this.removeAll();
    }

    protected void renderingPage() {
        Session session = (Session)this.getWizardData("*session*");
        SessionReviewPanel panel = new SessionReviewPanel(session);
        this.add(panel, "Center");
        this.validate();
    }

    protected String validateContents(Component component, Object event) {
        Session session = (Session)this.getWizardData("*session*");
        if (null == session) {
            return "Couldn't find a valid session: please return to the previous page and select a valid session.";
        }
        if (session.getFileCount() > 0) {
            return null;
        }
        return "Directory contains no DICOM files; try another directory.";
    }
}

