/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.upload.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.json.JSONException;
import org.netbeans.spi.wizard.WizardPage;
import org.nrg.net.RestServer;
import org.nrg.upload.data.Project;
import org.nrg.upload.data.Subject;
import org.nrg.upload.ui.NewSubjectDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectSubjectPage
extends WizardPage {
    private static final long serialVersionUID = 1L;
    public static final String PRODUCT_NAME = "subject";
    private static final String STEP_DESCRIPTION = "Select subject";
    private static final String LONG_DESCRIPTION = "Select the subject for the session to be uploaded";
    private final Logger logger = LoggerFactory.getLogger(SelectSubjectPage.class);
    private final JList list;
    private final DefaultListModel listModel = new DefaultListModel();
    private final Dimension dimension;
    private final RestServer xnat;

    public static String getDescription() {
        return STEP_DESCRIPTION;
    }

    public SelectSubjectPage(RestServer xnat, Dimension dimension) {
        this.xnat = xnat;
        this.dimension = dimension;
        this.list = new JList(this.listModel);
        this.list.setName(PRODUCT_NAME);
        this.setLongDescription(LONG_DESCRIPTION);
    }

    protected void recycle() {
        this.removeAll();
        this.refreshSubjectList();
        this.validate();
    }

    protected void renderingPage() {
        this.setBusy(true);
        Project project = (Project)this.getWizardData("project");
        JScrollPane subject_list = new JScrollPane(this.list);
        if (null != this.dimension) {
            subject_list.setPreferredSize(this.dimension);
        }
        this.add(subject_list);
        if (null != project) {
            this.refreshSubjectList();
            JButton newSubject = new JButton("Create new subject");
            final NewSubjectDialog newSubjectDialog = new NewSubjectDialog(this, this.xnat, project);
            newSubject.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    newSubjectDialog.setVisible(true);
                }
            });
            newSubject.setEnabled(true);
            this.add(newSubject);
        }
        this.setBusy(false);
    }

    protected String validateContents(Component component, Object o) {
        return null == this.getWizardData(PRODUCT_NAME) ? "" : null;
    }

    void refreshSubjectList(final Object selection) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        final Project project = (Project)this.getWizardData("project");
        this.putWizardData(PRODUCT_NAME, null);
        Callable<Object> doRefresh = new Callable<Object>(){

            @Override
            public Object call() throws IOException, JSONException {
                while (true) {
                    SelectSubjectPage.this.listModel.removeAllElements();
                    try {
                        for (Subject subject : project.getSubjects()) {
                            SelectSubjectPage.this.listModel.addElement(subject);
                        }
                    }
                    catch (InterruptedException retry) {
                        SelectSubjectPage.this.logger.info("subject retrieval interrupted, retrying", (Throwable)retry);
                        continue;
                    }
                    catch (ExecutionException e) {
                        int n;
                        Object[] options;
                        Throwable cause = e.getCause();
                        if (cause instanceof IOException) {
                            options = new Object[]{"Retry", "Cancel"};
                            n = JOptionPane.showOptionDialog((Component)((Object)SelectSubjectPage.this), "Unable to contact " + SelectSubjectPage.this.xnat, "Network error", 0, 0, null, options, options[0]);
                            if (1 == n) {
                                throw new IOException(cause);
                            }
                            SelectSubjectPage.this.logger.error("error getting subject list; retrying at user request", cause);
                            continue;
                        }
                        if (cause instanceof JSONException) {
                            options = new Object[]{"Retry", "Cancel"};
                            n = JOptionPane.showOptionDialog((Component)((Object)SelectSubjectPage.this), "Received invalid response from " + SelectSubjectPage.this.xnat, "Server error", 0, 0, null, options, options[0]);
                            if (1 == n) {
                                throw new IOException(cause);
                            }
                            SelectSubjectPage.this.logger.error("error getting subject list; retrying at user request", cause);
                            continue;
                        }
                        SelectSubjectPage.this.logger.error("error getting subject list for " + project, cause);
                        SelectSubjectPage.this.logger.info("will retry in 1000 ms");
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ignore) {
                            JOptionPane.showMessageDialog(null, "Got an exception: " + ignore.getMessage(), "Error", -1);
                        }
                        continue;
                    }
                    break;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SelectSubjectPage.this.selectSubject(selection);
                    }
                });
                return selection;
            }
        };
        project.submit(doRefresh);
        this.setCursor(Cursor.getDefaultCursor());
    }

    void refreshSubjectList() {
        this.refreshSubjectList(this.getWizardData(PRODUCT_NAME));
    }

    private void selectSubject(Object selection) {
        if (this.listModel.contains(selection)) {
            this.list.setSelectedValue(selection, true);
        }
    }
}

