/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.upload.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.nrg.upload.data.Session;
import org.nrg.upload.ui.SelectSessionAction;
import org.nrg.upload.ui.SessionReviewPanel;

public class SessionSelectorSplitPane
extends JSplitPane {
    private SelectSessionAction.SessionSelectionListener _listener;
    private JList _list;
    private List<SessionReviewPanel> _panels = new ArrayList<SessionReviewPanel>();

    public SessionSelectorSplitPane(SelectSessionAction.SessionSelectionListener listener, List<Session> sessions) {
        super(0);
        this._listener = listener;
        Collections.sort(sessions, new Comparator<Session>(){

            @Override
            public int compare(Session session1, Session session2) {
                String id1 = SessionSelectorSplitPane.this.getSessionLabel(session1);
                String id2 = SessionSelectorSplitPane.this.getSessionLabel(session2);
                return id1.compareToIgnoreCase(id2);
            }
        });
        DefaultListModel<String> listItems = new DefaultListModel<String>();
        for (Session session : sessions) {
            String label = this.getSessionLabel(session);
            listItems.addElement(label);
            this._panels.add(new SessionReviewPanel(session));
        }
        this._list = new JList(listItems);
        this._list.setSelectedIndex(0);
        this._list.setSelectionMode(0);
        this._list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    SessionReviewPanel panel = (SessionReviewPanel)SessionSelectorSplitPane.this._panels.get(SessionSelectorSplitPane.this._list.getSelectedIndex());
                    SessionSelectorSplitPane.this.setRightComponent(new JScrollPane(panel));
                    SessionSelectorSplitPane.this._listener.isSelected(panel.getSession());
                }
            }
        });
        this.setLeftComponent(new JScrollPane(this._list));
        this.setRightComponent(new JScrollPane(this._panels.get(0)));
        this.setDividerSize(this._list.getWidth());
    }

    private String getSessionLabel(Session session) {
        return session.getFormat() + " session " + session.getID();
    }
}

