/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.upload.ui;

import java.awt.Cursor;
import java.net.URL;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import netscape.javascript.JSObject;
import org.nrg.awt.MouseClickTriggeredCallable;
import org.nrg.js.JSEval;
import org.nrg.upload.ui.UIUtils;
import org.nrg.util.Messages;

public final class UploadResultPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int SPACING = 4;
    private static final Cursor linkCursor = Cursor.getPredefinedCursor(12);
    private static JSObject context = null;
    private static String windowName = "_self";

    public UploadResultPanel(String label, URL url) {
        boolean isArchived = url.getPath().split("/")[3].equalsIgnoreCase("archive");
        JLabel link = this.getLinkForResource(label, url);
        Box box = new Box(1);
        this.add(box);
        box.add(new JLabel(Messages.getMessage("uploadresultpanel.success", Messages.getMessage(isArchived ? "vocabulary.archive" : "vocabulary.prearchive"))));
        box.add(Box.createVerticalStrut(4));
        box.add(link);
    }

    private JLabel getLinkForResource(String label, URL url) {
        JLabel link = new JLabel(Messages.getMessage("uploadresultpanel.dest.link", url, label));
        link.setCursor(linkCursor);
        if (null != context) {
            JSEval eval = new JSEval(context, String.format("this.open(\"%s\",'%s');", url, windowName));
            link.addMouseListener(new MouseClickTriggeredCallable(eval));
        } else {
            UIUtils.handleAppletInput(this, Messages.getMessage("error.msg.nourlsupport"), Messages.getMessage("error.title.nourlsupport"), 0, url.toString());
        }
        return link;
    }

    public static void setJSContext(JSObject context) {
        UploadResultPanel.context = context;
    }

    public static void setWindowName(String name) {
        windowName = name;
    }
}

