/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.upload.ui;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.netbeans.spi.wizard.DeferredWizardResult;
import org.netbeans.spi.wizard.ResultProgressHandle;
import org.netbeans.spi.wizard.WizardPage;
import org.nrg.upload.data.Session;
import org.nrg.upload.ui.SwingUploadFailureHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadWizardResultProducer
implements WizardPage.WizardResultProducer {
    private final ExecutorService _executorService;

    public UploadWizardResultProducer(ExecutorService executorService) {
        this._executorService = executorService;
    }

    public boolean cancel(Map arg0) {
        return true;
    }

    public Object finish(Map arg0) {
        return new UploadWizardResult();
    }

    private class UploadWizardResult
    extends DeferredWizardResult {
        private final Logger logger;
        private Future<Boolean> upload;

        UploadWizardResult() {
            super(true);
            this.logger = LoggerFactory.getLogger(UploadWizardResult.class);
            this.upload = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start(final Map wizardData, final ResultProgressHandle progress) {
            try {
                final Session session = (Session)wizardData.get("*session*");
                this.logger.trace("Wizard parameter map {}", (Object)wizardData);
                this.upload = UploadWizardResultProducer.this._executorService.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        return session.uploadTo(wizardData, new SwingUploadFailureHandler(), progress);
                    }
                });
                this.upload.get();
            }
            catch (CancellationException ignored) {
                progress.failed("Upload canceled", false);
            }
            catch (Throwable throwable) {
                System.out.println("upload failed: " + throwable);
                throwable.printStackTrace();
                this.logger.error("Something went wrong during upload", throwable);
                progress.failed(throwable.getMessage(), false);
            }
        }

        public void abort() {
            if (null != this.upload) {
                this.upload.cancel(true);
            }
        }
    }
}

