/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.nrg.util.Registry;

public final class MapRegistry<T>
implements Registry<T> {
    private final Map<T, T> map;

    public MapRegistry(Map<T, T> map) {
        this.map = map;
    }

    public MapRegistry() {
        this(new LinkedHashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(T template) {
        Map<T, T> map = this.map;
        synchronized (map) {
            T t = this.map.get(template);
            if (null == t) {
                this.map.put(template, template);
                return template;
            }
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(int i) {
        Map<T, T> map = this.map;
        synchronized (map) {
            Iterator<T> it = this.map.values().iterator();
            for (int ii = 0; ii < i; ++ii) {
                it.next();
            }
            return it.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIndex(Object o) {
        Map<T, T> map = this.map;
        synchronized (map) {
            Iterator<T> it = this.map.values().iterator();
            int i = 0;
            while (it.hasNext()) {
                if (it.next().equals(o)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }

    @Override
    public Collection<T> getAll() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.values().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }
}

