/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.util;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public final class Utils {
    private static final SortedMap<Long, String> prefixes;

    private Utils() {
    }

    public static StringBuilder slurp(StringBuilder sb, InputStream in) throws IOException {
        int nread;
        byte[] buffer = new byte[4096];
        while (0 < (nread = in.read(buffer))) {
            sb.append(new String(buffer, 0, nread));
        }
        return sb;
    }

    public static String slurp(InputStream in) throws IOException {
        return Utils.slurp(new StringBuilder(), in).toString();
    }

    public static File getCanonicalFile(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (IOException e) {
            return f.getAbsoluteFile();
        }
    }

    private static Map.Entry<Long, String> getPrefixFactor(long value) {
        Map.Entry<Long, String> current;
        long f;
        Iterator<Map.Entry<Long, String>> mei = prefixes.entrySet().iterator();
        Map.Entry<Long, String> last = mei.next();
        while (mei.hasNext() && (double)value >= 0.9 * (double)(f = (current = mei.next()).getKey().longValue())) {
            last = current;
        }
        return last;
    }

    public static StringBuilder showNearestUnitFraction(StringBuilder sb, long v0, long v1, String units, String numberFormat) {
        Map.Entry<Long, String> pf = Utils.getPrefixFactor(v1);
        long factor = pf.getKey();
        String prefix = pf.getValue();
        float small = (float)v0 / (float)factor;
        if ((double)Math.abs(small) < 0.01) {
            small = 0.0f;
        }
        Formatter formatter = new Formatter(sb);
        formatter.format(numberFormat, Float.valueOf(small));
        sb.append("/");
        formatter.format(numberFormat, Float.valueOf((float)v1 / (float)factor));
        sb.append(" ").append(prefix).append(units);
        return sb;
    }

    public static StringBuilder showNearestUnitFraction(StringBuilder sb, long v0, long v1, String units) {
        return Utils.showNearestUnitFraction(sb, v0, v1, units, "%.3g");
    }

    public static StringBuilder showNearestUnits(StringBuilder sb, long value, String units, String numberFormat) {
        Map.Entry<Long, String> pf = Utils.getPrefixFactor(value);
        long factor = pf.getKey();
        String prefix = pf.getValue();
        Formatter formatter = new Formatter(sb);
        formatter.format(numberFormat, Float.valueOf((float)value / (float)factor));
        sb.append(" ").append(prefix).append(units);
        return sb;
    }

    public static StringBuilder showNearestUnits(StringBuilder sb, long value, String units) {
        return Utils.showNearestUnits(sb, value, units, "%.3g");
    }

    public static <J, T> Multimap<Object, T> consolidateKeys(Multimap<J, T> m, int maxInstances) {
        LinkedHashSet remainingKeys = Sets.newLinkedHashSet((Iterable)m.keySet());
        LinkedHashMultimap consolidated = LinkedHashMultimap.create();
        while (!remainingKeys.isEmpty()) {
            ArrayList matchingKeys = Lists.newArrayList();
            Iterator ri = remainingKeys.iterator();
            Object leadKey = ri.next();
            matchingKeys.add(leadKey);
            Class<?> keyclass = leadKey.getClass();
            ri.remove();
            while (ri.hasNext()) {
                Object key = ri.next();
                if (!keyclass.equals(key.getClass())) continue;
                matchingKeys.add(key);
                ri.remove();
            }
            if (leadKey instanceof CharSequence || matchingKeys.size() <= maxInstances) {
                for (Object key : matchingKeys) {
                    consolidated.putAll(key, (Iterable)m.get(key));
                }
                continue;
            }
            for (Object key : matchingKeys) {
                consolidated.putAll(keyclass, (Iterable)m.get(key));
            }
        }
        return consolidated;
    }

    public static void initColumnSizes(JTable table) {
        TableModel model = table.getModel();
        JTableHeader header = table.getTableHeader();
        TableCellRenderer hr = header.getDefaultRenderer();
        for (int i = 0; i < model.getColumnCount(); ++i) {
            TableColumn column;
            TableCellRenderer chr;
            int w = (null == (chr = (column = table.getColumnModel().getColumn((int)i)).getHeaderRenderer()) ? hr : chr).getTableCellRendererComponent((JTable)table, (Object)column.getHeaderValue(), (boolean)false, (boolean)false, (int)0, (int)i).getPreferredSize().width;
            for (int j = 0; j < model.getRowCount(); ++j) {
                TableCellRenderer r = table.getCellRenderer(j, i);
                w = Math.max(w, r.getTableCellRendererComponent((JTable)table, (Object)model.getValueAt((int)j, (int)i), (boolean)false, (boolean)false, (int)j, (int)i).getPreferredSize().width);
            }
            column.setPreferredWidth(w + 4);
        }
    }

    static {
        TreeMap m = Maps.newTreeMap();
        LongFactorIterator i = new LongFactorIterator(1L, 1024L);
        for (String prefix : new String[]{"", "k", "M", "G", "T", "P"}) {
            m.put(i.next(), prefix);
        }
        prefixes = ImmutableSortedMap.copyOf((Map)m);
    }

    private static final class LongFactorIterator
    implements Iterator<Long> {
        private final long scale;
        private Long value;

        LongFactorIterator(long start, long scale) {
            this.value = start;
            this.scale = scale;
        }

        @Override
        public boolean hasNext() {
            return null != this.value;
        }

        @Override
        public Long next() {
            if (null == this.value) {
                throw new NoSuchElementException();
            }
            long r = this.value;
            this.value = this.value > Long.MAX_VALUE / this.scale || this.value < Long.MIN_VALUE / this.scale ? null : Long.valueOf(this.value * this.scale);
            return r;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

