/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.wizard.displayer;

import java.awt.Container;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.wizard.WizardDisplayer;
import org.netbeans.api.wizard.displayer.NavButtonManager;
import org.netbeans.api.wizard.displayer.WizardDisplayerImpl;
import org.netbeans.modules.wizard.NbBridge;
import org.netbeans.spi.wizard.ResultProgressHandle;
import org.netbeans.spi.wizard.Summary;

public class NavProgress
implements ResultProgressHandle {
    private static final Logger logger = Logger.getLogger(NavProgress.class.getName());
    private static final Icon busyIcon = new ImageIcon(NavProgress.class.getResource("busy.gif"));
    private static final String MESSAGE_SPACE = "________________________________________________________________";
    private final JPanel panel = new JPanel();
    private final JProgressBar progressBar = new JProgressBar();
    private final JLabel messageLabel = new JLabel("________________________________________________________________");
    private final JLabel busyLabel = new JLabel();
    private final WizardDisplayerImpl parent;
    private final boolean disableUIWhileBusy;
    private boolean isRunning = true;

    NavProgress(WizardDisplayerImpl impl, boolean disableUIWhileBusy) {
        this.parent = impl;
        this.disableUIWhileBusy = disableUIWhileBusy;
        this.panel.setOpaque(false);
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.panel.add(this.messageLabel);
        if (disableUIWhileBusy) {
            this.panel.add(this.busyLabel);
        } else {
            this.panel.add(this.progressBar);
        }
        this.setBusy();
    }

    public void addProgressComponents(Container container) {
        container.add(this.panel);
        container.invalidate();
    }

    public void setProgress(final String description, final int currentStep, final int totalSteps) {
        Runnable r = new Runnable(){

            public void run() {
                NavProgress.this.messageLabel.setText(description == null ? " " : description);
                NavProgress.this.messageLabel.revalidate();
                NavProgress.this.setProgress(currentStep, totalSteps);
                NavProgress.this.panel.repaint();
            }
        };
        this.invoke(r);
    }

    public void setProgress(final int currentStep, final int totalSteps) {
        if (totalSteps == -1) {
            this.setBusy();
        } else {
            if (currentStep > totalSteps || currentStep < 0) {
                throw new IllegalArgumentException("Bad step values: " + currentStep + " out of " + totalSteps);
            }
            this.invoke(new Runnable(){

                public void run() {
                    if (NavProgress.this.disableUIWhileBusy) {
                        NavProgress.this.busyLabel.setIcon(null);
                    } else {
                        NavProgress.this.progressBar.setIndeterminate(false);
                        NavProgress.this.progressBar.setMaximum(totalSteps);
                        NavProgress.this.progressBar.setValue(currentStep);
                    }
                    NavProgress.this.panel.repaint();
                }
            });
        }
    }

    private void setBusy() {
        this.invoke(new Runnable(){

            public void run() {
                if (NavProgress.this.disableUIWhileBusy) {
                    NavProgress.this.busyLabel.setIcon(busyIcon);
                } else {
                    NavProgress.this.progressBar.setIndeterminate(true);
                }
            }
        });
    }

    public void setBusy(final String description) {
        this.invoke(new Runnable(){

            public void run() {
                NavProgress.this.messageLabel.setText(description == null ? " " : description);
                NavProgress.this.setBusy();
            }
        });
    }

    private void invoke(Runnable r) {
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            try {
                EventQueue.invokeAndWait(r);
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
                logger.severe("Error invoking operation " + ex.getClass().getName() + " " + ex.getMessage());
            }
            catch (InterruptedException ex) {
                logger.severe("Error invoking operation " + ex.getClass().getName() + " " + ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    public void finished(final Object o) {
        this.isRunning = false;
        Runnable r = new Runnable(){

            public void run() {
                if (o instanceof Summary) {
                    Summary summary = (Summary)o;
                    NavProgress.this.parent.handleSummary(summary);
                    NavProgress.this.parent.setWizardResult(summary.getResult());
                } else if (NavProgress.this.parent.getDeferredResult() != null) {
                    NavProgress.this.parent.setWizardResult(o);
                    NavProgress.this.parent.getButtonManager().deferredResultFinished(o);
                }
            }
        };
        this.invoke(r);
    }

    public void failed(final String message, final boolean canGoBack) {
        this.isRunning = false;
        Runnable r = new Runnable(){

            public void run() {
                JLabel comp = new JLabel("<html><body>" + message + "</body></html>");
                comp.setBorder(new EmptyBorder(5, 5, 5, 5));
                NavProgress.this.parent.setCurrentWizardPanel(comp);
                NavProgress.this.parent.getTtlLabel().setText(NbBridge.getString("org/netbeans/api/wizard/Bundle", WizardDisplayer.class, "Failed"));
                NavButtonManager bm = NavProgress.this.parent.getButtonManager();
                bm.deferredResultFailed(canGoBack);
            }
        };
        this.invoke(r);
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

