/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.framework.constants;

import java.util.HashMap;
import java.util.Map;

public enum PrearchiveCode {
    Manual(0),
    AutoArchive(4),
    AutoArchiveOverwrite(5);

    private final int _code;
    private static final Map<Integer, PrearchiveCode> _codes;

    private PrearchiveCode(int code) {
        this._code = code;
    }

    public int getCode() {
        return this._code;
    }

    public static PrearchiveCode code(String code) {
        return PrearchiveCode.code(Integer.parseInt(code));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PrearchiveCode code(int code) {
        if (!_codes.isEmpty()) return _codes.get(code);
        Class<PrearchiveCode> clazz = PrearchiveCode.class;
        synchronized (PrearchiveCode.class) {
            for (PrearchiveCode prearchiveCode : PrearchiveCode.values()) {
                _codes.put(prearchiveCode.getCode(), prearchiveCode);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _codes.get(code);
        }
    }

    public String toString() {
        return this.name();
    }

    static {
        _codes = new HashMap<Integer, PrearchiveCode>();
    }
}

