/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.framework.logging;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.nrg.framework.analytics.AnalyticsEvent;

public class Analytics {
    public static final String EVENT_KEY = "key";
    public static final Level DEFAULT_LEVEL = Level.TRACE;
    public static final String KEY_STATEMENT = "statement";
    public static final String KEY_THROWABLE = "throwable";
    private static final int MAX_DEPTH = 5;
    public static final String ANALYTICS = "analytics";
    private static final Log _log = LogFactory.getLog(Analytics.class);
    private static final Log _analytics = LogFactory.getLog((String)"analytics");
    private static final ObjectMapper _serializer = new ObjectMapper();

    public static void enter(Class<?> clazz, String statement) {
        Analytics.enter(clazz.getName(), DEFAULT_LEVEL, Analytics.wrapStatement(statement));
    }

    public static void enter(Class<?> clazz, Throwable throwable) {
        Analytics.enter(clazz.getName(), Level.ERROR, Analytics.wrapStatement(throwable));
    }

    public static void enter(Class<?> clazz, String statement, Throwable throwable) {
        Analytics.enter(clazz.getName(), Level.ERROR, Analytics.wrapStatement(statement, throwable));
    }

    public static void enter(Class<?> clazz, Level level, String statement) {
        Analytics.enter(clazz.getName(), level, Analytics.wrapStatement(statement));
    }

    public static void enter(Class<?> clazz, Level level, Throwable throwable) {
        Analytics.enter(clazz.getName(), level, Analytics.wrapStatement(throwable));
    }

    public static void enter(Class<?> clazz, Level level, String statement, Throwable throwable) {
        Analytics.enter(clazz.getName(), level, Analytics.wrapStatement(statement, throwable));
    }

    public static void enter(Class<?> clazz, Map<String, String> properties) {
        Analytics.enter(clazz.getName(), DEFAULT_LEVEL, properties);
    }

    public static void enter(Class<?> clazz, Level level, Map<String, String> properties) {
        Analytics.enter(clazz.getName(), level, properties);
    }

    public static void enter(String tool, String statement) {
        Analytics.enter(tool, DEFAULT_LEVEL, Analytics.wrapStatement(statement));
    }

    public static void enter(String tool, Throwable throwable) {
        Analytics.enter(tool, Level.ERROR, Analytics.wrapStatement(throwable));
    }

    public static void enter(String tool, String statement, Throwable throwable) {
        Analytics.enter(tool, Level.ERROR, Analytics.wrapStatement(statement, throwable));
    }

    public static void enter(String tool, Level level, String statement) {
        Analytics.enter(tool, level, Analytics.wrapStatement(statement));
    }

    public static void enter(String tool, Level level, Throwable throwable) {
        Analytics.enter(tool, level, Analytics.wrapStatement(throwable));
    }

    public static void enter(String tool, Level level, String statement, Throwable throwable) {
        Analytics.enter(tool, level, Analytics.wrapStatement(statement, throwable));
    }

    public static void enter(String tool, Map<String, String> properties) {
        String specifiedLevel;
        Level level = properties.containsKey("level") ? ((specifiedLevel = properties.get("level")) instanceof Level ? (Level)specifiedLevel : Level.toLevel((String)specifiedLevel)) : DEFAULT_LEVEL;
        Analytics.enter(tool, level, properties);
    }

    public static void enter(String tool, Level level, Map<String, String> properties) {
        try {
            AnalyticsEvent event = new AnalyticsEvent();
            event.setKey(tool);
            event.setLevel(level);
            event.setProperties(properties);
            String payload = _serializer.writeValueAsString((Object)event);
            if (level.equals((Object)Level.TRACE)) {
                _analytics.trace((Object)payload);
            } else if (level.equals((Object)Level.DEBUG)) {
                _analytics.debug((Object)payload);
            } else if (level.equals((Object)Level.INFO)) {
                _analytics.info((Object)payload);
            } else if (level.equals((Object)Level.WARN)) {
                _analytics.warn((Object)payload);
            } else if (level.equals((Object)Level.ERROR)) {
                _analytics.error((Object)payload);
            } else if (level.equals((Object)Level.FATAL)) {
                _analytics.fatal((Object)payload);
            }
        }
        catch (IOException exception) {
            _log.error((Object)"Error during analytics serialization", (Throwable)exception);
        }
    }

    private static Map<String, String> wrapStatement(String statement) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(KEY_STATEMENT, statement);
        return properties;
    }

    private static Map<String, String> wrapStatement(Throwable throwable) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(KEY_THROWABLE, Analytics.convertThrowable(throwable));
        return properties;
    }

    private static Map<String, String> wrapStatement(String statement, Throwable throwable) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(KEY_STATEMENT, statement);
        properties.put(KEY_THROWABLE, Analytics.convertThrowable(throwable));
        return properties;
    }

    private static String convertThrowable(Throwable throwable) {
        return Analytics.convertThrowable(0, throwable);
    }

    private static String convertThrowable(int depth, Throwable throwable) {
        StringBuilder buffer = new StringBuilder();
        if (depth == 0) {
            buffer.append("Found throwable exception of type: ");
        }
        buffer.append(throwable.getClass()).append("\n").append(throwable.getMessage()).append("\n");
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        if (stackTrace != null) {
            for (StackTraceElement element : stackTrace) {
                buffer.append(element).append("\n");
            }
        }
        if (throwable.getCause() != null) {
            buffer.append("Caused by: ");
            if (depth <= 1) {
                buffer.append(Analytics.convertThrowable(depth + 1, throwable.getCause()));
            } else if (depth < 5) {
                buffer.append(Analytics.convertThrowable(depth + 1, throwable.getCause()));
            } else {
                buffer.append(throwable.getCause().getClass().getName()).append("...");
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    static {
        _serializer.getSerializationConfig().setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        _serializer.getSerializationConfig().set(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, false);
    }
}

