/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.framework.logging;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.nrg.framework.logging.RemoteEvent;
import org.nrg.framework.net.AuthenticatedClientHttpRequestFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

public class RESTfulAppender
extends AppenderSkeleton {
    private static final HttpMessageConverter<?>[] messageConverters = new HttpMessageConverter[]{new FormHttpMessageConverter(), new StringHttpMessageConverter(), new ResourceHttpMessageConverter(), new ByteArrayHttpMessageConverter()};
    private ObjectMapper _serializer = new ObjectMapper();
    private RestTemplate _template;
    private String _serviceAddress;

    public RESTfulAppender() {
        SerializationConfig config = this._serializer.getSerializationConfig();
        config.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        config.set(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, false);
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }

    public String getServiceAddress() {
        return this._serviceAddress;
    }

    public void setServiceAddress(String serviceAddress) {
        this._serviceAddress = serviceAddress;
    }

    protected void append(LoggingEvent event) {
        try {
            RemoteEvent remoteEvent = new RemoteEvent(this.convertEventToMap(event));
            final String marshaledEvent = this._serializer.writeValueAsString((Object)remoteEvent);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ResponseEntity response = RESTfulAppender.this.getRestTemplate().postForEntity(RESTfulAppender.this.getServiceAddress(), (Object)marshaledEvent, String.class, new Object[0]);
                    System.out.println("Found response: " + response);
                }
            }).start();
        }
        catch (IOException exception) {
            throw new RuntimeException("There was an issue marshaling the submitted event: " + event, exception);
        }
    }

    protected RestTemplate getRestTemplate() {
        if (this._template == null) {
            this._template = new RestTemplate((ClientHttpRequestFactory)new AuthenticatedClientHttpRequestFactory("admin", "admin"));
            this._template.setMessageConverters(Arrays.asList(messageConverters));
        }
        return this._template;
    }

    private Map<String, Object> convertEventToMap(LoggingEvent event) {
        HashMap<String, Object> eventMap = new HashMap<String, Object>();
        eventMap.put("fqnOfLoggerClass", event.getFQNOfLoggerClass());
        eventMap.put("level", event.getLevel().toString());
        eventMap.put("locationInformation", event.getLocationInformation().toString());
        eventMap.put("message", event.getMessage().toString());
        try {
            eventMap.put("properties", this._serializer.writeValueAsString((Object)event.getProperties()));
        }
        catch (IOException ignored) {
            // empty catch block
        }
        eventMap.put("loggerName", event.getLoggerName());
        eventMap.put("threadName", event.getThreadName());
        ThrowableInformation info = event.getThrowableInformation();
        if (info != null) {
            eventMap.put("throwableInformation", info.toString());
        }
        eventMap.put("timeStamp", Long.toString(event.getTimeStamp()));
        return eventMap;
    }
}

