/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.framework.logging;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.codehaus.jackson.map.ObjectMapper;
import org.restlet.data.ClientInfo;

public class RemoteEvent
extends HashMap<String, String> {
    public static final String REMOTE_LOG = "org.nrg.xnat.remote";
    private static final Log _log = LogFactory.getLog(RemoteEvent.class);
    private static final ObjectMapper _mapper = new ObjectMapper();
    private Map<String, String> _properties = new HashMap<String, String>();

    public RemoteEvent() {
        _log.debug((Object)"Creating default remote event instance");
    }

    public RemoteEvent(Properties properties) throws IOException {
        _log.debug((Object)"Creating remote event instance from properties");
        this.addProperties(properties);
    }

    public RemoteEvent(Map<String, Object> eventMap) {
        Object properties;
        Object throwableInformation;
        Object level;
        _log.debug((Object)"Creating remote event instance from map");
        if (eventMap.containsKey("level") && (level = eventMap.get("level")) != null) {
            if (level instanceof Level) {
                this.setLevel((Level)level);
            } else {
                this.setLevel(Level.toLevel((String)level.toString()));
            }
        }
        if (eventMap.containsKey("throwableInformation") && (throwableInformation = eventMap.get("throwableInformation")) != null) {
            this.put("throwableInformation", throwableInformation.toString());
        }
        if (eventMap.containsKey("properties") && (properties = eventMap.get("properties")) != null) {
            if (properties instanceof Properties) {
                this.addProperties((Properties)properties);
            } else {
                this.put("properties", properties.toString());
            }
        }
    }

    public RemoteEvent(Map<String, Object> map, ClientInfo clientInfo) {
        this(map);
        this.setClientInfo(clientInfo);
        _log.debug((Object)"Creating remote event instance from map and client info");
    }

    public Level getLevel() {
        if (this.containsKey("level")) {
            return Level.toLevel((String)((String)this.get("level")));
        }
        if (this.containsKey("LEVEL")) {
            return Level.toLevel((String)((String)this.get("LEVEL")));
        }
        return Level.TRACE;
    }

    public void setLevel(Level level) {
        this.put("level", level.toString());
    }

    public void setClientInfo(ClientInfo clientInfo) {
        this.putNotBlank("address", clientInfo.getAddress());
        this.putNotBlank("port", Integer.toString(clientInfo.getPort()));
        this.putNotBlank("agent", clientInfo.getAgent());
        this.putNotBlank("agentName", clientInfo.getAgentName());
        Map attributes = clientInfo.getAgentAttributes();
        if (attributes != null && attributes.size() > 0) {
            for (String attribute : attributes.keySet()) {
                this.putNotBlank(attribute, (String)attributes.get(attribute));
            }
        }
    }

    public Map<String, String> getProperties() {
        return this._properties;
    }

    public void setProperties(Map<String, String> properties) {
        this._properties.clear();
        this._properties.putAll(properties);
    }

    @Override
    public String toString() {
        try {
            return _mapper.writeValueAsString((Object)this).replaceAll("'", "\\\\'");
        }
        catch (IOException exception) {
            return "Error occurred while converting to string: " + exception.getMessage();
        }
    }

    private void putNotBlank(String key, String value) {
        if (!StringUtils.isBlank((String)key) && !StringUtils.isBlank((String)value)) {
            this.put(key, value);
        }
    }

    private void addProperties(Properties properties) {
        for (String property : properties.stringPropertyNames()) {
            Object value = properties.get(property);
            if (value instanceof String) {
                this.put(property, (String)value);
                continue;
            }
            try {
                this.put(property, _mapper.writeValueAsString(value));
            }
            catch (IOException e) {
                this.put(property, "Invalid value found for property: " + property);
            }
        }
    }
}

