/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.framework.messaging;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlqListener {
    private static final Logger log = LoggerFactory.getLogger(DlqListener.class);
    private final Map<Class<?>, ListenerMethod> _mapping = new HashMap();

    public void onReceiveDeadLetter(Object object) throws Exception {
        if (object == null) {
            String error = "Received null dead letter. That's not OK.";
            log.error("Received null dead letter. That's not OK.");
            throw new RuntimeException("Received null dead letter. That's not OK.");
        }
        if (this._mapping.size() == 0) {
            String error = "Received dead letter of type: " + object.getClass() + ", however no listeners are currently configured.";
            log.error(error);
            throw new RuntimeException(error);
        }
        boolean found = false;
        for (Map.Entry<Class<?>, ListenerMethod> mapping : this._mapping.entrySet()) {
            if (!mapping.getKey().isAssignableFrom(object.getClass())) continue;
            ListenerMethod method = mapping.getValue();
            method.callListenerMethod(object);
            found = true;
            break;
        }
        if (!found) {
            String error = "Received dead letter of unknown type: " + object.getClass();
            log.error(error);
            throw new RuntimeException(error);
        }
    }

    public void setMessageListenerMapping(Map<String, String> mapping) {
        this._mapping.clear();
        String requestTypeName = null;
        Object listenerTypeName = null;
        try {
            for (Map.Entry<String, String> entry : mapping.entrySet()) {
                requestTypeName = null;
                listenerTypeName = null;
                requestTypeName = entry.getKey();
                Class<?> requestType = Class.forName(requestTypeName);
                ListenerMethod method = new ListenerMethod(entry.getValue());
                this._mapping.put(requestType, method);
            }
        }
        catch (ClassNotFoundException e) {
            String error = requestTypeName == null ? "Something weird happened and nothing is initialized." : (listenerTypeName == null ? "The request type " + requestTypeName + " is not a valid class." : "The listener type " + listenerTypeName + " for request type " + requestTypeName + " is not a valid class.");
            log.error(error);
            throw new RuntimeException(error);
        }
    }

    private class ListenerMethod {
        private final String _classAndMethod;
        private final Class<?> _listenerClass;
        private final String _listenerMethod;
        private final Class<?>[] _listenerMethodParameterTypes;

        public ListenerMethod(String classAndMethod) throws ClassNotFoundException {
            this._classAndMethod = classAndMethod;
            int methodLocation = this._classAndMethod.lastIndexOf(".");
            if (methodLocation < 0) {
                throw new RuntimeException("Poorly formed listener specifier " + classAndMethod + ". Must be of the form package.of.ListenerClass.ListenerMethod.");
            }
            String className = this._classAndMethod.substring(0, methodLocation);
            String methodName = this._classAndMethod.substring(methodLocation + 1);
            this._listenerClass = Class.forName(className);
            Method method = null;
            Class<?>[] parameterTypes = null;
            for (Method candidate : this._listenerClass.getMethods()) {
                if (!candidate.getName().equals(methodName)) continue;
                method = candidate;
                parameterTypes = method.getParameterTypes();
                break;
            }
            if (method == null) {
                throw new RuntimeException("Poorly formed listener specifier " + classAndMethod + ". Must be of the form package.of.ListenerClass.ListenerMethod.");
            }
            this._listenerMethod = methodName;
            this._listenerMethodParameterTypes = parameterTypes;
        }

        public void callListenerMethod(Object ... objects) {
            try {
                Object object = this._listenerClass.newInstance();
                Method method = this._listenerClass.getMethod(this._listenerMethod, this._listenerMethodParameterTypes);
                method.invoke(object, objects);
            }
            catch (NoSuchMethodException exception) {
                throw new RuntimeException("Error retrieving verified method: " + this._classAndMethod, exception);
            }
            catch (InstantiationException exception) {
                throw new RuntimeException("Error creating verified class: " + this._listenerClass.getName(), exception);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException("Illegal access to verified method: " + this._classAndMethod, exception);
            }
            catch (InvocationTargetException exception) {
                throw new RuntimeException("Error invoking verified method: " + this._classAndMethod, exception);
            }
        }
    }
}

