/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.framework.net;

import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;

public enum HttpMethod {
    GET("GET"),
    PUT("PUT"),
    POST("POST"),
    DELETE("DELETE"),
    HEAD("HEAD"),
    TRACE("TRACE"),
    OPTIONS("OPTIONS");

    private static final Map<String, HttpMethod> _methods;
    private final String _method;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpMethod method(String method) {
        if (!_methods.isEmpty()) return _methods.get(method);
        Class<HttpMethod> clazz = HttpMethod.class;
        synchronized (HttpMethod.class) {
            for (HttpMethod httpMethod : HttpMethod.values()) {
                _methods.put(httpMethod.getMethod(), httpMethod);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _methods.get(method);
        }
    }

    public static HttpRequestBase getHttpRequestObject(String method) {
        return HttpMethod.getHttpRequestObject(HttpMethod.method(method));
    }

    public static HttpRequestBase getHttpRequestObject(HttpMethod method) {
        HttpGet request;
        switch (method) {
            case GET: {
                request = new HttpGet();
                break;
            }
            case PUT: {
                request = new HttpPut();
                break;
            }
            case POST: {
                request = new HttpPost();
                break;
            }
            case DELETE: {
                request = new HttpDelete();
                break;
            }
            case HEAD: {
                request = new HttpHead();
                break;
            }
            case TRACE: {
                request = new HttpTrace();
                break;
            }
            case OPTIONS: {
                request = new HttpOptions();
                break;
            }
            default: {
                throw new RuntimeException("Unknown method specified: " + (Object)((Object)method));
            }
        }
        return request;
    }

    private HttpMethod(String method) {
        this._method = method;
    }

    private String getMethod() {
        return this._method;
    }

    public String toString() {
        return this.name();
    }

    static {
        _methods = new HashMap<String, HttpMethod>();
    }
}

