/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.framework.orm.hibernate;

import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.nrg.framework.orm.hibernate.BaseHibernateEntity;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public abstract class AbstractHibernateEntity
implements BaseHibernateEntity {
    private long _id = 0L;
    private boolean _enabled = true;
    private Date _created;
    private Date _timestamp;
    private Date _disabled = new Date(0L);

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE)
    public long getId() {
        return this._id;
    }

    @Override
    public void setId(long id) {
        this._id = id;
    }

    @Override
    public boolean isEnabled() {
        return this._enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
        this._disabled = enabled ? null : new Date();
    }

    @Override
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getCreated() {
        return this._created;
    }

    @Override
    public void setCreated(Date created) {
        this._created = created;
    }

    @Override
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getTimestamp() {
        return this._timestamp;
    }

    @Override
    @Temporal(value=TemporalType.TIMESTAMP)
    public void setTimestamp(Date timestamp) {
        this._timestamp = timestamp;
    }

    @Override
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getDisabled() {
        return this._disabled;
    }

    @Override
    @Temporal(value=TemporalType.TIMESTAMP)
    public void setDisabled(Date disabled) {
        this._disabled = disabled;
    }

    @PrePersist
    protected void onCreate() {
        this._created = this._timestamp = new Date();
    }

    @PreUpdate
    protected void onUpdate() {
        this._timestamp = new Date();
    }
}

