/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.framework.orm.hibernate;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.nrg.framework.orm.hibernate.BaseHibernateEntity;
import org.nrg.framework.orm.hibernate.exceptions.InvalidDirectParameterizedClassUsageException;

public abstract class AbstractParameterizedWorker<E extends BaseHibernateEntity> {
    private final Class<E> _parameterizedType;

    protected AbstractParameterizedWorker() {
        ParameterizedType parameterizedType = null;
        Class<?> clazz = this.getClass();
        while (parameterizedType == null) {
            Type superclass = clazz.getGenericSuperclass();
            if (superclass == null) {
                throw new RuntimeException("Can't find superclass as parameterized type!");
            }
            if (superclass instanceof ParameterizedType) {
                parameterizedType = (ParameterizedType)superclass;
                if (!(parameterizedType.getActualTypeArguments()[0] instanceof TypeVariable)) continue;
                throw new InvalidDirectParameterizedClassUsageException("When using a parameterized worker directly (i.e. with a generic subclass), you must call the AbstractParameterizedWorker constructor that takes the parameterized type directly.");
            }
            clazz = clazz.getSuperclass();
        }
        this._parameterizedType = (Class)parameterizedType.getActualTypeArguments()[0];
    }

    protected AbstractParameterizedWorker(Class<E> clazz) {
        this._parameterizedType = clazz;
    }

    protected Class<E> getParameterizedType() {
        return this._parameterizedType;
    }
}

