/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.framework.services;

import org.nrg.framework.exceptions.NrgServiceError;
import org.nrg.framework.exceptions.NrgServiceException;
import org.nrg.framework.services.NrgService;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Service;

@Service
public class ContextService
implements NrgService,
ApplicationContextAware,
ApplicationListener {
    public static String SERVICE_NAME = "ContextService";
    private static ContextService _instance;
    private ApplicationContext _context;

    public ContextService() throws NrgServiceException {
        if (_instance != null) {
            throw new NrgServiceException(NrgServiceError.AlreadyInitialized, "The ContextService is already initialized, try calling getInstance() instead.");
        }
        _instance = this;
    }

    public static ContextService getInstance() {
        if (_instance == null) {
            try {
                _instance = new ContextService();
            }
            catch (NrgServiceException nrgServiceException) {
                // empty catch block
            }
        }
        return _instance;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this._context = context;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            ContextService.getInstance().setApplicationContext(((ContextRefreshedEvent)event).getApplicationContext());
        }
    }

    public <T> T getBean(Class<T> type) {
        return (T)this._context.getBean(type);
    }

    public <T> T getBean(String name, Class<T> type) {
        return (T)this._context.getBean(name, type);
    }
}

