/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.framework.services.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationException;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nrg.framework.services.MarshallerCacheService;
import org.nrg.framework.utilities.Reflection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.oxm.MarshallingFailureException;
import org.springframework.oxm.UncategorizedMappingException;
import org.springframework.oxm.UnmarshallingFailureException;
import org.springframework.oxm.ValidationFailureException;
import org.springframework.oxm.XmlMappingException;
import org.springframework.stereotype.Service;
import org.springframework.util.ClassUtils;
import org.springframework.util.SystemPropertyUtils;
import org.springframework.util.xml.StaxUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Service
public final class JaxbBasedMarshallerCacheService
implements MarshallerCacheService {
    private static final Log _log = LogFactory.getLog(JaxbBasedMarshallerCacheService.class);
    private static final Map<ContextDescriptor, JAXBContext> cache = new HashMap<ContextDescriptor, JAXBContext>();
    private static final Map<String, ContextDescriptor> contextCache = new HashMap<String, ContextDescriptor>();
    private DocumentBuilderFactory _docBuilderFactory = DocumentBuilderFactory.newInstance();
    @Autowired(required=false)
    @Qualifier(value="marshalablePackages")
    private List<String> _packages;

    @Override
    public List<String> getMarshalablePackages() {
        return this._packages;
    }

    @Override
    public void setMarshalablePackages(List<String> packages) {
        this._packages = packages;
    }

    public boolean supports(Class<?> clazz) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Asking if " + clazz.getName() + " is supported"));
        }
        return clazz.isAnnotationPresent(XmlRootElement.class);
    }

    @Override
    public String marshal(Object object) {
        StreamResult result = new StreamResult(new ByteArrayOutputStream());
        this.marshal(object, result);
        return result.getOutputStream().toString();
    }

    @Override
    public Document marshalToDocument(Object object) {
        try {
            DOMResult result = new DOMResult(this.getDocument());
            this.marshal(object, result);
            return (Document)result.getNode();
        }
        catch (ParserConfigurationException exception) {
            throw new UncategorizedMappingException("An error occurred creating a Document object", (Throwable)exception);
        }
    }

    public void marshal(Object object, Result result) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Attempting to marshall object of type: " + object.getClass().getName()));
        }
        JAXBContext context = JaxbBasedMarshallerCacheService.getInstance(object.getClass());
        try {
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal(object, result);
        }
        catch (JAXBException exception) {
            throw this.convertJaxbException(exception);
        }
    }

    public Object unmarshal(Source source) throws IOException, XmlMappingException {
        String xmlElementName = null;
        String xmlSource = null;
        try {
            Document document;
            DocumentBuilder builder;
            if (source instanceof StreamSource) {
                InputStream stream = ((StreamSource)source).getInputStream();
                builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                document = builder.parse(stream);
                xmlElementName = document.getDocumentElement().getNodeName();
                xmlSource = this.getStringFromDocument(document);
            } else if (source instanceof DOMSource) {
                Node node = ((DOMSource)source).getNode();
                builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                document = builder.newDocument();
                document.adoptNode(node);
                document.appendChild(node);
                xmlElementName = document.getDocumentElement().getNodeName();
                xmlSource = this.getStringFromDocument(document);
            } else if (StaxUtils.isStaxSource((Source)source)) {
                XMLStreamReader streamReader = StaxUtils.getXMLStreamReader((Source)source);
                ByteArrayInputStream stream = new ByteArrayInputStream(streamReader.getText().getBytes());
                DocumentBuilder builder2 = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document2 = builder2.parse(stream);
                xmlElementName = document2.getDocumentElement().getNodeName();
                xmlSource = this.getStringFromDocument(document2);
            }
        }
        catch (ParserConfigurationException exception) {
            throw new UncategorizedMappingException("There was a parser configuration exception.", (Throwable)exception);
        }
        catch (TransformerException exception) {
            throw new UncategorizedMappingException("There was a transformer exception.", (Throwable)exception);
        }
        catch (SAXException exception) {
            throw new UncategorizedMappingException("There was a SAX exception.", (Throwable)exception);
        }
        JAXBContext context = this.getInstance(xmlElementName);
        try {
            ByteArrayInputStream inputstream = new ByteArrayInputStream(xmlSource.getBytes());
            StreamSource newSource = new StreamSource(inputstream);
            Unmarshaller unmarshaller = context.createUnmarshaller();
            return unmarshaller.unmarshal((Source)newSource);
        }
        catch (JAXBException exception) {
            throw this.convertJaxbException(exception);
        }
    }

    private String getStringFromDocument(Document document) throws TransformerException {
        DOMSource domSource = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.transform(domSource, result);
        return ((Object)writer).toString();
    }

    private static JAXBContext getInstance(Class<?> clazz) {
        ContextDescriptor contextDescriptor = new ContextDescriptor(clazz.getName());
        if (cache.containsKey(contextDescriptor)) {
            return cache.get(contextDescriptor);
        }
        if (!clazz.isAnnotationPresent(XmlRootElement.class)) {
            throw new RuntimeException("The class specified is not declared with the XmlRootElement or XmlType annotation.");
        }
        JAXBContext jaxbContext = JaxbBasedMarshallerCacheService.newInstance(clazz);
        JaxbBasedMarshallerCacheService.cacheContext(JaxbBasedMarshallerCacheService.getXmlRootElementName(clazz), contextDescriptor, jaxbContext);
        return jaxbContext;
    }

    private JAXBContext getInstance(String xmlElementName) {
        if (contextCache.containsKey(xmlElementName)) {
            return cache.get(contextCache.get(xmlElementName));
        }
        Class<?> clazz = this.findClassForElement(xmlElementName);
        ContextDescriptor contextDescriptor = new ContextDescriptor(clazz.getName());
        JAXBContext jaxbContext = JaxbBasedMarshallerCacheService.newInstance(clazz);
        JaxbBasedMarshallerCacheService.cacheContext(xmlElementName, contextDescriptor, jaxbContext);
        return jaxbContext;
    }

    private static JAXBContext newInstance(Class<?> clazz) {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{clazz});
        }
        catch (JAXBException exception) {
            throw new RuntimeException("Exception occured creating JAXB unmarshaller for context=" + clazz, exception);
        }
    }

    private static void cacheContext(String xmlElementName, ContextDescriptor contextDescriptor, JAXBContext jaxbContext) {
        contextCache.put(xmlElementName, contextDescriptor);
        cache.put(contextDescriptor, jaxbContext);
    }

    private Class<?> findClassForElement(String xmlElementName) {
        for (String target : this._packages) {
            List<Class<?>> classes;
            try {
                classes = Reflection.getClassesForPackage(target);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            for (Class<?> clazz : classes) {
                if (!clazz.isAnnotationPresent(XmlRootElement.class)) continue;
                String name = clazz.getAnnotation(XmlRootElement.class).name();
                if (name.equals("##default")) {
                    String simpleName = clazz.getSimpleName();
                    name = simpleName.substring(0, 1).toLowerCase() + simpleName.substring(1);
                }
                if (!name.equals(xmlElementName)) continue;
                return clazz;
            }
        }
        return null;
    }

    protected String resolveBasePackage(String basePackage) {
        return ClassUtils.convertClassNameToResourcePath((String)SystemPropertyUtils.resolvePlaceholders((String)basePackage));
    }

    private static String getXmlRootElementName(Class<?> clazz) {
        if (!clazz.isAnnotationPresent(XmlRootElement.class)) {
            return null;
        }
        XmlRootElement annotation = clazz.getAnnotation(XmlRootElement.class);
        if (annotation.name().equals("##default")) {
            String simpleName = clazz.getSimpleName();
            return simpleName.substring(0, 1).toLowerCase() + simpleName.substring(1);
        }
        return annotation.name();
    }

    protected XmlMappingException convertJaxbException(JAXBException exception) {
        if (exception instanceof ValidationException) {
            return new ValidationFailureException("JAXB validation exception", (Throwable)exception);
        }
        if (exception instanceof MarshalException) {
            return new MarshallingFailureException("JAXB marshalling exception", (Throwable)exception);
        }
        if (exception instanceof UnmarshalException) {
            return new UnmarshallingFailureException("JAXB unmarshalling exception", (Throwable)exception);
        }
        return new UncategorizedMappingException("Unknown JAXB exception", (Throwable)exception);
    }

    private Document getDocument() throws ParserConfigurationException {
        return this._docBuilderFactory.newDocumentBuilder().newDocument();
    }

    private static class ContextDescriptor {
        private final String className;

        public boolean equals(Object o) {
            if (o instanceof ContextDescriptor) {
                ContextDescriptor un = (ContextDescriptor)o;
                return this.className.equals(un.className);
            }
            return false;
        }

        public int hashCode() {
            return this.className.hashCode();
        }

        ContextDescriptor(String className) {
            this.className = className.trim();
        }
    }
}

