/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.framework.utilities;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Reflection {
    public static List<Class<?>> getClassesForPackage(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        assert (loader != null);
        Enumeration<URL> resources = loader.getResources(packageName.replace('.', '/'));
        ArrayList<File> directories = new ArrayList<File>();
        ArrayList<URL> jarFiles = new ArrayList<URL>();
        ArrayList classes = new ArrayList();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            if (resource.getProtocol().equalsIgnoreCase("jar")) {
                jarFiles.add(resource);
                continue;
            }
            directories.add(new File(URLDecoder.decode(resource.getFile(), "UTF-8")));
        }
        for (URL jarFile : jarFiles) {
            classes.addAll(Reflection.findClassesInJarFile(jarFile, packageName));
        }
        for (File directory : directories) {
            classes.addAll(Reflection.findClasses(directory, packageName));
        }
        return classes;
    }

    public static Collection<? extends Class<?>> findClassesInJarFile(URL jarFile, String packageName) throws IOException, ClassNotFoundException {
        ArrayList classes = new ArrayList();
        JarURLConnection connection = (JarURLConnection)jarFile.openConnection();
        JarFile jar = connection.getJarFile();
        for (JarEntry entry : Collections.list(jar.entries())) {
            if (!entry.getName().startsWith(packageName.replace('.', '/')) || !entry.getName().endsWith(".class") || entry.getName().contains("$")) continue;
            String className = entry.getName().replace("/", ".").substring(0, entry.getName().length() - 6);
            classes.add(Class.forName(className));
        }
        return classes;
    }

    public static List<Class<?>> findClasses(File directory, String packageName) throws ClassNotFoundException, IOException {
        File[] files;
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            Class<?> _class;
            String fileName = file.getName();
            if (file.isDirectory()) {
                assert (!fileName.contains("."));
                classes.addAll(Reflection.findClasses(file, packageName + "." + fileName));
                continue;
            }
            if (!fileName.endsWith(".class") || fileName.contains("$")) continue;
            try {
                _class = Class.forName(packageName + '.' + fileName.substring(0, fileName.length() - 6));
            }
            catch (ExceptionInInitializerError e) {
                _class = Class.forName(packageName + '.' + fileName.substring(0, fileName.length() - 6), false, Thread.currentThread().getContextClassLoader());
            }
            classes.add(_class);
        }
        return classes;
    }

    public static Properties getPropertiesForClass(Class<? extends Object> parent) {
        String bundle = "/" + parent.getName().replace(".", "/") + ".properties";
        Properties properties = new Properties();
        try {
            properties.load(parent.getResourceAsStream(bundle));
        }
        catch (IOException e) {
            properties = null;
        }
        return properties;
    }
}

