/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.data;

import java.util.StringTokenizer;

public class PersonName {
    public static final int FAMILY = 0;
    public static final int GIVEN = 1;
    public static final int MIDDLE = 2;
    public static final int PREFIX = 3;
    public static final int SUFFIX = 4;
    public static final int SINGLE_BYTE = 0;
    public static final int IDEOGRAPHIC = 1;
    public static final int PHONETIC = 2;
    private final String[][] components = new String[][]{new String[5], new String[5], new String[5]};

    public PersonName() {
    }

    public PersonName(String s) {
        if (s == null) {
            return;
        }
        s = s.trim();
        int group = 0;
        int field = 0;
        try {
            StringTokenizer stk = new StringTokenizer(s, "^=", true);
            while (stk.hasMoreTokens()) {
                String tk = stk.nextToken();
                if (tk.equals("^")) {
                    ++field;
                    continue;
                }
                if (tk.equals("=")) {
                    ++group;
                    field = 0;
                    continue;
                }
                this.set(group, field, tk);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(s);
        }
    }

    public static PersonName[] toPersonNames(String[] ss) {
        if (ss == null) {
            return null;
        }
        PersonName[] pns = new PersonName[ss.length];
        int i = 0;
        while (i < pns.length) {
            pns[i] = new PersonName(ss[i]);
            ++i;
        }
        return pns;
    }

    public final String get(int field) {
        return this.get(0, field);
    }

    public final String get(int group, int field) {
        return this.components[group][field];
    }

    public final void set(int field, String s) {
        this.set(0, field, s);
    }

    public final void set(int group, int field, String s) {
        if (s != null && (s = s.trim()).length() == 0) {
            s = null;
        }
        this.components[group][field] = s;
    }

    public String toString() {
        int[] groupLen = new int[3];
        int[] compDelim = new int[3];
        int groupDelim = 0;
        int g = 0;
        while (g < 3) {
            int c = 0;
            while (c < 5) {
                if (this.components[g][c] != null) {
                    int n = g;
                    groupLen[n] = groupLen[n] + this.components[g][c].length();
                    compDelim[g] = c;
                    groupDelim = g;
                }
                ++c;
            }
            ++g;
        }
        int len = groupLen[0] + groupLen[1] + groupLen[2] + compDelim[0] + compDelim[1] + compDelim[2] + groupDelim;
        if (len == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(len);
        int g2 = 0;
        while (g2 <= groupDelim) {
            if (g2 != 0) {
                sb.append('=');
            }
            int c = 0;
            while (c <= compDelim[g2]) {
                if (c != 0) {
                    sb.append('^');
                }
                if (this.components[g2][c] != null) {
                    sb.append(this.components[g2][c]);
                }
                ++c;
            }
            ++g2;
        }
        return sb.toString();
    }

    public String componentGroupString(int group, boolean trim) {
        int len = 0;
        int delim = 0;
        int c = 0;
        while (c < 5) {
            if (this.components[group][c] != null) {
                len += this.components[group][c].length();
                delim = c;
            }
            ++c;
        }
        if (len == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(len + (trim ? delim : 4));
        int c2 = 0;
        while (c2 <= delim) {
            if (c2 != 0) {
                sb.append('^');
            }
            if (this.components[group][c2] != null) {
                sb.append(this.components[group][c2]);
            }
            ++c2;
        }
        if (!trim) {
            while (delim < 4) {
                sb.append('^');
                ++delim;
            }
        }
        return sb.toString();
    }
}

