/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.io;

import java.io.IOException;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.TransferSyntax;
import org.dcm4che2.data.VR;
import org.dcm4che2.io.DicomInputHandler;
import org.dcm4che2.io.DicomInputStream;
import org.dcm4che2.io.DicomOutputStream;
import org.dcm4che2.util.TagUtils;

public class TranscoderInputHandler
implements DicomInputHandler {
    private static int defaultBufferSize = 1024;
    private DicomOutputStream out;
    private byte[] buf;

    public TranscoderInputHandler(DicomOutputStream out) {
        this(out, defaultBufferSize);
    }

    public TranscoderInputHandler(DicomOutputStream out, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.out = out;
        this.buf = new byte[size + 7 & 0xFFFFFFF8];
    }

    @Override
    public boolean readValue(DicomInputStream in) throws IOException {
        int tag = in.tag();
        switch (tag) {
            case -73728: {
                this.transcodeItem(in);
                break;
            }
            case -73715: 
            case -73507: {
                in.readValue(in);
                break;
            }
            default: {
                if (TagUtils.isFileMetaInfoElement(tag) || TagUtils.isGroupLengthElement(tag)) {
                    in.readValue(in);
                    break;
                }
                this.transcodeAttribute(in);
            }
        }
        return true;
    }

    private void transcodeItem(DicomInputStream in) throws IOException {
        DicomElement sq = in.sq();
        VR sqvr = sq.vr();
        int vallen = in.valueLength();
        if (vallen == -1 || sqvr == VR.SQ) {
            this.out.writeHeader(-73728, null, -1);
            in.readValue(in);
            this.out.writeHeader(-73715, null, 0);
        } else {
            this.out.writeHeader(-73728, null, in.valueLength());
            this.transcodeValue(in, sqvr);
        }
    }

    private void transcodeAttribute(DicomInputStream in) throws IOException {
        int tag = in.tag();
        VR vr = in.vr();
        int vallen = in.valueLength();
        DicomObject attrs = in.getDicomObject();
        if (vallen == -1 || vr == VR.SQ) {
            this.out.writeHeader(tag, vr, -1);
            TransferSyntax prevTS = this.out.getTransferSyntax();
            if (vr == VR.UN) {
                this.out.setTransferSyntax(TransferSyntax.ImplicitVRLittleEndian);
            }
            in.readValue(in);
            attrs.remove(tag);
            this.out.writeHeader(-73507, null, 0);
            this.out.setTransferSyntax(prevTS);
        } else if (!TagUtils.isGroupLengthElement(tag)) {
            this.out.writeHeader(tag, vr, vallen);
            if (tag == 524293 || TagUtils.isPrivateCreatorDataElement(tag)) {
                byte[] val = in.readBytes(vallen);
                boolean bigEndian = in.getTransferSyntax().bigEndian();
                attrs.putBytes(tag, vr, val, bigEndian);
                this.out.write(val);
            } else {
                this.transcodeValue(in, vr);
            }
        }
    }

    private void transcodeValue(DicomInputStream in, VR vr) throws IOException {
        boolean toggleEndian = this.out.getTransferSyntax().bigEndian() ^ in.getTransferSyntax().bigEndian();
        int remaining = in.valueLength();
        while (remaining > 0) {
            int len = Math.min(remaining, this.buf.length);
            in.readFully(this.buf, 0, len);
            if (toggleEndian) {
                vr.toggleEndian(this.buf, 0, len);
            }
            this.out.write(this.buf, 0, len);
            remaining -= len;
        }
    }
}

