/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.media;

import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.media.ApplicationProfile;

public class BasicApplicationProfile
implements ApplicationProfile {
    private static final int[] PATIENT_KEYS = new int[]{524293, 0x100010, 0x100020};
    private static final int[] STUDY_KEYS = new int[]{524293, 524320, 524336, 524368, 528432, 0x20000D, 0x200010};
    private static final int[] SERIES_KEYS = new int[]{524293, 524384, 0x20000E, 0x200011};
    private static final int[] IMAGE_KEYS = new int[]{524293, 2097171};
    private static final int[] RT_DOSE_SET = new int[]{524293, 2097171, 805568522};
    private static final int[] RT_STRUCTURE_SET = new int[]{524293, 2097171, 805699586, 805699592, 805699593};
    private static final int[] RT_PLAN_KEYS = new int[]{524293, 2097171, 805961730, 805961734, 805961735};
    private static final int[] RT_TREATMENT_KEYS = new int[]{524293, 2097171, 805831248, 805831249};
    private static final int[] PRESENTATION_KEYS = new int[]{524293, 528661, 2097171, 0x700080, 7340161, 7340162, 7340163, 7340164};
    private static final int[] SR_DOCUMENT_KEYS = new int[]{524293, 524323, 524339, 2097171, 4235312, 4235331, 4236433, 4236435};
    private static final int[] KEY_OBJECT_DOCUMENT_KEYS = new int[]{524293, 524323, 524339, 2097171, 4235331};
    private static final int[] WAVEFROM_KEYS = new int[]{524293, 524323, 524339, 2097171};
    private static final int[] SPECTROSCOPY_KEYS = new int[]{524293, 524296, 524323, 524339, 561298, 2097171, 0x280008, 2621456, 2621457, 2658305, 2658306};
    private static final int[] RAWDATA_KEYS = WAVEFROM_KEYS;
    private static final int[] REGISTRATION_KEYS = new int[]{524293, 524323, 524339, 2097171, 0x700080, 7340161, 7340164};
    private static final int[] FIDUCIAL_KEYS = REGISTRATION_KEYS;
    private static final int[] HANGING_PROTOCOL_KEYS = new int[]{524293, 0x720002, 7471108, 7471110, 7471112, 7471114, 7471116, 7471124, 7471118};
    private static final int[] ENCAPSULATED_DOCUMENT_KEYS = new int[]{524293, 524323, 524339, 2097171, 4235331, 4325392, 4325394};
    private static final int[] HL7_STRUCTURED_DOCUMENT_KEYS = new int[]{524293, 4251649, 0x40E004, 4251654, 4325392};
    private static final int[] REAL_WORLD_VALUE_MAPPING_KEYS = REGISTRATION_KEYS;
    private int[] patientKeys = PATIENT_KEYS;
    private int[] studyKeys = STUDY_KEYS;
    private int[] seriesKeys = SERIES_KEYS;
    private int[] imageKeys = IMAGE_KEYS;
    private int[] rtDoseKeys = RT_DOSE_SET;
    private int[] rtStructureSetKeys = RT_STRUCTURE_SET;
    private int[] rtPlanKeys = RT_PLAN_KEYS;
    private int[] rtTreatmentRecordKeys = RT_TREATMENT_KEYS;
    private int[] presentationKeys = PRESENTATION_KEYS;
    private int[] waveformKeys = WAVEFROM_KEYS;
    private int[] srDocumentKeys = SR_DOCUMENT_KEYS;
    private int[] keyObjectDocumentKeys = KEY_OBJECT_DOCUMENT_KEYS;
    private int[] spectroscopyKeys = SPECTROSCOPY_KEYS;
    private int[] rawdataKeys = RAWDATA_KEYS;
    private int[] registrationKeys = REGISTRATION_KEYS;
    private int[] fiducialKeys = FIDUCIAL_KEYS;
    private int[] hangingProtocolKeys = HANGING_PROTOCOL_KEYS;
    private int[] encapsulatedDocumentKeys = ENCAPSULATED_DOCUMENT_KEYS;
    private int[] hl7StructuredDocumentKeys = HL7_STRUCTURED_DOCUMENT_KEYS;
    private int[] realWorldValueMappingKeys = REAL_WORLD_VALUE_MAPPING_KEYS;

    public final int[] getEncapsulatedDocumentKeys() {
        return (int[])this.encapsulatedDocumentKeys.clone();
    }

    public final void setEncapsulatedDocumentKeys(int[] encapsulatedDocumentKeys) {
        this.encapsulatedDocumentKeys = (int[])encapsulatedDocumentKeys.clone();
    }

    public final int[] getFiducialKeys() {
        return (int[])this.fiducialKeys.clone();
    }

    public final void setFiducialKeys(int[] fiducialKeys) {
        this.fiducialKeys = (int[])fiducialKeys.clone();
    }

    public final int[] getHangingProtocolKeys() {
        return (int[])this.hangingProtocolKeys.clone();
    }

    public final void setHangingProtocolKeys(int[] hangingProtocolKeys) {
        this.hangingProtocolKeys = (int[])hangingProtocolKeys.clone();
    }

    public final int[] getHl7StructuredDocumentKeys() {
        return (int[])this.hl7StructuredDocumentKeys.clone();
    }

    public final void setHl7StructuredDocumentKeys(int[] hl7StructuredDocumentKeys) {
        this.hl7StructuredDocumentKeys = (int[])hl7StructuredDocumentKeys.clone();
    }

    public final int[] getImageKeys() {
        return (int[])this.imageKeys.clone();
    }

    public final void setImageKeys(int[] imageKeys) {
        this.imageKeys = (int[])imageKeys.clone();
    }

    public final int[] getKeyObjectDocumentKeys() {
        return (int[])this.keyObjectDocumentKeys.clone();
    }

    public final void setKeyObjectDocumentKeys(int[] keyObjectDocumentKeys) {
        this.keyObjectDocumentKeys = (int[])keyObjectDocumentKeys.clone();
    }

    public final int[] getPatientKeys() {
        return (int[])this.patientKeys.clone();
    }

    public final void setPatientKeys(int[] patientKeys) {
        this.patientKeys = (int[])patientKeys.clone();
    }

    public final int[] getPresentationKeys() {
        return (int[])this.presentationKeys.clone();
    }

    public final void setPresentationKeys(int[] presentationKeys) {
        this.presentationKeys = (int[])presentationKeys.clone();
    }

    public final int[] getRawdataKeys() {
        return (int[])this.rawdataKeys.clone();
    }

    public final void setRawdataKeys(int[] rawdataKeys) {
        this.rawdataKeys = (int[])rawdataKeys.clone();
    }

    public final int[] getRealWorldValueMappingKeys() {
        return (int[])this.realWorldValueMappingKeys.clone();
    }

    public final void setRealWorldValueMappingKeys(int[] realWorldValueMappingKeys) {
        this.realWorldValueMappingKeys = (int[])realWorldValueMappingKeys.clone();
    }

    public final int[] getRegistrationKeys() {
        return (int[])this.registrationKeys.clone();
    }

    public final void setRegistrationKeys(int[] registrationKeys) {
        this.registrationKeys = (int[])registrationKeys.clone();
    }

    public final int[] getRtDoseKeys() {
        return (int[])this.rtDoseKeys.clone();
    }

    public final void setRtDoseKeys(int[] rtDoseKeys) {
        this.rtDoseKeys = (int[])rtDoseKeys.clone();
    }

    public final int[] getRtPlanKeys() {
        return (int[])this.rtPlanKeys.clone();
    }

    public final void setRtPlanKeys(int[] rtPlanKeys) {
        this.rtPlanKeys = (int[])rtPlanKeys.clone();
    }

    public final int[] getRtStructureSetKeys() {
        return (int[])this.rtStructureSetKeys.clone();
    }

    public final void setRtStructureSetKeys(int[] rtStructureSetKeys) {
        this.rtStructureSetKeys = (int[])rtStructureSetKeys.clone();
    }

    public final int[] getRtTreatmentRecordKeys() {
        return (int[])this.rtTreatmentRecordKeys.clone();
    }

    public final void setRtTreatmentRecordKeys(int[] rtTreatmentRecordKeys) {
        this.rtTreatmentRecordKeys = (int[])rtTreatmentRecordKeys.clone();
    }

    public final int[] getSeriesKeys() {
        return (int[])this.seriesKeys.clone();
    }

    public final void setSeriesKeys(int[] seriesKeys) {
        this.seriesKeys = (int[])seriesKeys.clone();
    }

    public final int[] getSpectroscopyKeys() {
        return (int[])this.spectroscopyKeys.clone();
    }

    public final void setSpectroscopyKeys(int[] spectroscopyKeys) {
        this.spectroscopyKeys = (int[])spectroscopyKeys.clone();
    }

    public final int[] getSrDocumentKeys() {
        return (int[])this.srDocumentKeys.clone();
    }

    public final void setSrDocumentKeys(int[] srDocumentKeys) {
        this.srDocumentKeys = (int[])srDocumentKeys.clone();
    }

    public final int[] getStudyKeys() {
        return (int[])this.studyKeys.clone();
    }

    public final void setStudyKeys(int[] studyKeys) {
        this.studyKeys = (int[])studyKeys.clone();
    }

    public final int[] getWaveformKeys() {
        return (int[])this.waveformKeys.clone();
    }

    public final void setWaveformKeys(int[] waveformKeys) {
        this.waveformKeys = (int[])waveformKeys.clone();
    }

    private DicomObject makeRecord(String type, int[] keys, DicomObject dcmobj) {
        BasicDicomObject rec = new BasicDicomObject();
        rec.putString(267312, VR.CS, type);
        dcmobj.subSet(keys).copyTo(rec);
        return rec;
    }

    private DicomObject makeRecord(String type, int[] keys, DicomObject dcmobj, String[] fileIDs) {
        DicomObject rec = this.makeRecord(type, keys, dcmobj);
        rec.putStrings(267520, VR.CS, fileIDs);
        rec.putString(267537, VR.UI, dcmobj.getString(131075));
        rec.putString(267536, VR.UI, dcmobj.getString(131074));
        rec.putString(267538, VR.UI, dcmobj.getString(131088));
        String relcuid = dcmobj.getString(524314);
        if (relcuid != null) {
            rec.putString(267546, VR.UI, relcuid);
        }
        return rec;
    }

    @Override
    public DicomObject makePatientDirectoryRecord(DicomObject dcmobj) {
        DicomObject rec = this.makeRecord("PATIENT", this.patientKeys, dcmobj);
        if (!rec.contains(0x100010)) {
            rec.putNull(0x100010, VR.PN);
        }
        if (!rec.containsValue(0x100020)) {
            rec.putString(0x100020, VR.LO, dcmobj.getString(0x20000D));
        }
        return rec;
    }

    @Override
    public DicomObject makeStudyDirectoryRecord(DicomObject dcmobj) {
        DicomObject rec = this.makeRecord("STUDY", this.studyKeys, dcmobj);
        return rec;
    }

    @Override
    public DicomObject makeSeriesDirectoryRecord(DicomObject dcmobj) {
        DicomObject rec = this.makeRecord("SERIES", this.seriesKeys, dcmobj);
        return rec;
    }

    @Override
    public DicomObject makeInstanceDirectoryRecord(DicomObject dcmobj, String[] fileIDs) {
        String cuid = dcmobj.getString(131074);
        switch (cuid.hashCode()) {
            case -525617006: {
                if (!"1.2.840.10008.5.1.4.1.1.66".equals(cuid)) break;
                return this.makeRawDataDirectoryRecord(dcmobj, fileIDs);
            }
            case -525617005: {
                if (!"1.2.840.10008.5.1.4.1.1.67".equals(cuid)) break;
                return this.makeRealWorldValueMappingDirectorRecord(dcmobj, fileIDs);
            }
            case 789790566: {
                if (!"1.2.840.10008.5.1.4.1.1.104.1".equals(cuid)) break;
                return this.makeEncapsulatedDocumentDirectorRecord(dcmobj, fileIDs);
            }
            case 792796575: {
                if (!"1.2.840.10008.5.1.4.1.1.481.2".equals(cuid)) break;
                return this.makeRTDoseDirectoryRecord(dcmobj, fileIDs);
            }
            case 792796576: {
                if (!"1.2.840.10008.5.1.4.1.1.481.3".equals(cuid)) break;
                return this.makeRTStructuredSetDirectoryRecord(dcmobj, fileIDs);
            }
            case 792796577: {
                if (!"1.2.840.10008.5.1.4.1.1.481.4".equals(cuid)) break;
                return this.makeRTTreatmentDirectoryRecord(dcmobj, fileIDs);
            }
            case 792796578: {
                if (!"1.2.840.10008.5.1.4.1.1.481.5".equals(cuid)) break;
                return this.makeRTPlanDirectoryRecord(dcmobj, fileIDs);
            }
            case 792796579: {
                if (!"1.2.840.10008.5.1.4.1.1.481.6".equals(cuid)) break;
                return this.makeRTTreatmentDirectoryRecord(dcmobj, fileIDs);
            }
            case 792796580: {
                if (!"1.2.840.10008.5.1.4.1.1.481.7".equals(cuid)) break;
                return this.makeRTTreatmentDirectoryRecord(dcmobj, fileIDs);
            }
            case 792796581: {
                if (!"1.2.840.10008.5.1.4.1.1.481.8".equals(cuid)) break;
                return this.makeRTPlanDirectoryRecord(dcmobj, fileIDs);
            }
            case 792796582: {
                if (!"1.2.840.10008.5.1.4.1.1.481.9".equals(cuid)) break;
                return this.makeRTTreatmentDirectoryRecord(dcmobj, fileIDs);
            }
            case 796487868: {
                if (!"1.2.840.10008.5.1.4.1.1.88.11".equals(cuid)) break;
                return this.makeSRDocumentDirectoryRecord(dcmobj, fileIDs);
            }
            case 796487900: {
                if (!"1.2.840.10008.5.1.4.1.1.88.22".equals(cuid)) break;
                return this.makeSRDocumentDirectoryRecord(dcmobj, fileIDs);
            }
            case 796487932: {
                if (!"1.2.840.10008.5.1.4.1.1.88.33".equals(cuid)) break;
                return this.makeSRDocumentDirectoryRecord(dcmobj, fileIDs);
            }
            case 796487960: {
                if (!"1.2.840.10008.5.1.4.1.1.88.40".equals(cuid)) break;
                return this.makeSRDocumentDirectoryRecord(dcmobj, fileIDs);
            }
            case 796487991: {
                if (!"1.2.840.10008.5.1.4.1.1.88.50".equals(cuid)) break;
                return this.makeSRDocumentDirectoryRecord(dcmobj, fileIDs);
            }
            case 796488000: {
                if (!"1.2.840.10008.5.1.4.1.1.88.59".equals(cuid)) break;
                return this.makeKeyObjectDirectoryRecord(dcmobj, fileIDs);
            }
            case 796488027: {
                if (!"1.2.840.10008.5.1.4.1.1.88.65".equals(cuid)) break;
                return this.makeSRDocumentDirectoryRecord(dcmobj, fileIDs);
            }
            case 796488029: {
                if (!"1.2.840.10008.5.1.4.1.1.88.67".equals(cuid)) break;
                return this.makeSRDocumentDirectoryRecord(dcmobj, fileIDs);
            }
            case 797116269: {
                if (!"1.2.840.10008.5.1.4.1.1.9.1.1".equals(cuid)) break;
                return this.makeWaveformDirectoryRecord(dcmobj, fileIDs);
            }
            case 797116270: {
                if (!"1.2.840.10008.5.1.4.1.1.9.1.2".equals(cuid)) break;
                return this.makeWaveformDirectoryRecord(dcmobj, fileIDs);
            }
            case 797116271: {
                if (!"1.2.840.10008.5.1.4.1.1.9.1.3".equals(cuid)) break;
                return this.makeWaveformDirectoryRecord(dcmobj, fileIDs);
            }
            case 797117230: {
                if (!"1.2.840.10008.5.1.4.1.1.9.2.1".equals(cuid)) break;
                return this.makeWaveformDirectoryRecord(dcmobj, fileIDs);
            }
            case 797118191: {
                if (!"1.2.840.10008.5.1.4.1.1.9.3.1".equals(cuid)) break;
                return this.makeWaveformDirectoryRecord(dcmobj, fileIDs);
            }
            case 797119152: {
                if (!"1.2.840.10008.5.1.4.1.1.9.4.1".equals(cuid)) break;
                return this.makeWaveformDirectoryRecord(dcmobj, fileIDs);
            }
            case 885739878: {
                if (!"1.2.840.10008.5.1.4.1.1.4.2".equals(cuid)) break;
                return this.makeSpectroscopyDirectoryRecord(dcmobj, fileIDs);
            }
            case 1688045877: {
                if (!"1.2.840.10008.5.1.4.1.1.11.1".equals(cuid)) break;
                return this.makePresentationStateDirectoryRecord(dcmobj, fileIDs);
            }
            case 1688045878: {
                if (!"1.2.840.10008.5.1.4.1.1.11.2".equals(cuid)) break;
                return this.makePresentationStateDirectoryRecord(dcmobj, fileIDs);
            }
            case 1688045879: {
                if (!"1.2.840.10008.5.1.4.1.1.11.3".equals(cuid)) break;
                return this.makePresentationStateDirectoryRecord(dcmobj, fileIDs);
            }
            case 1688045880: {
                if (!"1.2.840.10008.5.1.4.1.1.11.4".equals(cuid)) break;
                return this.makePresentationStateDirectoryRecord(dcmobj, fileIDs);
            }
            case 1688199637: {
                if (!"1.2.840.10008.5.1.4.1.1.66.1".equals(cuid)) break;
                return this.makeRegistrationDirectoryRecord(dcmobj, fileIDs);
            }
            case 1688199638: {
                if (!"1.2.840.10008.5.1.4.1.1.66.2".equals(cuid)) break;
                return this.makeFiducialDirectoryRecord(dcmobj, fileIDs);
            }
        }
        return this.makeImageDirectoryRecord(dcmobj, fileIDs);
    }

    @Override
    public DicomObject makeImageDirectoryRecord(DicomObject dcmobj, String[] fileIDs) {
        DicomObject rec = this.makeRecord("IMAGE", this.imageKeys, dcmobj, fileIDs);
        return rec;
    }

    @Override
    public DicomObject makeRTDoseDirectoryRecord(DicomObject dcmobj, String[] fileIDs) {
        DicomObject rec = this.makeRecord("RT DOSE", this.rtDoseKeys, dcmobj, fileIDs);
        return rec;
    }

    @Override
    public DicomObject makeRTStructuredSetDirectoryRecord(DicomObject dcmobj, String[] fileIDs) {
        DicomObject rec = this.makeRecord("RT STRUCTURE SET", this.rtStructureSetKeys, dcmobj, fileIDs);
        return rec;
    }

    @Override
    public DicomObject makeRTPlanDirectoryRecord(DicomObject dcmobj, String[] fileIDs) {
        DicomObject rec = this.makeRecord("RT PLAN", this.rtPlanKeys, dcmobj, fileIDs);
        return rec;
    }

    @Override
    public DicomObject makeRTTreatmentDirectoryRecord(DicomObject dcmobj, String[] fileIDs) {
        DicomObject rec = this.makeRecord("RT TREAT RECORD", this.rtTreatmentRecordKeys, dcmobj, fileIDs);
        return rec;
    }

    @Override
    public DicomObject makePresentationStateDirectoryRecord(DicomObject dcmobj, String[] fileIDs) {
        DicomObject rec = this.makeRecord("PRESENTATION ", this.presentationKeys, dcmobj, fileIDs);
        return rec;
    }

    @Override
    public DicomObject makeWaveformDirectoryRecord(DicomObject dcmobj, String[] fileIDs) {
        DicomObject rec = this.makeRecord("WAVEFORM", this.waveformKeys, dcmobj, fileIDs);
        return rec;
    }

    @Override
    public DicomObject makeSRDocumentDirectoryRecord(DicomObject dcmobj, String[] fileIDs) {
        DicomObject rec = this.makeRecord("SR DOCUMENT", this.srDocumentKeys, dcmobj, fileIDs);
        this.copyConceptNameModifiers(dcmobj, rec);
        return rec;
    }

    @Override
    public DicomObject makeKeyObjectDirectoryRecord(DicomObject dcmobj, String[] fileIDs) {
        DicomObject rec = this.makeRecord("KEY OBJECT DOC", this.keyObjectDocumentKeys, dcmobj, fileIDs);
        this.copyConceptNameModifiers(dcmobj, rec);
        return rec;
    }

    private void copyConceptNameModifiers(DicomObject dcmobj, DicomObject rec) {
        DicomElement objsq = dcmobj.get(4237104);
        if (objsq == null) {
            return;
        }
        DicomElement recsq = null;
        int i = 0;
        int n = objsq.countItems();
        while (i < n) {
            DicomObject item = objsq.getDicomObject(i);
            if ("HAS CONCEPT MOD".equals(item.getString(4235280))) {
                if (recsq == null) {
                    recsq = rec.putSequence(4237104);
                }
                recsq.addDicomObject(item);
            }
            ++i;
        }
    }

    @Override
    public DicomObject makeSpectroscopyDirectoryRecord(DicomObject dcmobj, String[] fileIDs) {
        DicomObject rec = this.makeRecord("SPECTROSCOPY", this.spectroscopyKeys, dcmobj, fileIDs);
        return rec;
    }

    @Override
    public DicomObject makeRawDataDirectoryRecord(DicomObject dcmobj, String[] fileIDs) {
        DicomObject rec = this.makeRecord("RAW DATA", this.rawdataKeys, dcmobj, fileIDs);
        return rec;
    }

    @Override
    public DicomObject makeRegistrationDirectoryRecord(DicomObject dcmobj, String[] fileIDs) {
        DicomObject rec = this.makeRecord("REGISTRATION", this.registrationKeys, dcmobj, fileIDs);
        return rec;
    }

    @Override
    public DicomObject makeFiducialDirectoryRecord(DicomObject dcmobj, String[] fileIDs) {
        DicomObject rec = this.makeRecord("FIDUCIAL", this.fiducialKeys, dcmobj, fileIDs);
        return rec;
    }

    @Override
    public DicomObject makeHangingProtocolDirectorRecord(DicomObject dcmobj, String[] fileIDs) {
        DicomObject rec = this.makeRecord("HANGING PROTOCOL", this.hangingProtocolKeys, dcmobj, fileIDs);
        return rec;
    }

    @Override
    public DicomObject makeEncapsulatedDocumentDirectorRecord(DicomObject dcmobj, String[] fileIDs) {
        DicomObject rec = this.makeRecord("ENCAP DOC", this.encapsulatedDocumentKeys, dcmobj, fileIDs);
        return rec;
    }

    @Override
    public DicomObject makeHL7StructuredDocumentDirectorRecord(DicomObject dcmobj, String[] fileIDs) {
        DicomObject rec = this.makeRecord("HL7 STRUC DOC", this.hl7StructuredDocumentKeys, dcmobj, fileIDs);
        return rec;
    }

    @Override
    public DicomObject makeRealWorldValueMappingDirectorRecord(DicomObject dcmobj, String[] fileIDs) {
        DicomObject rec = this.makeRecord("VALUE MAP", this.realWorldValueMappingKeys, dcmobj, fileIDs);
        return rec;
    }
}

