/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.xnat.fileManager;

import java.applet.Applet;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JFileChooser;
import javax.swing.JProgressBar;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;
import org.apache.commons.lang.StringEscapeUtils;
import org.nrg.net.JSESSIONIDCookie;
import org.nrg.xdat.bean.CatCatalogBean;
import org.nrg.xdat.bean.CatEntryBean;
import org.nrg.xdat.bean.CatEntryMetafieldBean;
import org.nrg.xdat.bean.base.BaseElement;
import org.nrg.xdat.bean.reader.XDATXMLReader;

public class DownloaderApplet
extends Applet {
    private Label _status = new Label("Initializing session...");
    private Label _caption = new Label("Overall progress:");
    private Label _localFolderLabel = new Label("Select local folder:");
    private TextField _localFolderEdit = new TextField();
    private Button _browseButton = new Button("Browse...");
    private JProgressBar _progress = new JProgressBar(0, 0, 100);
    private Button _startButton = new Button("Start");
    private final int DOWNLOAD_STOPPED = 0;
    private final int DOWNLOAD_FINISHED = 1;
    private final int DOWNLOAD_PROGRESS = 2;
    private final int SESSION_EMPTY = 0;
    private final int SESSION_PROGRESS = 1;
    private final int SESSION_FINISHED = 2;
    private int _downloadStatus = 0;
    private int _sessionStatus = 0;
    private final InitSessionThread _initSessionThread = new InitSessionThread();
    private final Downloader _downloader = new Downloader();
    private final List<DownloadFileDescriptor> _files = new ArrayList<DownloadFileDescriptor>();
    private File _saveDirectory = null;
    private long _totalSize = 0L;
    private long _totalCount = 0L;
    private long _fileCount = 1L;
    private long _compressedTotal = 0L;
    private long _uncompressedTotal = 0L;
    private double _compressionRatio = 3.0;
    private DownloadFileDescriptor _currentFile = null;
    private JSESSIONIDCookie _jsessionidCookie;
    private int _stayinAliveInterval;
    private boolean _showConsoleMessages;
    public static int GZ_THREADS = 0;

    @Override
    public void init() {
        this._downloadStatus = 0;
        this.console("init: file-downloader : 1.6", new Object[0]);
        this.setBackground(Color.white);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.setLayout(layout);
        Font lightFont = new Font("Verdana", 0, 11);
        Font boldFont = new Font("Verdana", 1, 11);
        int vertical = 5;
        int left = 5;
        int right = 5;
        int gap = 5;
        constraints.fill = 2;
        constraints.weightx = 0.0;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.insets = new Insets(vertical, left, gap, right);
        this._status.setFont(boldFont);
        this._status.setAlignment(0);
        this.AddPanelComponent(this._status, layout, constraints);
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        constraints.gridy = 2;
        constraints.fill = 2;
        constraints.insets = new Insets(0, left, gap, 0);
        this._localFolderLabel.setFont(lightFont);
        this._localFolderLabel.setAlignment(0);
        this.AddPanelComponent(this._localFolderLabel, layout, constraints);
        constraints.gridwidth = -1;
        constraints.weightx = 5.0;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, gap, 5);
        this._localFolderEdit.setFont(lightFont);
        this.AddPanelComponent(this._localFolderEdit, layout, constraints);
        constraints.gridwidth = 0;
        constraints.weightx = 0.0;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, gap + 2, right);
        this._browseButton.setFont(boldFont);
        this.AddPanelComponent(this._browseButton, layout, constraints);
        this._browseButton.addActionListener(new DownloadButtonListener());
        constraints.fill = 2;
        constraints.weightx = 0.0;
        constraints.gridwidth = 1;
        constraints.gridy = 3;
        constraints.insets = new Insets(0, left, vertical, 0);
        this._caption.setFont(lightFont);
        this._caption.setAlignment(0);
        this.AddPanelComponent(this._caption, layout, constraints);
        constraints.insets = new Insets(0, 0, vertical, 5);
        constraints.gridwidth = -1;
        constraints.weightx = 5.0;
        constraints.fill = 2;
        this._progress.setBackground(Color.white);
        this.AddPanelComponent(this._progress, layout, constraints);
        constraints.insets = new Insets(0, 0, vertical, right);
        constraints.gridwidth = 0;
        constraints.weightx = 0.0;
        this._startButton.setFont(boldFont);
        this.AddPanelComponent(this._startButton, layout, constraints);
        this._startButton.addActionListener(new DownloadButtonListener());
        this._jsessionidCookie = new JSESSIONIDCookie(this.getParameter("jsessionid"));
        String stayinAliveInterval = this.getParameter("keep-alive-interval");
        this._stayinAliveInterval = stayinAliveInterval == null ? 5 : Integer.parseInt(stayinAliveInterval);
        String showConsoleMessages = this.getParameter("show-console-messages");
        this._showConsoleMessages = showConsoleMessages != null && Boolean.parseBoolean(showConsoleMessages);
        this._downloader.start();
        this._initSessionThread.start();
    }

    protected void AddPanelComponent(Component comp, GridBagLayout layout, GridBagConstraints con) {
        layout.setConstraints(comp, con);
        this.add(comp);
    }

    protected synchronized void UpdateStatus(String s) {
        this._status.setText(s);
        if (this._sessionStatus == 0) {
            this._startButton.setEnabled(false);
            this.AllowFolderSelection(false);
            return;
        }
        switch (this._downloadStatus) {
            case 0: {
                this._startButton.setLabel("Start");
                this._startButton.setEnabled(true);
                break;
            }
            case 1: {
                this._startButton.setEnabled(false);
                this._browseButton.setEnabled(false);
                break;
            }
            case 2: {
                this._startButton.setLabel("Stop");
                this._startButton.setEnabled(true);
            }
        }
    }

    synchronized void AllowFolderSelection(boolean bAllow) {
        this._browseButton.setEnabled(bAllow);
        this._localFolderEdit.setEnabled(bAllow);
    }

    synchronized void AddFileToQueue(DownloadFileDescriptor file) {
        ++this._totalCount;
        this._files.add(file);
        if (this._totalSize != -1L) {
            this._totalSize = file.getLength() == -1L ? -1L : (this._totalSize += file.getLength().longValue());
        }
    }

    synchronized DownloadFileDescriptor RemoveFileFromQueue() {
        if (this._files.size() < 1) {
            return null;
        }
        return this._files.remove(0);
    }

    synchronized boolean IsFileQueueEmpty() {
        return this._files.size() < 1;
    }

    private URL buildUrl(String url) {
        try {
            String[] labelTypes;
            url = URLDecoder.decode(url, "UTF-8");
            url = StringEscapeUtils.unescapeXml((String)url);
            for (String labelType : labelTypes = new String[]{"scans", "resources", "reconstructions", "assessors"}) {
                url = DownloaderApplet.urlEncodeItemLabel(url, labelType);
            }
            this.console("Processing URL: " + url, new Object[0]);
            return new URL(url);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String urlEncodeItemLabel(String url, String labelType) throws Exception {
        String labelRegex = String.format("(?<=/%s/)(.+?)(?=/)", labelType);
        Matcher matcher = Pattern.compile(labelRegex).matcher(url);
        if (matcher.find() && matcher.groupCount() == 1) {
            return matcher.replaceFirst(URLEncoder.encode(matcher.group(1), "UTF-8"));
        }
        return url;
    }

    private void console(String message, Object ... objects) {
        if (this._showConsoleMessages) {
            System.out.println("*** CONSOLE: " + String.format(message, objects));
        }
    }

    class DownloadButtonListener
    implements ActionListener {
        DownloadButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == DownloaderApplet.this._browseButton) {
                if (DownloaderApplet.this._downloader.SelectLocalFolder()) {
                    DownloaderApplet.this._localFolderEdit.setText(DownloaderApplet.this._saveDirectory.getPath());
                }
            } else if (DownloaderApplet.this._downloadStatus == 0) {
                if (DownloaderApplet.this._saveDirectory != null) {
                    DownloaderApplet.this._downloadStatus = 2;
                    DownloaderApplet.this._startButton.setLabel("Stop");
                    DownloaderApplet.this.AllowFolderSelection(false);
                } else if (DownloaderApplet.this._downloader.SelectLocalFolder(DownloaderApplet.this._localFolderEdit.getText())) {
                    DownloaderApplet.this._downloadStatus = 2;
                    DownloaderApplet.this._startButton.setLabel("Stop");
                    DownloaderApplet.this.AllowFolderSelection(false);
                } else {
                    DownloaderApplet.this.UpdateStatus("Select local folder to start.");
                }
            } else if (DownloaderApplet.this._downloadStatus == 2) {
                DownloaderApplet.this._downloadStatus = 0;
                DownloaderApplet.this._startButton.setLabel("Resume");
            }
        }
    }

    class DownloadFileDescriptor {
        private final String _source;
        private final String _destination;
        private final Long _length;

        public DownloadFileDescriptor(String source, String destination, Long length) {
            this._source = source;
            this._destination = destination;
            this._length = length;
        }

        String getSource() {
            return this._source;
        }

        String getDestination() {
            return this._destination;
        }

        Long getLength() {
            return this._length;
        }
    }

    class Downloader
    extends Thread {
        final JFileChooser m_fc = new JFileChooser();
        private long m_TotalBytesLoaded = 0L;
        private int m_CurPercent = 0;
        private GZUnzipperPool pool = new GZUnzipperPool();
        public static final int ZIP_DOWNLOAD = 10240;

        Downloader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            int sleep_time = 500;
            ExecutorService executor = null;
            try {
                block9: do {
                    if (DownloaderApplet.this._sessionStatus == 0) {
                        DownloaderApplet.this.UpdateStatus("Initializing session...");
                        Thread.sleep(sleep_time);
                        continue;
                    }
                    switch (DownloaderApplet.this._downloadStatus) {
                        case 2: {
                            if (DownloaderApplet.this._saveDirectory == null) {
                                DownloaderApplet.this._downloadStatus = 0;
                                DownloaderApplet.this.UpdateStatus("Select local folder to save files.");
                                sleep_time = 500;
                                continue block9;
                            }
                            while (!DownloaderApplet.this.IsFileQueueEmpty() && DownloaderApplet.this._downloadStatus != 0) {
                                if (executor != null && !executor.isShutdown()) {
                                    executor.shutdownNow();
                                }
                                executor = this.initiateStayinAlive();
                                this.DownloadNextFile();
                            }
                            if (DownloaderApplet.this.IsFileQueueEmpty() && DownloaderApplet.this._sessionStatus == 2 && GZ_THREADS == 0) {
                                DownloaderApplet.this._downloadStatus = 1;
                                DownloaderApplet.this.UpdateStatus("Download complete.");
                                DownloaderApplet.this._progress.setValue(100);
                                executor.shutdown();
                            } else if (DownloaderApplet.this.IsFileQueueEmpty() && DownloaderApplet.this._sessionStatus == 2) {
                                DownloaderApplet.this.UpdateStatus("Finishing GZ extraction...");
                                DownloaderApplet.this._progress.setValue(99);
                            }
                            sleep_time = 100;
                            break;
                        }
                        case 0: {
                            sleep_time = 500;
                        }
                    }
                    Thread.sleep(sleep_time);
                } while (DownloaderApplet.this._downloadStatus != 1);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            finally {
                if (executor != null && !executor.isShutdown()) {
                    executor.shutdown();
                }
            }
        }

        private ExecutorService initiateStayinAlive() {
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            executor.scheduleAtFixedRate(new XnatPoker(), DownloaderApplet.this._stayinAliveInterval, DownloaderApplet.this._stayinAliveInterval, TimeUnit.MINUTES);
            return executor;
        }

        public boolean SelectLocalFolder() {
            this.m_fc.setFileSelectionMode(1);
            int res = this.m_fc.showSaveDialog(DownloaderApplet.this);
            if (res == 0) {
                DownloaderApplet.this._saveDirectory = this.m_fc.getSelectedFile();
                return true;
            }
            return false;
        }

        public boolean SelectLocalFolder(String path) {
            if (path.length() < 1) {
                return false;
            }
            DownloaderApplet.this._saveDirectory = new File(path);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int DownloadNextFile() {
            if (DownloaderApplet.this._saveDirectory == null) {
                return -1;
            }
            if (DownloaderApplet.this._currentFile == null) {
                DownloaderApplet.this._currentFile = DownloaderApplet.this.RemoveFileFromQueue();
            }
            if (DownloaderApplet.this._currentFile == null) {
                return 0;
            }
            DownloadFileDescriptor row = DownloaderApplet.this._currentFile;
            long localSize = 0L;
            String relative = row.getDestination();
            if (relative.equals("ZIP")) {
                try {
                    URL url = DownloaderApplet.this.buildUrl(row.getSource());
                    URLConnection connection = url.openConnection();
                    DownloaderApplet.this._jsessionidCookie.setInRequestHeader(connection);
                    DownloaderApplet.this.console("Open session with session ID %s to server at %s", new Object[]{DownloaderApplet.this._jsessionidCookie.toString(), url.toString()});
                    ZipInputStream zis = new ZipInputStream(new BufferedInputStream(connection.getInputStream()));
                    try {
                        ZipEntry entry;
                        byte[] data = new byte[10240];
                        while ((entry = zis.getNextEntry()) != null) {
                            if (!entry.isDirectory()) {
                                FilterOutputStream destination = null;
                                String name = entry.getName();
                                localSize += entry.getSize();
                                File f = new File(DownloaderApplet.this._saveDirectory, name);
                                DownloaderApplet.this.console("Servicing zip entry %s, %s bytes compressed to %s, storing in location %s", new Object[]{entry.getName(), this.formatSize(entry.getSize()), this.formatSize(entry.getCompressedSize()), f.getAbsolutePath()});
                                boolean success = false;
                                try {
                                    int count;
                                    f.getParentFile().mkdirs();
                                    FileOutputStream fos = new FileOutputStream(f);
                                    destination = new BufferedOutputStream(fos, 10240);
                                    long start = System.currentTimeMillis();
                                    while ((count = zis.read(data, 0, 10240)) != -1) {
                                        int percent;
                                        long end = System.currentTimeMillis();
                                        DownloaderApplet.this.console("Read %s bytes from zip entry %s in %d ms", new Object[]{this.formatSize(count), entry.getName(), end - start});
                                        start = System.currentTimeMillis();
                                        ((BufferedOutputStream)destination).write(data, 0, count);
                                        ((BufferedOutputStream)destination).flush();
                                        end = System.currentTimeMillis();
                                        DownloaderApplet.this.console("Wrote %s bytes from zip entry %s in %d ms", new Object[]{this.formatSize(count), entry.getName(), end - start});
                                        this.m_TotalBytesLoaded += (long)count;
                                        DownloaderApplet.this.console("%s total bytes loaded so far", new Object[]{this.formatSize(this.m_TotalBytesLoaded)});
                                        if (DownloaderApplet.this._sessionStatus != 2) {
                                            DownloaderApplet.this.console("FINISHED! %s total bytes loaded", new Object[]{this.formatSize(this.m_TotalBytesLoaded)});
                                            DownloaderApplet.this.UpdateStatus("Downloading, " + this.m_TotalBytesLoaded / 1024L + " KB completed");
                                        } else if (DownloaderApplet.this._totalSize == -1L) {
                                            percent = (int)(DownloaderApplet.this._fileCount * 100L / DownloaderApplet.this._totalCount);
                                            if (this.m_TotalBytesLoaded > 0x6400000L) {
                                                DownloaderApplet.this.UpdateStatus("Downloading, " + this.m_TotalBytesLoaded / 0x100000L + " MB completed");
                                            } else {
                                                DownloaderApplet.this.UpdateStatus("Downloading, " + this.m_TotalBytesLoaded / 1024L + " KB completed");
                                            }
                                            DownloaderApplet.this._progress.setValue(percent);
                                        } else {
                                            percent = (int)(this.m_TotalBytesLoaded * 100L / DownloaderApplet.this._totalSize);
                                            if (this.m_CurPercent < percent) {
                                                this.m_CurPercent = percent;
                                                if (DownloaderApplet.this._totalSize > 0x6400000L) {
                                                    DownloaderApplet.this.UpdateStatus("Downloading, " + percent + "% completed (" + this.m_TotalBytesLoaded / 0x100000L + " MB out of " + DownloaderApplet.this._totalSize / 0x100000L + " MB)");
                                                } else {
                                                    DownloaderApplet.this.UpdateStatus("Downloading, " + percent + "% completed (" + this.m_TotalBytesLoaded / 1024L + " KB out of " + DownloaderApplet.this._totalSize / 1024L + " KB)");
                                                }
                                                DownloaderApplet.this._progress.setValue(percent);
                                            }
                                        }
                                        start = System.currentTimeMillis();
                                    }
                                    ((BufferedOutputStream)destination).flush();
                                    success = true;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                finally {
                                    try {
                                        if (destination != null) {
                                            destination.close();
                                        }
                                    }
                                    catch (Exception ignored) {}
                                }
                                if (!success || !f.getName().endsWith(".gz")) continue;
                                this.pool.addFile(f);
                                continue;
                            }
                            File df = new File(DownloaderApplet.this._saveDirectory, entry.getName());
                            if (!df.exists()) {
                                df.mkdirs();
                            }
                            DownloaderApplet.this.console("Found directory %s, creating in location %s", new Object[]{entry.getName(), df.getAbsolutePath()});
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        zis.close();
                    }
                }
                catch (FileNotFoundException e) {
                    System.err.println("Couldn't find indicated resource, please check URL: " + e.getMessage());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    int bytesRead;
                    URL url = DownloaderApplet.this.buildUrl(row.getSource());
                    URLConnection connection = url.openConnection();
                    DownloaderApplet.this._jsessionidCookie.setInRequestHeader(connection);
                    boolean bUnzip = false;
                    if (relative.endsWith(".gz")) {
                        relative = relative.substring(0, relative.length() - 3);
                        bUnzip = true;
                    }
                    localSize = row.getLength();
                    File outFile = new File(DownloaderApplet.this._saveDirectory, relative);
                    outFile.getParentFile().mkdirs();
                    FileOutputStream out = new FileOutputStream(outFile);
                    InputStream bis = connection.getInputStream();
                    if (bUnzip) {
                        bis = new GZIPInputStream(bis);
                    }
                    BufferedOutputStream bos = new BufferedOutputStream(out);
                    byte[] buff = new byte[10240];
                    while (-1 != (bytesRead = bis.read(buff, 0, buff.length)) && DownloaderApplet.this._downloadStatus == 2) {
                        int percent;
                        bos.write(buff, 0, bytesRead);
                        bos.flush();
                        if (bUnzip) {
                            DownloaderApplet.this._uncompressedTotal = DownloaderApplet.this._uncompressedTotal + (long)bytesRead;
                            this.m_TotalBytesLoaded += (long)((double)bytesRead / DownloaderApplet.this._compressionRatio);
                        } else {
                            this.m_TotalBytesLoaded += (long)bytesRead;
                        }
                        if (DownloaderApplet.this._sessionStatus != 2) {
                            DownloaderApplet.this.UpdateStatus("Downloading, " + this.m_TotalBytesLoaded / 1024L + " KB completed, calculating total size...");
                            continue;
                        }
                        if (DownloaderApplet.this._totalSize == -1L) {
                            percent = (int)(DownloaderApplet.this._fileCount * 100L / DownloaderApplet.this._totalCount);
                            if (this.m_TotalBytesLoaded > 0x6400000L) {
                                DownloaderApplet.this.UpdateStatus("Downloading, " + this.m_TotalBytesLoaded / 0x100000L + " MB completed");
                            } else {
                                DownloaderApplet.this.UpdateStatus("Downloading, " + this.m_TotalBytesLoaded / 1024L + " KB completed");
                            }
                            DownloaderApplet.this._progress.setValue(percent);
                            continue;
                        }
                        percent = (int)(this.m_TotalBytesLoaded * 100L / DownloaderApplet.this._totalSize);
                        if (this.m_CurPercent >= percent) continue;
                        this.m_CurPercent = percent;
                        if (DownloaderApplet.this._totalSize > 0x6400000L) {
                            DownloaderApplet.this.UpdateStatus("Downloading, " + percent + "% completed (" + this.m_TotalBytesLoaded / 0x100000L + " MB out of " + DownloaderApplet.this._totalSize / 0x100000L + " MB)");
                        } else {
                            DownloaderApplet.this.UpdateStatus("Downloading, " + percent + "% completed (" + this.m_TotalBytesLoaded / 1024L + " KB out of " + DownloaderApplet.this._totalSize / 1024L + " KB)");
                        }
                        DownloaderApplet.this._progress.setValue(percent);
                    }
                    bis.close();
                    bos.flush();
                    bos.close();
                    ((OutputStream)out).close();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (DownloaderApplet.this._downloadStatus == 2) {
                DownloaderApplet.this._currentFile = null;
                DownloaderApplet.this._fileCount++;
                DownloaderApplet.this._compressedTotal = DownloaderApplet.this._compressedTotal + localSize;
                if (DownloaderApplet.this._compressedTotal > 0L && DownloaderApplet.this._uncompressedTotal > 0L) {
                    DownloaderApplet.this._compressionRatio = (double)DownloaderApplet.this._uncompressedTotal / (double)DownloaderApplet.this._compressedTotal;
                }
                return 1;
            }
            return 0;
        }

        public String formatSize(long size) {
            if (size < 1024L) {
                return size + " B";
            }
            int exp = (int)(Math.log(size) / Math.log(1024.0));
            return String.format("%.1f %sB", (double)size / Math.pow(1024.0, exp), Character.valueOf("KMGTPE".charAt(exp - 1)));
        }

        private class XnatPoker
        implements Runnable {
            private final Object[] WE_BELIEVE_IN_NOTHING = new Object[0];
            private final JSObject _jsContext = this.getJSContext();

            @Override
            public void run() {
                Object thing;
                if (this._jsContext != null && (thing = this._jsContext.call("handleOk", this.WE_BELIEVE_IN_NOTHING)) == null) {
                    DownloaderApplet.this.console(" *** Called handleOk() to keep session alive.", new Object[0]);
                }
            }

            private JSObject getJSContext() {
                Callable<JSObject> getWindow = new Callable<JSObject>(){

                    @Override
                    public JSObject call() throws JSException {
                        return JSObject.getWindow((Applet)DownloaderApplet.this);
                    }
                };
                ExecutorService es = Executors.newSingleThreadExecutor();
                try {
                    return (JSObject)es.invokeAny(Collections.singleton(getWindow), 10L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
    }

    public class GZUnzipper
    extends Thread {
        final File f;
        final GZUnzipperPool pool;

        public GZUnzipper(File _f, GZUnzipperPool _pool) {
            this.f = _f;
            this.pool = _pool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                InputStream is = null;
                OutputStream os = null;
                boolean success = false;
                try {
                    DownloaderApplet.this.console(this.f.getAbsolutePath(), new Object[0]);
                    is = new BufferedInputStream(new GZIPInputStream(new FileInputStream(this.f)));
                    File outFile = new File(this.f.getParent(), this.f.getName().substring(0, this.f.getName().length() - 3));
                    if (!outFile.exists()) {
                        int len;
                        os = new BufferedOutputStream(new FileOutputStream(outFile));
                        byte[] buf = new byte[1024];
                        while ((len = is.read(buf)) > 0) {
                            os.write(buf, 0, len);
                        }
                        os.flush();
                        success = true;
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    success = false;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    success = false;
                }
                finally {
                    try {
                        if (os != null) {
                            os.close();
                        }
                    }
                    catch (IOException ignored) {}
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException ignored) {}
                }
                if (success) {
                    this.f.delete();
                }
            }
            catch (Exception exception) {
            }
            finally {
                this.pool.endThread();
            }
        }
    }

    public class GZUnzipperPool {
        final int POOL_SIZE = 5;
        LinkedList<File> ll = new LinkedList();

        public void addFile(File f) {
            if (GZ_THREADS <= 5) {
                this.startJob(f);
            } else {
                this.ll.add(f);
            }
        }

        public void startJob(File f) {
            ++GZ_THREADS;
            GZUnzipper u = new GZUnzipper(f, this);
            u.start();
        }

        public void startThread() {
            if (this.ll.size() > 0) {
                File f = this.ll.removeFirst();
                this.startJob(f);
            }
        }

        public synchronized void endThread() {
            if (GZ_THREADS > 0) {
                --GZ_THREADS;
            }
            this.startThread();
        }
    }

    class InitSessionThread
    extends Thread {
        int nSessions = 0;

        InitSessionThread() {
        }

        @Override
        public void run() {
            DownloaderApplet.this.UpdateStatus("Initializing session...");
            DownloaderApplet.this._sessionStatus = 0;
            this.InitSession();
            DownloaderApplet.this._sessionStatus = 2;
        }

        private boolean TestFunction() {
            boolean bTest = false;
            if (!bTest) {
                return false;
            }
            DownloaderApplet.this._files.add(new DownloadFileDescriptor("NILPC154_TEST2\\arc001\\NILPC154_TEST2_4_1\\RAW\\1.MR.head_DHead.3.1.20070829.104546.718000.3532218994.dcm.gz", "http://localhost:8080/1.4/NILPC154_TEST2/arc001/NILPC154_TEST2_4_1/RAW/1.MR.head_DHead.3.1.20070829.104546.718000.3532218994.dcm.gz", 43154L));
            DownloaderApplet.this._totalSize = DownloaderApplet.this._totalSize + 43154L;
            DownloaderApplet.this._files.add(new DownloadFileDescriptor("NILPC154_TEST2\\arc001\\NILPC154_TEST2_4_1\\scan_3_catalog.xml", "http://localhost:8080/1.4/NILPC154_TEST2/arc001/NILPC154_TEST2_4_1/scan_3_catalog.xml", 1294L));
            DownloaderApplet.this._totalSize = DownloaderApplet.this._totalSize + 1294L;
            DownloaderApplet.this._files.add(new DownloadFileDescriptor("NILPC154_TEST2\\arc001\\NILPC154_TEST2_4_1\\RAW\\1.MR.head_DHead.3.3.20070829.104546.718000.9365419002.dcm.gz", "http://localhost:8080/1.4/NILPC154_TEST2/arc001/NILPC154_TEST2_4_1/RAW/1.MR.head_DHead.3.3.20070829.104546.718000.9365419002.dcm.gz", 37872L));
            DownloaderApplet.this._totalSize = DownloaderApplet.this._totalSize + 37872L;
            DownloaderApplet.this._files.add(new DownloadFileDescriptor("NILPC154_TEST2\\arc001\\NILPC154_TEST2_4_1\\scan_3_catalog.xml", "http://localhost:8080/1.4/NILPC154_TEST2/arc001/NILPC154_TEST2_4_1/scan_3_catalog.xml", 1294L));
            DownloaderApplet.this._totalSize = DownloaderApplet.this._totalSize + 1294L;
            return true;
        }

        public void LoadImages(CatCatalogBean cat) throws MalformedURLException {
            for (Object sub : cat.getSets_entryset()) {
                CatCatalogBean catalog = (CatCatalogBean)sub;
                this.LoadImages(catalog);
            }
            for (Object sub : cat.getEntries_entry()) {
                CatEntryBean entry = (CatEntryBean)sub;
                String format = entry.getFormat();
                if (format != null && format.equals("CATALOG")) {
                    DownloaderApplet.this.console("Loading sub-catalog: %s", new Object[]{entry.getUri()});
                    XDATXMLReader reader = new XDATXMLReader();
                    URL catalogURL = DownloaderApplet.this.buildUrl(entry.getUri());
                    try {
                        URLConnection connection = catalogURL.openConnection();
                        DownloaderApplet.this._jsessionidCookie.setInRequestHeader(connection);
                        BaseElement bean = reader.parse(connection.getInputStream());
                        if (!(bean instanceof CatCatalogBean)) continue;
                        this.LoadImages((CatCatalogBean)bean);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (format != null && format.equals("ZIP")) {
                    DownloadFileDescriptor s = new DownloadFileDescriptor(entry.getUri(), "ZIP", -1L);
                    DownloaderApplet.this.AddFileToQueue(s);
                    if (DownloaderApplet.this._sessionStatus == 0) {
                        DownloaderApplet.this._sessionStatus = 1;
                        DownloaderApplet.this.AllowFolderSelection(true);
                        DownloaderApplet.this.UpdateStatus("Select local folder.");
                    }
                    ++this.nSessions;
                    continue;
                }
                String relative = entry.getCachepath();
                Long size = null;
                for (int i = 0; i < entry.getMetafields_metafield().size(); ++i) {
                    CatEntryMetafieldBean meta = (CatEntryMetafieldBean)entry.getMetafields_metafield().get(i);
                    if (!meta.getName().equals("SIZE")) continue;
                    String s = meta.getMetafield();
                    size = Long.valueOf(s);
                }
                DownloadFileDescriptor s = new DownloadFileDescriptor(entry.getUri(), relative, size);
                DownloaderApplet.this.AddFileToQueue(s);
                if (DownloaderApplet.this._sessionStatus == 0) {
                    DownloaderApplet.this._sessionStatus = 1;
                    DownloaderApplet.this.AllowFolderSelection(true);
                    DownloaderApplet.this.UpdateStatus("Select local folder.");
                }
                ++this.nSessions;
            }
        }

        public boolean InitSession() {
            if (this.TestFunction()) {
                DownloaderApplet.this._sessionStatus = 1;
                DownloaderApplet.this.AllowFolderSelection(true);
                DownloaderApplet.this.UpdateStatus("Select local folder.");
                return true;
            }
            boolean bRes = true;
            ArrayList<String> sessions = new ArrayList<String>();
            int counter = 0;
            while (DownloaderApplet.this.getParameter("session" + counter) != null) {
                sessions.add(DownloaderApplet.this.getParameter("session" + counter++));
            }
            for (String session : sessions) {
                XDATXMLReader reader = new XDATXMLReader();
                try {
                    URL catalogURL = DownloaderApplet.this.buildUrl(session);
                    URLConnection connection = catalogURL.openConnection();
                    DownloaderApplet.this._jsessionidCookie.setInRequestHeader(connection);
                    BaseElement bean = reader.parse(connection.getInputStream());
                    if (!(bean instanceof CatCatalogBean)) continue;
                    this.LoadImages((CatCatalogBean)bean);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    bRes = false;
                }
            }
            return bRes || this.nSessions > 0;
        }
    }
}

