/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.ecat.edit;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;
import org.nrg.ecat.edit.EditECATASTParser;
import org.nrg.ecat.edit.EditECATLexer;
import org.nrg.ecat.edit.EditECATParser;
import org.nrg.ecat.edit.ScriptEvaluationException;
import org.nrg.ecat.edit.ScriptFunction;
import org.nrg.ecat.edit.Value;
import org.nrg.ecat.edit.Variable;
import org.nrg.ecat.edit.fn.Format;
import org.nrg.ecat.edit.fn.Lowercase;
import org.nrg.ecat.edit.fn.Match;
import org.nrg.ecat.edit.fn.Replace;
import org.nrg.ecat.edit.fn.Substring;
import org.nrg.util.GraphUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScriptApplicator {
    private final Logger logger = LoggerFactory.getLogger((Class)ScriptApplicator.class);
    private final EditECATASTParser astParser;

    public ScriptApplicator(InputStream script, Map functions) throws IOException, ScriptEvaluationException {
        if (null == script) {
            this.astParser = null;
        } else {
            try {
                this.logger.trace("setting up ECAT edit lexer");
                EditECATLexer lexer = new EditECATLexer((CharStream)new ANTLRInputStream(script));
                this.logger.trace("setting up ECAT edit parser");
                EditECATParser parser = new EditECATParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
                this.logger.trace("parsing ECAT edit script to AST");
                EditECATParser.script_return sr = parser.script();
                CommonTree ast = (CommonTree)sr.getTree();
                if (null == ast) {
                    this.logger.trace("unparseable");
                    this.astParser = null;
                } else {
                    this.astParser = new EditECATASTParser((TreeNodeStream)new CommonTreeNodeStream((Object)ast));
                    this.astParser.setFunction("substring", new Substring());
                    this.astParser.setFunction("format", new Format());
                    this.astParser.setFunction("lowercase", new Lowercase());
                    this.astParser.setFunction("replace", new Replace());
                    this.astParser.setFunction("match", new Match());
                    Iterator mei = functions.entrySet().iterator();
                    while (mei.hasNext()) {
                        Map.Entry me = mei.next();
                        this.logger.trace("adding function {}", me);
                        this.astParser.setFunction((String)me.getKey(), (ScriptFunction)me.getValue());
                    }
                    this.logger.trace("parsing ECAT edit AST");
                    this.astParser.script();
                    this.logger.trace("script-defined variables: {}", (Object)this.astParser.getVariables());
                }
            }
            catch (RecognitionException e) {
                this.logger.error("error parsing ECAT script", (Throwable)e);
                throw new ScriptEvaluationException("error parsing script", e);
            }
        }
    }

    public Variable getVariable(String label) {
        return this.astParser.getVariable(label);
    }

    public Map getVariables() {
        return null == this.astParser ? Collections.EMPTY_MAP : this.astParser.getVariables();
    }

    public List getSortedVariables(Collection excluding) {
        if (null == this.astParser) {
            return Collections.EMPTY_LIST;
        }
        LinkedHashMap graph = new LinkedHashMap();
        Iterator i = this.astParser.getVariables().values().iterator();
        while (i.hasNext()) {
            Variable v = (Variable)i.next();
            if (excluding.contains(v)) continue;
            Value iv = v.getInitialValue();
            ArrayList<Variable> dependencies = new ArrayList<Variable>();
            if (null != iv) {
                Iterator di = iv.getVariables().iterator();
                while (di.hasNext()) {
                    Variable dv = (Variable)di.next();
                    if (excluding.contains(dv.getName())) continue;
                    dependencies.add(dv);
                }
            }
            graph.put(v, dependencies);
        }
        return GraphUtils.topologicalSort(graph);
    }

    public List getSortedVariables(String[] excluding) {
        return this.getSortedVariables(Arrays.asList(excluding));
    }

    public List getSortedVariables() {
        return this.getSortedVariables(Collections.EMPTY_LIST);
    }
}

