/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.xdat.bean.base;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import org.apache.commons.lang.StringEscapeUtils;

public abstract class BaseElement {
    public static final String field_data = "DATA";
    public static final String field_single_reference = "SINGLE";
    public static final String field_multi_reference = "MULTI";
    public static final String field_inline_repeater = "INLINE";
    public static final String field_LONG_DATA = "LONG_DATA";
    public static final String field_NO_CHILD = "NO_CHILD";
    private static List<String> formatsDT = Arrays.asList("yyyy-MM-dd'T'HH:mm:ss.SSS".intern(), "yyyy-MM-dd'T'HH:mm:ss".intern(), "EEE MMM dd HH:mm:ss z yyyy".intern(), "yyyy-MM-dd HH:mm:ss.S".intern(), "yyyy-MM-dd HH:mm:ss".intern(), "EEE MMM dd HH:mm:ss.S".intern(), "yyyy-MM-dd HH:mm:ss z".intern(), "EEE MMM dd HH:mm:ss".intern(), "EEE MMM dd HH:mm:ss z".intern(), "MM/dd/yyyy".intern(), "yyyy-MM-dd".intern());

    public java.util.Date formatDate(String s) {
        try {
            return BaseElement.parseDate(s);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public java.util.Date formatDateTime(String s) {
        try {
            return BaseElement.parseDateTime(s);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public java.util.Date formatTime(String s) {
        try {
            return BaseElement.parseTime(s);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Double formatDouble(String s) {
        try {
            if (s.equalsIgnoreCase("inf")) {
                s = "Infinity";
            } else if (s.equalsIgnoreCase("-inf")) {
                s = "-Infinity";
            }
            return Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Integer formatInteger(String s) {
        try {
            return Integer.valueOf(s);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Boolean formatBoolean(String s) {
        if (s.equals("0") || s.equalsIgnoreCase("false") || s.equalsIgnoreCase("f")) {
            return Boolean.FALSE;
        }
        if (s.equals("1") || s.equalsIgnoreCase("true") || s.equalsIgnoreCase("t")) {
            return Boolean.TRUE;
        }
        throw new IllegalArgumentException("Unable to translate '" + s + "' to a boolean value.");
    }

    public static java.util.Date parseDate(String s) throws ParseException {
        if (s.indexOf("'") != -1) {
            s = BaseElement.ReplaceStr(s, "'", "");
        }
        if (s == null) {
            return null;
        }
        try {
            return DateFormat.getInstance().parse(s);
        }
        catch (ParseException e) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
            try {
                return sdf.parse(s);
            }
            catch (ParseException e1) {
                sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", Locale.US);
                try {
                    return sdf.parse(s);
                }
                catch (ParseException e2) {
                    sdf = new SimpleDateFormat("MM/dd/yyyy", Locale.US);
                    try {
                        return sdf.parse(s);
                    }
                    catch (ParseException e3) {
                        sdf = new SimpleDateFormat("MM.dd.yyyy", Locale.US);
                        return sdf.parse(s);
                    }
                }
            }
        }
    }

    public static String ReplaceStr(String _base, String _old, String _new) {
        if (_base.indexOf(_old) == -1) {
            return _base;
        }
        StringBuffer sb = new StringBuffer();
        while (_base.indexOf(_old) != -1) {
            String post;
            String pre = _base.substring(0, _base.indexOf(_old));
            try {
                post = _base.substring(_base.indexOf(_old) + _old.length());
            }
            catch (RuntimeException e) {
                post = "";
            }
            sb.append(pre).append(_new);
            _base = post;
        }
        sb.append(_base);
        return sb.toString();
    }

    public static java.util.Date parseDateTime(String s) throws ParseException {
        if (s.indexOf("'") != -1) {
            s = BaseElement.ReplaceStr(s, "'", "");
        }
        if (s == null) {
            return null;
        }
        try {
            return DateFormat.getInstance().parse(s);
        }
        catch (ParseException e) {
            for (String format : formatsDT) {
                SimpleDateFormat sdf = new SimpleDateFormat(format, Locale.US);
                try {
                    return sdf.parse(s);
                }
                catch (ParseException e1) {
                }
            }
            throw e;
        }
    }

    public static java.util.Date parseTime(String s) throws ParseException {
        if (s.indexOf("'") != -1) {
            s = BaseElement.ReplaceStr(s, "'", "");
        }
        if (s == null) {
            return null;
        }
        try {
            return DateFormat.getInstance().parse(s);
        }
        catch (ParseException e) {
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss", Locale.US);
            try {
                return sdf.parse(s);
            }
            catch (ParseException e1) {
                sdf = new SimpleDateFormat("HH:mm:ss z", Locale.US);
                return sdf.parse(s);
            }
        }
    }

    public void setDataField(String xmlPath, String s) throws UnknownFieldException {
        if (!"schemaLocation".equals(xmlPath)) {
            throw new UnknownFieldException(xmlPath);
        }
    }

    public void setReferenceField(String xmlPath, BaseElement s) throws UnknownFieldException {
        throw new UnknownFieldException(xmlPath);
    }

    public String getFieldType(String xmlPath) throws UnknownFieldException {
        throw new UnknownFieldException(xmlPath);
    }

    public String getReferenceFieldName(String xmlPath) throws UnknownFieldException {
        throw new UnknownFieldException(xmlPath);
    }

    public Object getReferenceField(String xmlPath) throws UnknownFieldException {
        throw new UnknownFieldException(xmlPath);
    }

    public Object getDataFieldValue(String xmlPath) throws UnknownFieldException {
        throw new UnknownFieldException(xmlPath);
    }

    public ArrayList getAllFields() {
        return new ArrayList();
    }

    public String ValueParser(Object o, String type) {
        if (o.getClass().getName().equalsIgnoreCase("[B")) {
            byte[] b = (byte[])o;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                baos.write(b);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return baos.toString();
        }
        if (type.equalsIgnoreCase("string")) {
            StringBuilder input = new StringBuilder((String)o);
            for (int i = 0; i < input.length(); ++i) {
                if (input.charAt(i) != Byte.decode("0x00").byteValue()) continue;
                input.setCharAt(i, ' ');
            }
            return StringEscapeUtils.escapeXml((String)input.toString());
        }
        if (type.equalsIgnoreCase("boolean")) {
            if (o.toString().equalsIgnoreCase("true") || o.toString().equalsIgnoreCase("1")) {
                return "1";
            }
            return "0";
        }
        if (type.equalsIgnoreCase("float")) {
            if (o.toString().equalsIgnoreCase("Infinity")) {
                return "INF";
            }
            if (o.toString().equalsIgnoreCase("-Infinity")) {
                return "-INF";
            }
            return o.toString();
        }
        if (type.equalsIgnoreCase("double")) {
            if (o.toString().equalsIgnoreCase("Infinity")) {
                return "INF";
            }
            if (o.toString().equalsIgnoreCase("-Infinity")) {
                return "-INF";
            }
            return o.toString();
        }
        if (type.equalsIgnoreCase("decimal")) {
            if (o.toString().equalsIgnoreCase("Infinity")) {
                return "INF";
            }
            if (o.toString().equalsIgnoreCase("-Infinity")) {
                return "-INF";
            }
            return o.toString();
        }
        if (type.equalsIgnoreCase("integer")) {
            return o.toString();
        }
        if (type.equalsIgnoreCase("nonPositiveInteger")) {
            return o.toString();
        }
        if (type.equalsIgnoreCase("negativeInteger")) {
            return o.toString();
        }
        if (type.equalsIgnoreCase("long")) {
            return o.toString();
        }
        if (type.equalsIgnoreCase("int")) {
            return o.toString();
        }
        if (type.equalsIgnoreCase("short")) {
            return o.toString();
        }
        if (type.equalsIgnoreCase("byte")) {
            return o.toString();
        }
        if (type.equalsIgnoreCase("nonNegativeInteger")) {
            return o.toString();
        }
        if (type.equalsIgnoreCase("unsignedLong")) {
            return o.toString();
        }
        if (type.equalsIgnoreCase("unsignedInt")) {
            return o.toString();
        }
        if (type.equalsIgnoreCase("unsignedShort")) {
            return o.toString();
        }
        if (type.equalsIgnoreCase("unsignedByte")) {
            return o.toString();
        }
        if (type.equalsIgnoreCase("positiveInteger")) {
            return o.toString();
        }
        if (type.equalsIgnoreCase("time")) {
            if (o.getClass().getName().equalsIgnoreCase("java.util.Date")) {
                java.util.Date d = (java.util.Date)o;
                StringBuffer sb = new StringBuffer();
                SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
                sb.append(formatter.format(d));
                return sb.toString();
            }
            if (o.getClass().getName().equalsIgnoreCase("java.sql.Date")) {
                Date d = (Date)o;
                StringBuffer sb = new StringBuffer();
                sb.append(d.getHours());
                sb.append(":");
                sb.append(d.getMinutes());
                sb.append(":");
                sb.append(d.getSeconds());
                return sb.toString();
            }
            if (o.getClass().getName().equalsIgnoreCase("java.sql.Timestamp")) {
                java.util.Date d = (java.util.Date)o;
                StringBuffer sb = new StringBuffer();
                SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
                sb.append(formatter.format(d));
                return sb.toString();
            }
            return o.toString();
        }
        if (type.equalsIgnoreCase("date")) {
            java.util.Date d;
            if (o instanceof String) {
                try {
                    d = this.formatDate((String)o);
                    o = d;
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            if (o instanceof java.util.Date) {
                d = (java.util.Date)o;
                StringBuffer sb = new StringBuffer();
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                sb.append(formatter.format(d));
                return sb.toString();
            }
            if (o instanceof Date) {
                d = (Date)o;
                StringBuffer sb = new StringBuffer();
                sb.append(d.getYear());
                sb.append("-");
                sb.append(d.getMonth());
                sb.append("-");
                sb.append(d.getDate());
                return sb.toString();
            }
            if (o instanceof Timestamp) {
                d = (java.util.Date)o;
                StringBuffer sb = new StringBuffer();
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                sb.append(formatter.format(d));
                return sb.toString();
            }
            return o.toString();
        }
        if (type.equalsIgnoreCase("dateTime")) {
            java.util.Date d;
            if (o instanceof String) {
                try {
                    d = this.formatDateTime((String)o);
                    o = d;
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            if (o.getClass().getName().equalsIgnoreCase("java.util.Date")) {
                d = (java.util.Date)o;
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
                String s = formatter.format(d);
                return s;
            }
            if (o.getClass().getName().equalsIgnoreCase("java.sql.Date")) {
                d = (Date)o;
                StringBuffer sb = new StringBuffer();
                sb.append(d.getYear());
                sb.append("-");
                sb.append(d.getMonth());
                sb.append("-");
                sb.append(d.getDate());
                sb.append("T");
                sb.append(((Date)d).getHours());
                sb.append(":");
                sb.append(((Date)d).getMinutes());
                sb.append(":");
                sb.append(((Date)d).getSeconds());
                return sb.toString();
            }
            if (o.getClass().getName().equalsIgnoreCase("java.sql.Timestamp")) {
                d = (java.util.Date)o;
                StringBuffer sb = new StringBuffer();
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                sb.append(formatter.format(d));
                return sb.toString();
            }
            return o.toString();
        }
        return o.toString();
    }

    public BaseElement copy() {
        try {
            BaseElement base2 = (BaseElement)this.getClass().newInstance();
            for (int i = 0; i < this.getAllFields().size(); ++i) {
                try {
                    String path = (String)this.getAllFields().get(i);
                    String ft = this.getFieldType(path);
                    if (ft.equals(field_data) || ft.equals(field_LONG_DATA)) {
                        Object v1 = this.getDataFieldValue(path);
                        if (v1 != null && !(v1 instanceof java.util.Date)) {
                            base2.setDataField(path, v1.toString());
                            continue;
                        }
                        if (v1 == null) continue;
                        base2.setDataField(path, new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS").format((java.util.Date)v1));
                        continue;
                    }
                    Object o1 = this.getReferenceField(path);
                    if (o1 instanceof ArrayList) {
                        ArrayList children1 = (ArrayList)o1;
                        for (int j = 0; j < children1.size(); ++j) {
                            base2.setReferenceField(path, ((BaseElement)children1.get(j)).copy());
                        }
                        continue;
                    }
                    if (o1 == null) continue;
                    BaseElement child1 = (BaseElement)o1;
                    base2.setReferenceField(path, child1.copy());
                    continue;
                }
                catch (UnknownFieldException e) {
                    e.printStackTrace();
                }
            }
            return base2;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected void addXMLAtts(Writer writer) throws IOException {
    }

    protected boolean addXMLBody(Writer writer, int header) throws IOException {
        return false;
    }

    public abstract String getSchemaElementName();

    public abstract void toXML(Writer var1, boolean var2) throws IOException;

    public String createHeader(int i) {
        String header = "";
        int counter = 0;
        while (counter++ < i) {
            header = header + this.getHeaderString();
        }
        return header;
    }

    public String getHeaderString() {
        return "\t";
    }

    protected boolean hasXMLBodyContent() {
        return false;
    }

    protected TreeMap getXMLAtts() {
        return new TreeMap();
    }

    public abstract String getFullSchemaElementName();

    public String getXSIType() {
        return this.getFullSchemaElementName();
    }

    public void toXML(Writer os) throws Exception {
        this.toXML(os, false);
    }

    public class FormatException
    extends Exception {
        public FormatException(String s) {
            super(s);
        }

        public FormatException(Exception s) {
            super(s);
        }

        public FormatException(String s, Exception e) {
            super(s, e);
        }
    }

    public class UnknownFieldException
    extends Exception {
        public UnknownFieldException(String s) {
            super(s);
        }

        public UnknownFieldException(Exception s) {
            super(s);
        }

        public UnknownFieldException(String s, Exception e) {
            super(s, e);
        }
    }
}

