/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.xdat.bean.reader;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.nrg.xdat.bean.ClassMapping;
import org.nrg.xdat.bean.base.BaseElement;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XDATXMLReader
extends DefaultHandler {
    static Logger logger = Logger.getLogger(XDATXMLReader.class);
    private BaseElement root = null;
    private SAXReaderObject current = null;
    private String tempValue = null;
    Hashtable uriToPrefixMapping = new Hashtable();
    Hashtable prefixToURIMapping = new Hashtable();
    String xsi = null;

    public BaseElement getItem() {
        return this.root;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.uriToPrefixMapping.put(uri, prefix);
        this.prefixToURIMapping.put(prefix, uri);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String temp;
        if (length > 0 && (temp = new String(ch, start, length)).length() != 0 && this.isValidText(temp)) {
            this.tempValue = this.tempValue != null ? (this.current.insertNewLine() ? this.tempValue + "\n" + temp : this.tempValue + temp) : temp;
        }
    }

    public BaseElement getBaseElement(String uri, String localName) throws SAXException {
        return this.getBaseElement(uri + ":" + localName);
    }

    public BaseElement getBaseElement(String name) throws SAXException {
        String className = ClassMapping.GetInstance().ELEMENTS.get(name);
        if (className == null) {
            throw new SAXException("Unknown type= " + name);
        }
        try {
            Class<?> c = Class.forName(className);
            return (BaseElement)c.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new SAXException("Unknown class: " + className, e);
        }
        catch (InstantiationException e) {
            throw new SAXException("Unable to instantiate class: " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new SAXException("Illegal access of class: " + className, e);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        block33: {
            this.tempValue = null;
            if (this.root == null) {
                BaseElement item = this.getBaseElement(uri, localName);
                if (attributes != null) {
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        String local = attributes.getLocalName(i);
                        String value = attributes.getValue(i);
                        if (value.equalsIgnoreCase("")) continue;
                        try {
                            item.setDataField(local, value);
                            continue;
                        }
                        catch (BaseElement.UnknownFieldException e1) {
                            logger.error((Object)"", (Throwable)e1);
                            continue;
                        }
                        catch (IllegalArgumentException e1) {
                            throw new SAXException("Invalid value for attribute '" + local + "'");
                        }
                    }
                }
                this.current = new SAXReaderObject(item, null);
                this.root = item;
            } else {
                this.current.addHeader(localName);
                String current_header = this.current.getHeader();
                BaseElement currentItem = this.current.getItem();
                String TYPE = null;
                try {
                    TYPE = currentItem.getFieldType(current_header);
                }
                catch (BaseElement.UnknownFieldException e) {
                    // empty catch block
                }
                if (TYPE != null && (TYPE.equals("INLINE") || TYPE.equals("MULTI") || TYPE.equals("SINGLE") || TYPE.equals("NO_CHILD"))) {
                    String foreignElement = null;
                    if (attributes != null) {
                        for (int i = 0; i < attributes.getLength(); ++i) {
                            if (!attributes.getURI(i).equalsIgnoreCase("http://www.w3.org/2001/XMLSchema-instance") || !attributes.getLocalName(i).equalsIgnoreCase("type")) continue;
                            foreignElement = attributes.getValue(i);
                            int index = foreignElement.indexOf(":");
                            if (index == -1) break;
                            foreignElement = this.prefixToURIMapping.get(foreignElement.substring(0, index)) + foreignElement.substring(index);
                            break;
                        }
                    }
                    try {
                        if (foreignElement == null) {
                            foreignElement = currentItem.getReferenceFieldName(current_header);
                        }
                        BaseElement item = this.getBaseElement(foreignElement);
                        if (attributes != null) {
                            for (int i = 0; i < attributes.getLength(); ++i) {
                                if (attributes.getURI(i).equalsIgnoreCase("http://www.w3.org/2001/XMLSchema-instance") && attributes.getLocalName(i).equalsIgnoreCase("type")) continue;
                                String local = attributes.getLocalName(i);
                                String value = attributes.getValue(i);
                                if (value.equalsIgnoreCase("")) continue;
                                try {
                                    item.setDataField(local, value);
                                    continue;
                                }
                                catch (BaseElement.UnknownFieldException e1) {
                                    logger.error((Object)"", (Throwable)e1);
                                    continue;
                                }
                                catch (IllegalArgumentException e1) {
                                    throw new SAXException("Invalid value for attribute '" + local + "'");
                                }
                            }
                        }
                        try {
                            this.current.getItem().setReferenceField(current_header, item);
                            this.current = new SAXReaderObject(item, this.current, TYPE);
                            if (!TYPE.equals("INLINE") && !TYPE.equals("NO_CHILD")) break block33;
                            this.current.setIsInlineRepeater(true);
                            boolean match = false;
                            try {
                                if (item.getFieldType(localName) != null) {
                                    this.current.addHeader(localName);
                                    match = true;
                                }
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                            if (!match && item.getFieldType(item.getSchemaElementName()) != null) {
                                this.current.addHeader(item.getSchemaElementName());
                                match = true;
                            }
                            if (!match) {
                                throw new SAXException("Invalid XML '" + item.getSchemaElementName() + ":" + current_header + "'");
                            }
                            break block33;
                        }
                        catch (BaseElement.UnknownFieldException e2) {
                            throw new SAXException("Invalid XML '" + item.getSchemaElementName() + ":" + current_header + "'");
                        }
                        catch (Exception e2) {
                            throw new SAXException(e2.getMessage());
                        }
                    }
                    catch (BaseElement.UnknownFieldException e) {
                        logger.error((Object)"", (Throwable)e);
                        throw new SAXException("INVALID XML STRUCTURE:");
                    }
                }
                this.current.setFIELD_TYPE(TYPE);
                if (attributes != null) {
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        String local = attributes.getLocalName(i);
                        String value = attributes.getValue(i);
                        if (value.equalsIgnoreCase("")) continue;
                        try {
                            currentItem.setDataField(current_header + "/" + local, value);
                            continue;
                        }
                        catch (BaseElement.UnknownFieldException e1) {
                            logger.error((Object)e1);
                            throw new SAXException("Unknown field '" + current_header + "/" + local + "'");
                        }
                        catch (IllegalArgumentException e1) {
                            throw new SAXException("Invalid value for attribute '" + local + "'");
                        }
                    }
                }
            }
        }
    }

    private boolean isValidText(String s) {
        if (s == null) {
            return false;
        }
        s = XDATXMLReader.RemoveChar(s.trim(), '\n');
        return (s = XDATXMLReader.RemoveChar(s, '\t')) != null && !s.equals("");
    }

    public static String RemoveChar(String _base, char _old) {
        while (_base.indexOf(_old) != -1) {
            int index = _base.indexOf(_old);
            if (index == 0) {
                _base = _base.substring(1);
                continue;
            }
            if (index == _base.length() - 1) {
                _base = _base.substring(0, index);
                continue;
            }
            String pre = _base.substring(0, index);
            _base = pre + _base.substring(index + 1);
        }
        return _base;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        String current_header = this.current.getHeader();
        if (this.tempValue != null && !this.tempValue.equals("") && this.isValidText(this.tempValue)) {
            BaseElement currentItem = this.current.getItem();
            try {
                currentItem.setDataField(current_header, this.tempValue);
            }
            catch (BaseElement.UnknownFieldException e1) {
                throw new SAXException("Invalid field '" + current_header + "'");
            }
            catch (IllegalArgumentException e1) {
                throw new SAXException("Invalid value for field '" + current_header + "'");
            }
            catch (RuntimeException e) {
                logger.error((Object)e);
                throw new SAXException("Unknown Exception <" + current_header + ">" + this.tempValue);
            }
            finally {
                this.tempValue = null;
            }
        }
        if (this.current.getHeader() == "") {
            while (!this.current.isRoot() && this.current.getHeader() == "") {
                this.current = this.current.getParent();
            }
            this.current.removeHeader();
        } else {
            this.current.removeHeader();
            if (this.current.getIsInlineRepeater() && this.current.getHeader() == "") {
                while (!this.current.isRoot() && this.current.getHeader() == "") {
                    this.current = this.current.getParent();
                }
                this.current.removeHeader();
            }
        }
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public static InputStream removeNullUnicodeChars(InputStream i) throws IOException {
        byte[] bs = new byte[i.available()];
        i.read(bs);
        for (int j = 0; j < bs.length; ++j) {
            if (bs[j] != Byte.decode("0x00")) continue;
            bs[j] = 32;
        }
        return new ByteArrayInputStream(bs);
    }

    public BaseElement parse(File data) throws IOException, SAXException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            spf.setNamespaceAware(true);
            FileInputStream fi = new FileInputStream(data);
            SAXParser sp = spf.newSAXParser();
            sp.parse(XDATXMLReader.removeNullUnicodeChars(fi), (DefaultHandler)this);
            fi.close();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        return this.getItem();
    }

    public BaseElement parse(Reader data) throws IOException, SAXException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            spf.setNamespaceAware(true);
            SAXParser sp = spf.newSAXParser();
            sp.parse(new InputSource(data), (DefaultHandler)this);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        return this.getItem();
    }

    public BaseElement parse(InputSource data) throws IOException, SAXException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            spf.setNamespaceAware(true);
            SAXParser sp = spf.newSAXParser();
            sp.parse(data, (DefaultHandler)this);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        return this.getItem();
    }

    public BaseElement parse(InputStream data) throws IOException, SAXException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            spf.setNamespaceAware(true);
            SAXParser sp = spf.newSAXParser();
            sp.parse(data, (DefaultHandler)this);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        return this.getItem();
    }

    public class SAXReaderObject {
        BaseElement item = null;
        String header = "";
        SAXReaderObject parent = null;
        boolean root = false;
        boolean isInlineRepeater = false;
        String FIELD_TYPE = null;

        public SAXReaderObject(BaseElement i, SAXReaderObject p, String type) {
            this.item = i;
            this.parent = p;
            this.FIELD_TYPE = type;
        }

        public SAXReaderObject(BaseElement i, String type) {
            this.item = i;
            this.parent = null;
            this.root = true;
            this.FIELD_TYPE = type;
        }

        public String getHeader() {
            return this.header;
        }

        public boolean isRoot() {
            return this.root;
        }

        public void addHeader(String s) {
            this.header = this.header == "" ? this.header + s : this.header + "/" + s;
        }

        public void removeHeader() {
            this.header = this.header.indexOf("/") != -1 ? this.header.substring(0, this.header.lastIndexOf("/")) : "";
        }

        public BaseElement getItem() {
            return this.item;
        }

        public SAXReaderObject getParent() {
            return this.parent;
        }

        public boolean getIsInlineRepeater() {
            return this.isInlineRepeater;
        }

        public void setIsInlineRepeater(boolean b) {
            this.isInlineRepeater = b;
        }

        public boolean insertNewLine() {
            try {
                if (this.FIELD_TYPE == null) {
                    return false;
                }
                return this.FIELD_TYPE.equals("LONG_DATA");
            }
            catch (RuntimeException e) {
                return false;
            }
        }

        public String getFIELD_TYPE() {
            return this.FIELD_TYPE;
        }

        public void setFIELD_TYPE(String field_type) {
            this.FIELD_TYPE = field_type;
        }
    }
}

