/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.nifti;

import org.nrg.nifti.CoordinateMapper;

public class AffineCoors
extends CoordinateMapper {
    public double[][] s = new double[3][4];
    private String name = "";

    public AffineCoors(double[][] matrix) {
        this(matrix, 0);
    }

    public AffineCoors(double[][] matrix, int type) {
        this(matrix, type, "");
    }

    public AffineCoors(double[][] matrix, int type, String name) {
        this.coorType = type;
        this.name = name;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.s[i][j] = matrix[i][j];
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public double[][] getMatrix() {
        return this.s;
    }

    @Override
    public CoordinateMapper copy() {
        return new AffineCoors(this.s, this.coorType, this.name);
    }

    @Override
    public double getX(double x, double y, double z) {
        return this.s[0][0] * x + this.s[0][1] * y + this.s[0][2] * z + this.s[0][3];
    }

    @Override
    public double getY(double x, double y, double z) {
        return this.s[1][0] * x + this.s[1][1] * y + this.s[1][2] * z + this.s[1][3];
    }

    @Override
    public double getZ(double x, double y, double z) {
        return this.s[2][0] * x + this.s[2][1] * y + this.s[2][2] * z + this.s[2][3];
    }

    @Override
    public void flipResultX() {
        for (int i = 0; i < 4; ++i) {
            this.s[0][i] = -this.s[0][i];
        }
    }

    @Override
    public void flipResultY() {
        for (int i = 0; i < 4; ++i) {
            this.s[1][i] = -this.s[1][i];
        }
    }

    @Override
    public void flipResultZ() {
        for (int i = 0; i < 4; ++i) {
            this.s[2][i] = -this.s[2][i];
        }
    }

    @Override
    public void rotate(int[] axes, double[] dims) {
        int i;
        double[][] postMatrix = new double[3][4];
        double[][] newS = new double[3][4];
        for (i = 0; i < 3; ++i) {
            int absAxis = Math.abs(axes[i]) - 1;
            double d = postMatrix[absAxis][i] = axes[i] > 0 ? 1.0 : -1.0;
            if (axes[i] >= 0) continue;
            postMatrix[absAxis][3] = dims[absAxis] - 1.0;
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 3; ++k) {
                    double[] dArray = newS[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.s[i][k] * postMatrix[k][j];
                }
            }
            double[] dArray = newS[i];
            dArray[3] = dArray[3] + this.s[i][3];
        }
        this.s = newS;
    }
}

