/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.nifti;

public abstract class CoordinateMapper {
    public static final int UNKNOWN = 0;
    public static final int NIFTI = 1;
    public static final int DICOM = 2;
    protected int coorType = 1;

    public int getCoorType() {
        return this.coorType;
    }

    public String getXDescription() {
        switch (this.coorType) {
            case 1: {
                return "left to right";
            }
            case 2: {
                return "right to left";
            }
        }
        return "unknown";
    }

    public String getYDescription() {
        switch (this.coorType) {
            case 1: {
                return "posterior to anterior";
            }
            case 2: {
                return "anterior to posterior";
            }
        }
        return "unknown";
    }

    public String getZDescription() {
        switch (this.coorType) {
            case 1: 
            case 2: {
                return "inferior to superior";
            }
        }
        return "unknown";
    }

    public boolean convertToType(int newType) {
        if (this.coorType == newType) {
            return true;
        }
        if (this.coorType == 1 && newType == 2 || this.coorType == 2 && newType == 1) {
            this.flipResultX();
            this.flipResultY();
            this.coorType = newType;
            return true;
        }
        return false;
    }

    public abstract String getName();

    public abstract CoordinateMapper copy();

    public abstract double getX(double var1, double var3, double var5);

    public abstract double getY(double var1, double var3, double var5);

    public abstract double getZ(double var1, double var3, double var5);

    public abstract void flipResultX();

    public abstract void flipResultY();

    public abstract void flipResultZ();

    public abstract void rotate(int[] var1, double[] var2);

    public double getX(int x, int y, int z) {
        return this.getX((double)x, (double)y, (double)z);
    }

    public double getY(int x, int y, int z) {
        return this.getY((double)x, (double)y, (double)z);
    }

    public double getZ(int x, int y, int z) {
        return this.getZ((double)x, (double)y, (double)z);
    }

    public double[] transform(double x, double y, double z) {
        return new double[]{this.getX(x, y, z), this.getY(x, y, z), this.getZ(x, y, z)};
    }

    public double[] transform(double[] coors) {
        return this.transform(coors[0], coors[1], coors[2]);
    }

    public double[] transform(int[] coors) {
        return this.transform((double)coors[0], (double)coors[1], (double)coors[2]);
    }

    public double[] transform(int x, int y, int z) {
        return this.transform((double)x, (double)y, (double)z);
    }
}

