/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.nifti;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.plugin.frame.PlugInFrame;
import java.awt.Button;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import org.nrg.nifti.CoordinateMapper;

public class Coordinate_Viewer
extends PlugInFrame
implements MouseMotionListener,
ActionListener {
    private Label imageName;
    private ImagePlus currentImage;
    private ImageCanvas currentCanvas;
    private CoordinateMapper[] mapper;
    private Label[] coors;

    public Coordinate_Viewer() {
        super("Coordinate Viewer");
        this.setUpWindow();
        this.setVisible(true);
    }

    private void setUpWindow() {
        this.removeAll();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        this.add(new Label("Image: "), gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        this.currentImage = WindowManager.getCurrentImage();
        this.imageName = new Label(this.currentImage != null ? this.currentImage.getTitle() : "");
        this.add(this.imageName, gbc);
        gbc.gridy = 1;
        gbc.anchor = 12;
        Button newImage = new Button("Set Image");
        gbc.fill = 3;
        this.add(newImage, gbc);
        newImage.addActionListener(this);
        gbc.gridy = 2;
        gbc.gridx = 0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        this.pack();
        if (this.currentImage == null) {
            gbc.weighty = 1.0;
            this.add(new Panel(), gbc);
            return;
        }
        Object prop = this.currentImage.getProperty("coors");
        if (prop == null) {
            return;
        }
        if (!(prop instanceof CoordinateMapper[])) {
            gbc.weighty = 1.0;
            this.add(new Panel(), gbc);
            return;
        }
        this.add(new Label(" "), gbc);
        this.mapper = (CoordinateMapper[])prop;
        this.coors = new Label[this.mapper.length];
        gbc.gridy = 3;
        for (int i = 0; i < this.mapper.length; ++i) {
            gbc.anchor = 17;
            gbc.gridwidth = 1;
            this.add(new Label(this.mapper[i].getName() + ":"), gbc);
            if (this.mapper[i].getCoorType() != 0) {
                ++gbc.gridy;
                gbc.gridx = 0;
                gbc.anchor = 13;
                this.add(new Label(" x increases from ", 2), gbc);
                gbc.gridx = 1;
                gbc.anchor = 17;
                this.add(new Label(this.mapper[i].getXDescription()), gbc);
                ++gbc.gridy;
                gbc.gridx = 0;
                gbc.anchor = 13;
                this.add(new Label(" y increases from ", 2), gbc);
                gbc.gridx = 1;
                gbc.anchor = 17;
                this.add(new Label(this.mapper[i].getYDescription()), gbc);
                ++gbc.gridy;
                gbc.gridx = 0;
                gbc.anchor = 13;
                this.add(new Label(" z increases from ", 2), gbc);
                gbc.gridx = 1;
                gbc.anchor = 17;
                this.add(new Label(this.mapper[i].getZDescription()), gbc);
            }
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.anchor = 11;
            gbc.gridwidth = 2;
            this.coors[i] = new Label("(0.00,0.00,0.00)", 1);
            this.add(this.coors[i], gbc);
            ++gbc.gridy;
        }
        gbc.weighty = 1.0;
        this.add(new Panel(), gbc);
        this.currentCanvas = this.currentImage.getWindow().getCanvas();
        this.currentCanvas.addMouseMotionListener((MouseMotionListener)this);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.currentCanvas != null) {
            this.currentCanvas.removeMouseMotionListener((MouseMotionListener)this);
        }
        this.setUpWindow();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int x = this.currentCanvas.offScreenX(e.getX());
        int y = this.currentCanvas.offScreenY(e.getY());
        int z = this.currentImage.getSlice() - 1;
        for (int i = 0; i < this.mapper.length; ++i) {
            String loc = "(" + IJ.d2s((double)this.mapper[i].getX(x, y, z)) + "," + IJ.d2s((double)this.mapper[i].getY(x, y, z)) + "," + IJ.d2s((double)this.mapper[i].getZ(x, y, z)) + ")";
            this.coors[i].setText(loc);
            this.coors[i].repaint();
        }
    }
}

