/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.nifti;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.VirtualStack;
import ij.WindowManager;
import ij.io.FileInfo;
import ij.io.ImageWriter;
import ij.io.SaveDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.nrg.nifti.AffineCoors;
import org.nrg.nifti.CoordinateMapper;
import org.nrg.nifti.NiftiHeader;
import org.nrg.nifti.QuaternCoors;

public class Nifti_Writer
implements PlugIn {
    public static final int ANALYZE_7_5 = 0;
    public static final int NIFTI_ANALYZE = 1;
    public static final int NIFTI_FILE = 2;
    public boolean littleEndian = false;
    private int output_type = 2;
    private boolean signed16Bit = false;

    public void run(String arg) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.noImage();
            return;
        }
        String directory = "";
        String name = "";
        if (arg != null) {
            if (arg.startsWith("::ANALYZE_7_5:")) {
                this.output_type = 0;
                arg = arg.substring(14).trim();
            } else if (arg.startsWith("::NIFTI_ANALYZE:")) {
                this.output_type = 1;
                arg = arg.substring(16).trim();
            } else if (arg.startsWith("::NIFTI_FILE:")) {
                this.output_type = 2;
                arg = arg.substring(13).trim();
            }
        }
        if (arg == null || arg.equals("")) {
            String fType = "";
            String suffix = "";
            switch (this.output_type) {
                case 0: 
                case 1: {
                    fType = "Analyze";
                    suffix = ".img";
                    break;
                }
                case 2: {
                    fType = "Nifti";
                    suffix = ".nii";
                }
            }
            SaveDialog sd = new SaveDialog("Save as " + fType, imp.getTitle(), suffix);
            directory = sd.getDirectory();
            name = sd.getFileName();
        } else {
            File file = new File(arg);
            if (file.isDirectory()) {
                directory = arg;
                name = imp.getTitle();
            } else {
                directory = file.getParent();
                name = file.getName();
            }
        }
        if (name == null || name == "") {
            IJ.showStatus((String)"");
            return;
        }
        if (this.is16BitSigned(imp)) {
            this.add(imp, Short.MIN_VALUE);
            this.signed16Bit = true;
        }
        ImageStack stack = imp.getStack();
        if (this.output_type == 0) {
            for (int i = 1; i <= stack.getSize(); ++i) {
                ImageProcessor ip = stack.getProcessor(i);
                ip.flipVertical();
            }
        }
        int nChannels = imp.getNChannels();
        int nOthers = imp.getNFrames() * imp.getNSlices();
        if (nChannels != 1) {
            this.reshuffleStack(stack.getImageArray(), nChannels, nChannels * nOthers);
        }
        this.save(imp, directory, name);
        if (imp.getNChannels() != 1) {
            this.reshuffleStack(stack.getImageArray(), nOthers, nChannels * nOthers);
        }
        if (this.output_type == 0) {
            for (int i = 1; i <= stack.getSize(); ++i) {
                ImageProcessor ip = stack.getProcessor(i);
                ip.flipVertical();
            }
        }
        if (this.signed16Bit) {
            this.add(imp, 32768);
            this.signed16Bit = false;
        }
        IJ.showStatus((String)"");
    }

    public boolean save(ImagePlus imp, String directory, String name) {
        if (name == null) {
            return false;
        }
        name = name.trim();
        directory = directory.trim();
        if (this.output_type != 2) {
            if (name.toLowerCase().endsWith(".img")) {
                name = name.substring(0, name.length() - 4);
            }
            if (name.toLowerCase().endsWith(".hdr")) {
                name = name.substring(0, name.length() - 4);
            }
        }
        if (!directory.endsWith(File.separator)) {
            directory = directory + File.separator;
        }
        try {
            String hdrFile = this.output_type == 2 ? directory + name : directory + name + ".hdr";
            FileOutputStream stream = new FileOutputStream(hdrFile);
            DataOutputStream output = new DataOutputStream(stream);
            IJ.showStatus((String)("Saving as Analyze: " + directory + name));
            this.writeHeader(imp, output, this.output_type);
            if (this.output_type != 2) {
                output.close();
                stream.close();
                String fileName = directory + name + ".img";
                stream = new FileOutputStream(fileName);
                output = new DataOutputStream(stream);
            }
            FileInfo fi = imp.getFileInfo();
            fi.intelByteOrder = this.littleEndian;
            if (fi.fileType != 6) {
                if (imp.getStackSize() > 1 && imp.getStack().isVirtual()) {
                    fi.virtualStack = (VirtualStack)imp.getStack();
                    fi.fileName = "FlipTheseImages";
                }
                ImageWriter iw = new ImageWriter(fi);
                iw.write((OutputStream)output);
            } else {
                this.writeRGBPlanar(imp, output);
            }
            output.close();
            stream.close();
            return true;
        }
        catch (IOException e) {
            IJ.log((String)("Nifti_Writer: " + e.getMessage()));
            return false;
        }
    }

    private void writeHeader(ImagePlus imp, DataOutputStream output, int type) throws IOException {
        int i;
        short bitsallocated;
        short datatype;
        FileInfo fi = imp.getFileInfo();
        NiftiHeader nfti_hdr = (NiftiHeader)imp.getProperty("nifti");
        Calibration c = imp.getCalibration();
        switch (fi.fileType) {
            case 0: {
                datatype = 2;
                bitsallocated = 8;
                break;
            }
            case 1: 
            case 2: {
                datatype = 4;
                bitsallocated = 16;
                break;
            }
            case 3: {
                datatype = 8;
                bitsallocated = 32;
                break;
            }
            case 4: {
                datatype = 16;
                bitsallocated = 32;
                break;
            }
            case 6: {
                datatype = 128;
                bitsallocated = 24;
                break;
            }
            default: {
                datatype = 0;
                bitsallocated = (short)(fi.getBytesPerPixel() * 8);
            }
        }
        this.writeInt(output, 348);
        for (i = 0; i < 10; ++i) {
            output.write(0);
        }
        for (i = 0; i < 18; ++i) {
            output.write(0);
        }
        this.writeInt(output, 16384);
        output.writeShort(0);
        output.writeByte(114);
        output.writeByte(0);
        short[] dims = new short[8];
        dims[0] = imp.getNChannels() == 1 ? 4 : 5;
        dims[1] = (short)fi.width;
        dims[2] = (short)fi.height;
        dims[3] = (short)imp.getNSlices();
        dims[4] = (short)imp.getNFrames();
        dims[5] = (short)imp.getNChannels();
        for (i = 0; i < 8; ++i) {
            this.writeShort(output, dims[i]);
        }
        if (type == 0) {
            String unit = c.getUnit() + "\u0000\u0000\u0000\u0000";
            unit = unit.substring(0, 4);
            output.writeBytes(unit);
            for (i = 0; i < 8; ++i) {
                output.write(0);
            }
            output.writeShort(0);
        } else {
            this.writeFloat(output, nfti_hdr == null ? 0.0 : (double)nfti_hdr.intent_p1);
            this.writeFloat(output, nfti_hdr == null ? 0.0 : (double)nfti_hdr.intent_p2);
            this.writeFloat(output, nfti_hdr == null ? 0.0 : (double)nfti_hdr.intent_p3);
            this.writeShort(output, nfti_hdr == null ? (short)0 : nfti_hdr.intent_code);
        }
        this.writeShort(output, datatype);
        this.writeShort(output, bitsallocated);
        if (type == 0 || nfti_hdr == null) {
            output.writeShort(0);
        } else {
            this.writeShort(output, nfti_hdr.slice_start);
        }
        double[] quaterns = new double[5];
        int qform_code = 0;
        int sform_code = 0;
        double qoffset_x = 0.0;
        double qoffset_y = 0.0;
        double qoffset_z = 0.0;
        for (i = 0; i < 5; ++i) {
            quaterns[i] = 0.0;
        }
        double[][] srow = new double[3][4];
        for (i = 0; i < 3; ++i) {
            srow[i][i] = 1.0;
        }
        if (type != 0) {
            Object orientProp = imp.getProperty("coors");
            if (orientProp instanceof CoordinateMapper[]) {
                CoordinateMapper[] mapper = (CoordinateMapper[])orientProp;
                for (i = 0; i < mapper.length; ++i) {
                    CoordinateMapper mp;
                    if (mapper[i] instanceof AffineCoors && (mp = (AffineCoors)mapper[i].copy()).convertToType(1)) {
                        srow = ((AffineCoors)mp).getMatrix();
                        sform_code = NiftiHeader.getCoorTypeCode(((AffineCoors)mp).getName());
                    }
                    if (!(mapper[i] instanceof QuaternCoors) || !(mp = (QuaternCoors)mapper[i].copy()).convertToType(1)) continue;
                    qform_code = NiftiHeader.getCoorTypeCode(((QuaternCoors)mp).getName());
                    quaterns = ((QuaternCoors)mp).getQuaterns();
                    qoffset_x = mapper[i].getX(0, 0, 0);
                    qoffset_y = mapper[i].getY(0, 0, 0);
                    qoffset_z = mapper[i].getZ(0, 0, 0);
                }
            } else if (nfti_hdr != null) {
                quaterns[0] = nfti_hdr.pixdim[0];
                quaterns[2] = nfti_hdr.quatern_b;
                quaterns[3] = nfti_hdr.quatern_c;
                quaterns[4] = nfti_hdr.quatern_d;
                qform_code = nfti_hdr.qform_code;
                qoffset_x = nfti_hdr.qoffset_x;
                qoffset_y = nfti_hdr.qoffset_y;
                qoffset_z = nfti_hdr.qoffset_z;
                sform_code = nfti_hdr.sform_code;
                for (i = 0; i < 4; ++i) {
                    srow[0][i] = nfti_hdr.srow_x[i];
                    srow[1][i] = nfti_hdr.srow_y[i];
                    srow[2][i] = nfti_hdr.srow_z[i];
                }
            }
        }
        float[] pixdims = new float[8];
        pixdims[0] = (float)quaterns[0];
        pixdims[1] = (float)fi.pixelWidth;
        pixdims[2] = (float)fi.pixelHeight;
        pixdims[3] = (float)fi.pixelDepth;
        pixdims[4] = (float)fi.frameInterval;
        if (type != 0 && nfti_hdr != null) {
            for (i = 5; i < 8; ++i) {
                pixdims[i] = nfti_hdr.pixdim[i];
            }
        }
        for (i = 0; i < 8; ++i) {
            this.writeFloat(output, pixdims[i]);
        }
        this.writeFloat(output, type == 2 ? 352.0f : 0.0f);
        double[] coeff = new double[]{0.0, 1.0};
        if (c.getFunction() == 0) {
            coeff = c.getCoefficients();
        }
        double c_offset = coeff[0];
        if (this.signed16Bit) {
            c_offset = coeff[1] != 0.0 ? (c_offset += 32768.0 * coeff[1]) : (c_offset += 32768.0);
        }
        if (type == 0) {
            this.writeFloat(output, 1.0f);
            this.writeFloat(output, 0.0f);
            this.writeFloat(output, 0.0f);
        } else {
            this.writeFloat(output, coeff[1]);
            this.writeFloat(output, c_offset);
            this.writeShort(output, nfti_hdr != null ? nfti_hdr.slice_end : (short)(dims[3] - 1));
            output.write(nfti_hdr != null ? nfti_hdr.slice_code : (byte)0);
            String unit = c.getUnit().toLowerCase().trim();
            byte xyzt_unit = 0;
            if (unit.equals("meter") || unit.equals("metre") || unit.equals("m")) {
                xyzt_unit = (byte)(xyzt_unit | 1);
            } else if (unit.equals("mm")) {
                xyzt_unit = (byte)(xyzt_unit | 2);
            } else if (unit.equals("micron")) {
                xyzt_unit = (byte)(xyzt_unit | 3);
            }
            output.write(xyzt_unit);
        }
        double min = imp.getProcessor().getMin();
        double max = imp.getProcessor().getMax() + 1.0;
        this.writeFloat(output, coeff[0] + coeff[1] * max);
        this.writeFloat(output, coeff[0] + coeff[1] * min);
        if (type == 0) {
            output.writeInt(0);
            output.writeInt(0);
            ImageStatistics s = imp.getStatistics();
            this.writeInt(output, this.signed16Bit ? (int)s.max + 32768 : (int)s.max);
            this.writeInt(output, this.signed16Bit ? (int)s.min + 32768 : (int)s.min);
        } else {
            this.writeFloat(output, nfti_hdr != null ? (double)nfti_hdr.slice_duration : 0.0);
            this.writeFloat(output, nfti_hdr != null ? (double)nfti_hdr.toffset : 0.0);
            this.writeFloat(output, 0.0);
            this.writeFloat(output, 0.0);
        }
        if (type == 0) {
            for (i = 0; i < 80; ++i) {
                output.write(0);
            }
            for (i = 0; i < 24; ++i) {
                output.write(0);
            }
            output.write(0);
            for (i = 0; i < 10; ++i) {
                output.write(0);
            }
            for (i = 0; i < 10; ++i) {
                output.write(0);
            }
            for (i = 0; i < 10; ++i) {
                output.write(0);
            }
            for (i = 0; i < 10; ++i) {
                output.write(0);
            }
            for (i = 0; i < 10; ++i) {
                output.write(0);
            }
            for (i = 0; i < 10; ++i) {
                output.write(0);
            }
            for (i = 0; i < 3; ++i) {
                output.write(0);
            }
            output.writeInt(0);
            output.writeInt(0);
            output.writeInt(0);
            output.writeInt(0);
            output.writeInt(0);
            output.writeInt(0);
            output.writeInt(0);
            output.writeInt(0);
        } else {
            String desc = nfti_hdr == null ? new String() : nfti_hdr.descrip.trim();
            int length = desc.length();
            if (length > 80) {
                output.writeBytes(desc.substring(0, 80));
            } else {
                output.writeBytes(desc);
                for (i = length; i < 80; ++i) {
                    output.write(0);
                }
            }
            desc = nfti_hdr == null ? "" : nfti_hdr.aux_file.trim();
            length = desc.length();
            if (length > 24) {
                output.writeBytes(desc.substring(0, 24));
            } else {
                output.writeBytes(desc);
                for (i = length; i < 24; ++i) {
                    output.write(0);
                }
            }
            this.writeShort(output, (short)qform_code);
            this.writeShort(output, (short)sform_code);
            this.writeFloat(output, quaterns[2]);
            this.writeFloat(output, quaterns[3]);
            this.writeFloat(output, quaterns[4]);
            this.writeFloat(output, qoffset_x);
            this.writeFloat(output, qoffset_y);
            this.writeFloat(output, qoffset_z);
            for (i = 0; i < 3; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.writeFloat(output, srow[i][j]);
                }
            }
            desc = nfti_hdr == null ? "" : nfti_hdr.intent_name.trim();
            length = desc.length();
            if (length > 16) {
                output.writeBytes(desc.substring(0, 16));
            } else {
                output.writeBytes(desc);
                for (i = length; i < 16; ++i) {
                    output.write(0);
                }
            }
            output.writeBytes(type == 1 ? "ni1\u0000" : "n+1\u0000");
            if (type == 2) {
                output.writeInt(0);
            }
        }
    }

    private void reshuffleStack(Object[] stack, int gap, int length) {
        int i;
        Object[] oldStack = new Object[stack.length];
        for (i = 0; i < oldStack.length; ++i) {
            oldStack[i] = stack[i];
        }
        int n = 0;
        for (i = 0; i < gap; ++i) {
            int c = i;
            while (c < length) {
                stack[n] = oldStack[c];
                c += gap;
                ++n;
            }
        }
    }

    private void writeRGBPlanar(ImagePlus imp, OutputStream out) throws IOException {
        ImageStack stack = null;
        int nImages = imp.getStackSize();
        if (nImages > 1) {
            stack = imp.getStack();
        }
        int w = imp.getWidth();
        int h = imp.getHeight();
        for (int i = 1; i <= nImages; ++i) {
            ColorProcessor cp = nImages == 1 ? (ColorProcessor)imp.getProcessor() : (ColorProcessor)stack.getProcessor(i);
            byte[] r = new byte[w * h];
            byte[] g = new byte[w * h];
            byte[] b = new byte[w * h];
            cp.getRGB(r, g, b);
            out.write(r, 0, w * h);
            out.write(g, 0, w * h);
            out.write(b, 0, w * h);
            IJ.showProgress((double)((double)i / (double)nImages));
        }
    }

    private void writeInt(DataOutputStream input, int value) throws IOException {
        if (this.littleEndian) {
            byte b1 = (byte)(value & 0xFF);
            byte b2 = (byte)(value >> 8 & 0xFF);
            byte b3 = (byte)(value >> 16 & 0xFF);
            byte b4 = (byte)(value >> 24 & 0xFF);
            input.writeByte(b1);
            input.writeByte(b2);
            input.writeByte(b3);
            input.writeByte(b4);
        } else {
            input.writeInt(value);
        }
    }

    private void writeShort(DataOutputStream input, short value) throws IOException {
        if (this.littleEndian) {
            byte b1 = (byte)(value & 0xFF);
            byte b2 = (byte)(value >> 8 & 0xFF);
            input.writeByte(b1);
            input.writeByte(b2);
        } else {
            input.writeShort(value);
        }
    }

    private void writeFloat(DataOutputStream input, float value) throws IOException {
        this.writeInt(input, Float.floatToIntBits(value));
    }

    private void writeFloat(DataOutputStream input, double value) throws IOException {
        this.writeFloat(input, (float)value);
    }

    boolean is16BitSigned(ImagePlus imp) {
        if (imp.getType() != 1) {
            return false;
        }
        int min = 65536;
        int max = 0;
        ImageStack s = imp.getStack();
        int sliceSize = imp.getWidth() * imp.getHeight();
        for (int i = 1; i <= s.getSize(); ++i) {
            short[] pixels = (short[])s.getProcessor(i).getPixels();
            for (int j = 0; j < sliceSize; ++j) {
                min = min < (pixels[j] & 0xFFFF) ? min : pixels[j] & 0xFFFF;
                max = max > (pixels[j] & 0xFFFF) ? max : pixels[j] & 0xFFFF;
            }
        }
        return max > Short.MAX_VALUE;
    }

    void add(ImagePlus imp, int value) {
        ImageStack stack = imp.getStack();
        for (int slice = 1; slice <= stack.getSize(); ++slice) {
            ImageProcessor ip = stack.getProcessor(slice);
            short[] pixels = (short[])ip.getPixels();
            for (int i = 0; i < pixels.length; ++i) {
                pixels[i] = (short)((pixels[i] & 0xFFFF) + value);
            }
        }
    }
}

