/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.Reader;

import ij.io.FileInfo;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.nrg.plexiViewer.Reader.ImageReader;
import org.nrg.plexiViewer.Reader.ImageReaderPreparer;
import org.nrg.plexiViewer.Reader.ReaderUtils;
import org.nrg.plexiViewer.utils.FileUtils;

public class AnalyzeReader
extends ImageReaderPreparer
implements ImageReader {
    boolean littleEndian = false;
    private String orientation;
    String directory;
    String fileName;
    int volumes = 1;
    int glmax;
    int glmin;

    public AnalyzeReader(String directory, String fileName) {
        this.directory = directory;
        this.fileName = fileName;
        this.orientation = null;
    }

    @Override
    public boolean isZipped() {
        return this.zipped;
    }

    @Override
    public void clearTempFolder() {
        if (this.zipped) {
            System.out.println("Now deleting " + this.directory);
            FileUtils.deleteFile(this.directory, true);
        }
    }

    @Override
    public FileInfo getFileInfo() throws IOException {
        int i;
        Object hdrfile = null;
        String name = "";
        name = this.fileName.endsWith(".img") ? this.fileName.substring(0, this.fileName.length() - 4) : (this.fileName.endsWith(".hdr") ? this.fileName.substring(0, this.fileName.length() - 4) : this.fileName);
        String path = "";
        String destDir = this.unzip(this.directory, name + ".img");
        if (this.zipped) {
            this.unzip(this.directory, name + ".hdr", destDir);
            this.directory = destDir;
        }
        if (this.directory != null && !this.directory.equals("")) {
            if (!this.directory.endsWith("" + File.separatorChar)) {
                this.directory = this.directory + File.separatorChar;
            }
            path = path + this.directory + name + ".hdr";
        } else {
            path = path + name + ".hdr";
        }
        FileInputStream filein = new FileInputStream(path);
        DataInputStream input = new DataInputStream(filein);
        FileInfo fi = new FileInfo();
        byte[] units = new byte[4];
        input.readInt();
        for (i = 0; i < 10; ++i) {
            input.read();
        }
        for (i = 0; i < 18; ++i) {
            input.read();
        }
        input.readInt();
        input.readShort();
        input.readByte();
        input.readByte();
        short endian = this.readShort(input);
        if (endian < 0 || endian > 15) {
            System.out.println("Byte Order:: Little Endian");
            this.littleEndian = true;
            fi.intelByteOrder = true;
        }
        fi.width = this.readShort(input);
        fi.height = this.readShort(input);
        fi.nImages = this.readShort(input);
        this.volumes = input.readShort();
        for (i = 0; i < 3; ++i) {
            input.readShort();
        }
        input.read(units, 0, 4);
        fi.unit = new String(units, 0, 4);
        for (i = 0; i < 8; ++i) {
            input.read();
        }
        input.readShort();
        short datatype = this.readShort(input);
        int bitsallocated = this.readShort(input);
        input.readShort();
        input.readFloat();
        fi.pixelWidth = this.readFloat(input);
        fi.pixelHeight = this.readFloat(input);
        fi.pixelDepth = this.readFloat(input);
        for (i = 0; i < 4; ++i) {
            input.readFloat();
        }
        fi.offset = (int)this.readFloat(input);
        input.readFloat();
        input.readFloat();
        input.readFloat();
        input.readFloat();
        input.readFloat();
        input.readInt();
        input.readInt();
        this.glmax = this.readInt(input);
        this.glmin = this.readInt(input);
        for (i = 0; i < 80; ++i) {
            input.read();
        }
        for (i = 0; i < 24; ++i) {
            input.read();
        }
        this.orientation = "" + input.read();
        for (i = 0; i < 10; ++i) {
            input.read();
        }
        for (i = 0; i < 10; ++i) {
            input.read();
        }
        for (i = 0; i < 10; ++i) {
            input.read();
        }
        for (i = 0; i < 10; ++i) {
            input.read();
        }
        for (i = 0; i < 10; ++i) {
            input.read();
        }
        for (i = 0; i < 10; ++i) {
            input.read();
        }
        for (i = 0; i < 3; ++i) {
            input.read();
        }
        input.readInt();
        input.readInt();
        input.readInt();
        input.readInt();
        input.readInt();
        input.readInt();
        input.readInt();
        input.readInt();
        input.close();
        filein.close();
        switch (datatype) {
            case 2: {
                fi.fileType = 0;
                bitsallocated = 8;
                break;
            }
            case 4: {
                fi.fileType = 1;
                bitsallocated = 16;
                break;
            }
            case 8: {
                fi.fileType = 3;
                bitsallocated = 32;
                break;
            }
            case 16: {
                fi.fileType = 4;
                bitsallocated = 32;
                break;
            }
            case 128: {
                fi.fileType = 7;
                bitsallocated = 24;
                break;
            }
            default: {
                fi.fileType = 0;
            }
        }
        fi.fileName = name + ".img";
        fi.directory = this.directory;
        fi.fileFormat = 1;
        return fi;
    }

    public int readInt(DataInputStream input) throws IOException {
        if (!this.littleEndian) {
            return input.readInt();
        }
        byte b1 = input.readByte();
        byte b2 = input.readByte();
        byte b3 = input.readByte();
        byte b4 = input.readByte();
        return (b4 & 0xFF) << 24 | (b3 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b1 & 0xFF;
    }

    public short readShort(DataInputStream input) throws IOException {
        if (!this.littleEndian) {
            return input.readShort();
        }
        byte b1 = input.readByte();
        byte b2 = input.readByte();
        return (short)((b2 & 0xFF) << 8 | b1 & 0xFF);
    }

    public float readFloat(DataInputStream input) throws IOException {
        if (!this.littleEndian) {
            return input.readFloat();
        }
        int orig = this.readInt(input);
        return Float.intBitsToFloat(orig);
    }

    @Override
    public String getOrientation() {
        return ReaderUtils.getOrientationLabel(this.getStandardOrientation(this.orientation));
    }

    public int getGlmax() {
        return this.glmax;
    }

    public int getGlmin() {
        return this.glmin;
    }

    public String getStandardOrientation(String analyzeOrientation) {
        String rtn = "";
        if (analyzeOrientation.equalsIgnoreCase("0")) {
            rtn = "2";
        } else if (analyzeOrientation.equalsIgnoreCase("1")) {
            rtn = "3";
        } else if (analyzeOrientation.equalsIgnoreCase("2")) {
            rtn = "4";
        } else if (analyzeOrientation.equalsIgnoreCase("3")) {
            rtn = "-2";
        } else if (analyzeOrientation.equalsIgnoreCase("4")) {
            rtn = "-3";
        } else if (analyzeOrientation.equalsIgnoreCase("5")) {
            rtn = "-4";
        }
        return rtn;
    }

    @Override
    public int getVolumes() {
        return this.volumes;
    }

    @Override
    public int getOrientationForWriter() {
        return ReaderUtils.getOrientationAsInt(this.getOrientation(), true);
    }

    public static void main(String[] args) {
        AnalyzeReader read = new AnalyzeReader("Y:\\data2\\WORK\\pettest\\pb1184\\ROIS", "mr_test.img");
        try {
            FileInfo fi = read.getFileInfo();
            System.out.println("Glmax " + read.getGlmax() + " GlMin " + read.glmin + " " + fi.fileType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

