/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.Reader;

import ij.io.FileInfo;
import ij.util.Tools;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.nrg.plexiViewer.Reader.DicomDictionary;
import org.nrg.plexiViewer.Reader.ImageReader;
import org.nrg.plexiViewer.Reader.ImageReaderPreparer;
import org.nrg.plexiViewer.Reader.ReaderUtils;
import org.nrg.plexiViewer.utils.FileUtils;

public class DICOMReader
extends ImageReaderPreparer
implements ImageReader {
    private static final int PIXEL_REPRESENTATION = 2621699;
    private static final int TRANSFER_SYNTAX_UID = 131088;
    private static final int SLICE_SPACING = 0x180088;
    private static final int SAMPLES_PER_PIXEL = 0x280002;
    private static final int PHOTOMETRIC_INTERPRETATION = 2621444;
    private static final int PLANAR_CONFIGURATION = 2621446;
    private static final int NUMBER_OF_FRAMES = 0x280008;
    private static final int ROWS = 2621456;
    private static final int COLUMNS = 2621457;
    private static final int PIXEL_SPACING = 2621488;
    private static final int BITS_ALLOCATED = 2621696;
    private static final int WINDOW_CENTER = 2625616;
    private static final int WINDOW_WIDTH = 2625617;
    private static final int RESCALE_INTERCEPT = 2625618;
    private static final int RESCALE_SLOPE = 2625619;
    private static final int RED_PALETTE = 2626049;
    private static final int GREEN_PALETTE = 2626050;
    private static final int BLUE_PALETTE = 2626051;
    private static final int ICON_IMAGE_SEQUENCE = 0x880200;
    private static final int ITEM = -73728;
    private static final int ITEM_DELIMINATION = -73715;
    private static final int SEQUENCE_DELIMINATION = -73507;
    private static final int PIXEL_DATA = 2145386512;
    private String orientation;
    private static final int PATIENT_ORIENTATION = 0x200020;
    private static final int IMAGE_ORIENTATION_PATIENT = 2097207;
    private static final int AE = 16709;
    private static final int AS = 16723;
    private static final int AT = 16724;
    private static final int CS = 17235;
    private static final int DA = 17473;
    private static final int DS = 17491;
    private static final int DT = 17492;
    private static final int FD = 17988;
    private static final int FL = 17996;
    private static final int IS = 18771;
    private static final int LO = 19535;
    private static final int LT = 19540;
    private static final int PN = 20558;
    private static final int SH = 21320;
    private static final int SL = 21324;
    private static final int SS = 21331;
    private static final int ST = 21332;
    private static final int TM = 21581;
    private static final int UI = 21833;
    private static final int UL = 21836;
    private static final int US = 21843;
    private static final int UT = 21844;
    private static final int OB = 20290;
    private static final int OW = 20311;
    private static final int SQ = 21329;
    private static final int UN = 21838;
    private static final int QQ = 16191;
    private static Properties dictionary;
    private String directory;
    private String fileName;
    private static final int ID_OFFSET = 128;
    private static final String DICM = "DICM";
    private BufferedInputStream f;
    private int location = 0;
    private boolean littleEndian = true;
    private int elementLength;
    private int vr;
    private static final int IMPLICIT_VR = 11565;
    private byte[] vrLetters = new byte[2];
    private int previousGroup;
    private StringBuffer dicomInfo = new StringBuffer(1000);
    private boolean dicmFound;
    private boolean oddLocations;
    private boolean bigEndianTransferSyntax = false;
    double windowCenter;
    double windowWidth;
    double rescaleIntercept;
    double rescaleSlope;
    int volumes = 1;
    static char[] buf8;
    char[] buf10;

    public DICOMReader(String directory, String fileName) {
        this.directory = directory.endsWith("" + File.separatorChar) ? directory : directory + File.separatorChar;
        this.fileName = fileName;
        if (dictionary == null) {
            DicomDictionary d = new DicomDictionary();
            dictionary = d.getDictionary();
        }
        this.orientation = "Sagittal";
    }

    @Override
    public boolean isZipped() {
        return this.zipped;
    }

    @Override
    public void clearTempFolder() {
        if (this.zipped) {
            FileUtils.deleteFile(this.directory, true);
        }
    }

    String getString(int length) throws IOException {
        int count;
        byte[] buf = new byte[length];
        for (int pos = 0; pos < length; pos += count) {
            count = this.f.read(buf, pos, length - pos);
        }
        this.location += length;
        return new String(buf);
    }

    int getByte() throws IOException {
        int b = this.f.read();
        if (b == -1) {
            throw new IOException("unexpected EOF");
        }
        ++this.location;
        return b;
    }

    int getShort() throws IOException {
        int b0 = this.getByte();
        int b1 = this.getByte();
        if (this.littleEndian) {
            return (b1 << 8) + b0;
        }
        return (b0 << 8) + b1;
    }

    final int getInt() throws IOException {
        int b0 = this.getByte();
        int b1 = this.getByte();
        int b2 = this.getByte();
        int b3 = this.getByte();
        if (this.littleEndian) {
            return (b3 << 24) + (b2 << 16) + (b1 << 8) + b0;
        }
        return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
    }

    byte[] getLut(int length) throws IOException {
        if ((length & 1) != 0) {
            String dummy = this.getString(length);
            return null;
        }
        byte[] lut = new byte[length /= 2];
        for (int i = 0; i < length; ++i) {
            lut[i] = (byte)(this.getShort() >>> 8);
        }
        return lut;
    }

    int getLength() throws IOException {
        int b0 = this.getByte();
        int b1 = this.getByte();
        int b2 = this.getByte();
        int b3 = this.getByte();
        this.vr = (b0 << 8) + b1;
        switch (this.vr) {
            case 20290: 
            case 20311: 
            case 21329: 
            case 21838: {
                if (b2 == 0 || b3 == 0) {
                    return this.getInt();
                }
                this.vr = 11565;
                if (this.littleEndian) {
                    return (b3 << 24) + (b2 << 16) + (b1 << 8) + b0;
                }
                return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
            }
            case 16191: 
            case 16709: 
            case 16723: 
            case 16724: 
            case 17235: 
            case 17473: 
            case 17491: 
            case 17492: 
            case 17988: 
            case 17996: 
            case 18771: 
            case 19535: 
            case 19540: 
            case 20558: 
            case 21320: 
            case 21324: 
            case 21331: 
            case 21332: 
            case 21581: 
            case 21833: 
            case 21836: 
            case 21843: 
            case 21844: {
                if (this.littleEndian) {
                    return (b3 << 8) + b2;
                }
                return (b2 << 8) + b3;
            }
        }
        this.vr = 11565;
        if (this.littleEndian) {
            return (b3 << 24) + (b2 << 16) + (b1 << 8) + b0;
        }
        return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
    }

    int getNextTag() throws IOException {
        int groupWord = this.getShort();
        if (groupWord == 2048 && this.bigEndianTransferSyntax) {
            this.littleEndian = false;
            groupWord = 8;
        }
        int elementWord = this.getShort();
        int tag = groupWord << 16 | elementWord;
        this.elementLength = this.getLength();
        if (this.elementLength == 13 && !this.oddLocations) {
            this.elementLength = 10;
        }
        if (this.elementLength == -1) {
            this.elementLength = 0;
        }
        return tag;
    }

    @Override
    public FileInfo getFileInfo() throws IOException {
        URL u;
        boolean isURL = this.directory.indexOf("://") > 0;
        FileInfo fi = new FileInfo();
        int bitsAllocated = 16;
        fi.fileFormat = 1;
        fi.fileName = this.fileName;
        if (isURL) {
            fi.url = this.directory;
        } else {
            String destDir = this.unzip(this.directory, this.fileName);
            if (this.zipped) {
                this.directory = destDir;
            }
            fi.directory = this.directory;
        }
        fi.width = 0;
        fi.height = 0;
        fi.offset = 0;
        fi.intelByteOrder = true;
        fi.fileType = 2;
        fi.fileFormat = 6;
        int samplesPerPixel = 1;
        int planarConfiguration = 0;
        String photoInterpretation = "";
        if (isURL) {
            u = new URL(fi.url + fi.fileName);
            this.f = new BufferedInputStream(u.openStream());
        } else {
            this.f = new BufferedInputStream(new FileInputStream(this.directory + this.fileName));
        }
        for (long skipCount = 128L; skipCount > 0L; skipCount -= this.f.skip(skipCount)) {
        }
        this.location += 128;
        if (!this.getString(4).equals(DICM)) {
            this.f.close();
            if (isURL) {
                u = new URL(fi.url + fi.fileName);
                this.f = new BufferedInputStream(u.openStream());
            } else {
                this.f = new BufferedInputStream(new FileInputStream(this.directory + this.fileName));
            }
            this.location = 0;
        } else {
            this.dicmFound = true;
        }
        boolean inSequence = true;
        boolean decodingTags = true;
        boolean signed = false;
        block25: while (decodingTags) {
            int tag = this.getNextTag();
            if ((this.location & 1) != 0) {
                this.oddLocations = true;
            }
            switch (tag) {
                case 131088: {
                    String s = this.getString(this.elementLength);
                    this.addInfo(tag, s);
                    if (s.indexOf("1.2.4") > -1 || s.indexOf("1.2.5") > -1) {
                        this.f.close();
                        String msg = "ImageJ cannot open compressed DICOM images.\n \n";
                        msg = msg + "Transfer Syntax UID = " + s;
                        throw new IOException(msg);
                    }
                    if (s.indexOf("1.2.840.10008.1.2.2") < 0) continue block25;
                    this.bigEndianTransferSyntax = true;
                    continue block25;
                }
                case 0x280008: {
                    String s = this.getString(this.elementLength);
                    this.addInfo(tag, s);
                    double frames = this.s2d(s);
                    if (!(frames > 1.0)) continue block25;
                    fi.nImages = (int)frames;
                    continue block25;
                }
                case 0x280002: {
                    samplesPerPixel = this.getShort();
                    this.addInfo(tag, samplesPerPixel);
                    continue block25;
                }
                case 2621444: {
                    photoInterpretation = this.getString(this.elementLength);
                    this.addInfo(tag, photoInterpretation);
                    continue block25;
                }
                case 2621446: {
                    planarConfiguration = this.getShort();
                    this.addInfo(tag, planarConfiguration);
                    continue block25;
                }
                case 2621456: {
                    fi.height = this.getShort();
                    this.addInfo(tag, fi.height);
                    continue block25;
                }
                case 2621457: {
                    fi.width = this.getShort();
                    this.addInfo(tag, fi.width);
                    continue block25;
                }
                case 2621488: {
                    String scale = this.getString(this.elementLength);
                    this.getSpatialScale(fi, scale);
                    this.addInfo(tag, scale);
                    continue block25;
                }
                case 0x180088: {
                    String spacing = this.getString(this.elementLength);
                    fi.pixelDepth = this.s2d(spacing);
                    this.addInfo(tag, spacing);
                    continue block25;
                }
                case 2621696: {
                    bitsAllocated = this.getShort();
                    if (bitsAllocated == 8) {
                        fi.fileType = 0;
                    } else if (bitsAllocated == 32) {
                        fi.fileType = 11;
                    }
                    this.addInfo(tag, bitsAllocated);
                    continue block25;
                }
                case 2621699: {
                    int pixelRepresentation = this.getShort();
                    if (pixelRepresentation == 1) {
                        fi.fileType = 1;
                        signed = true;
                    }
                    this.addInfo(tag, pixelRepresentation);
                    continue block25;
                }
                case 2625616: {
                    String center = this.getString(this.elementLength);
                    this.windowCenter = this.s2d(center);
                    this.addInfo(tag, center);
                    continue block25;
                }
                case 2625617: {
                    String width = this.getString(this.elementLength);
                    this.windowWidth = this.s2d(width);
                    this.addInfo(tag, width);
                    continue block25;
                }
                case 2625618: {
                    String intercept = this.getString(this.elementLength);
                    this.rescaleIntercept = this.s2d(intercept);
                    this.addInfo(tag, intercept);
                    continue block25;
                }
                case 2625619: {
                    String slop = this.getString(this.elementLength);
                    this.rescaleSlope = this.s2d(slop);
                    this.addInfo(tag, slop);
                    continue block25;
                }
                case 2626049: {
                    fi.reds = this.getLut(this.elementLength);
                    this.addInfo(tag, this.elementLength / 2);
                    continue block25;
                }
                case 2626050: {
                    fi.greens = this.getLut(this.elementLength);
                    this.addInfo(tag, this.elementLength / 2);
                    continue block25;
                }
                case 2626051: {
                    fi.blues = this.getLut(this.elementLength);
                    this.addInfo(tag, this.elementLength / 2);
                    continue block25;
                }
                case 2145386512: {
                    if (this.elementLength != 0) {
                        fi.offset = this.location;
                        this.addInfo(tag, this.location);
                        decodingTags = false;
                        continue block25;
                    }
                    this.addInfo(tag, null);
                    continue block25;
                }
                case 0x200020: {
                    this.addInfo(tag, this.getString(this.elementLength));
                    continue block25;
                }
                case 2097207: {
                    String ori = this.getString(this.elementLength);
                    this.orientation = DICOMReader.setOrientation(ori);
                    this.addInfo(tag, ori);
                    continue block25;
                }
                case 2139619344: {
                    if (this.elementLength == 0) continue block25;
                    fi.offset = this.location + 4;
                    decodingTags = false;
                    continue block25;
                }
            }
            this.addInfo(tag, null);
        }
        if (fi.fileType == 0 && fi.reds != null && fi.greens != null && fi.blues != null && fi.reds.length == fi.greens.length && fi.reds.length == fi.blues.length) {
            fi.fileType = 5;
            fi.lutSize = fi.reds.length;
        }
        if (fi.fileType == 11 && signed) {
            fi.fileType = 3;
        }
        if (samplesPerPixel == 3 && photoInterpretation.startsWith("RGB")) {
            if (planarConfiguration == 0) {
                fi.fileType = 6;
            } else if (planarConfiguration == 1) {
                fi.fileType = 7;
            }
        } else if (photoInterpretation.endsWith("1 ")) {
            fi.whiteIsZero = true;
        }
        if (!this.littleEndian) {
            fi.intelByteOrder = false;
        }
        this.f.close();
        return fi;
    }

    public String getDicomInfo() {
        return new String(this.dicomInfo);
    }

    void addInfo(int tag, String value) throws IOException {
        String info = this.getHeaderInfo(tag, value);
        if (info != null) {
            int group = tag >>> 16;
            if (group != this.previousGroup) {
                this.dicomInfo.append("\n");
            }
            this.previousGroup = group;
            this.dicomInfo.append(this.tag2hex(tag) + info + "\n");
        }
    }

    void addInfo(int tag, int value) throws IOException {
        this.addInfo(tag, Integer.toString(value));
    }

    public String getHeaderInfo(int tag, String value) throws IOException {
        String key = this.i2hex(tag);
        String id = (String)dictionary.get(key);
        if (id != null) {
            if (this.vr == 11565 && id != null) {
                this.vr = (id.charAt(0) << 8) + id.charAt(1);
            }
            id = id.substring(2);
        }
        if (value != null) {
            return id + ": " + value;
        }
        switch (this.vr) {
            case 16709: 
            case 16723: 
            case 16724: 
            case 17235: 
            case 17473: 
            case 17491: 
            case 17492: 
            case 18771: 
            case 19535: 
            case 19540: 
            case 20558: 
            case 21320: 
            case 21332: 
            case 21581: 
            case 21833: {
                value = this.getString(this.elementLength);
                break;
            }
            case 21843: {
                if (this.elementLength == 2) {
                    value = Integer.toString(this.getShort());
                    break;
                }
                value = "";
                int n = this.elementLength / 2;
                for (int i = 0; i < n; ++i) {
                    value = value + Integer.toString(this.getShort()) + " ";
                }
                break;
            }
            default: {
                for (long skipCount = (long)this.elementLength; skipCount > 0L; skipCount -= this.f.skip(skipCount)) {
                }
                this.location += this.elementLength;
                value = "";
            }
        }
        if (id == null) {
            return null;
        }
        return id + ": " + value;
    }

    String i2hex(int i) {
        for (int pos = 7; pos >= 0; --pos) {
            DICOMReader.buf8[pos] = Tools.hexDigits[i & 0xF];
            i >>>= 4;
        }
        return new String(buf8);
    }

    String tag2hex(int tag) {
        if (this.buf10 == null) {
            this.buf10 = new char[11];
            this.buf10[4] = 44;
            this.buf10[9] = 32;
        }
        int pos = 8;
        while (pos >= 0) {
            this.buf10[pos] = Tools.hexDigits[tag & 0xF];
            tag >>>= 4;
            if (--pos != 4) continue;
            --pos;
        }
        return new String(this.buf10);
    }

    double s2d(String s) {
        Double d;
        try {
            d = new Double(s);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    void getSpatialScale(FileInfo fi, String scale) {
        double xscale = 0.0;
        double yscale = 0.0;
        int i = scale.indexOf(92);
        if (i > 0) {
            yscale = this.s2d(scale.substring(0, i));
            xscale = this.s2d(scale.substring(i + 1));
        }
        if (xscale != 0.0 && yscale != 0.0) {
            fi.pixelWidth = xscale;
            fi.pixelHeight = yscale;
            fi.unit = "mm";
        }
    }

    boolean dicmFound() {
        return this.dicmFound;
    }

    @Override
    public int getVolumes() {
        return this.volumes;
    }

    public static String setOrientation(String ori) {
        int imagePositionPatient = ori.indexOf("0020,0037");
        String rtn = null;
        String dcs = imagePositionPatient > 0 ? ori.substring(imagePositionPatient + 10).split("\n")[0].split(":")[1] : ori;
        String[] inDCS = dcs.split("\\\\");
        String rowAxis = DICOMReader.getMajorAxis(Float.parseFloat(inDCS[0]), Float.parseFloat(inDCS[1]), Float.parseFloat(inDCS[2]));
        String colAxis = DICOMReader.getMajorAxis(Float.parseFloat(inDCS[3]), Float.parseFloat(inDCS[4]), Float.parseFloat(inDCS[5]));
        if (rowAxis != null && colAxis != null) {
            if ((rowAxis.equals("R") || rowAxis.equals("L")) && (colAxis.equals("A") || colAxis.equals("P"))) {
                rtn = "TRANSVERSE";
            } else if ((colAxis.equals("R") || colAxis.equals("L")) && (rowAxis.equals("A") || rowAxis.equals("P"))) {
                rtn = "TRANSVERSE";
            } else if ((rowAxis.equals("R") || rowAxis.equals("L")) && (colAxis.equals("H") || colAxis.equals("F"))) {
                rtn = "CORONAL";
            } else if ((colAxis.equals("R") || colAxis.equals("L")) && (rowAxis.equals("H") || rowAxis.equals("F"))) {
                rtn = "CORONAL";
            } else if ((rowAxis.equals("A") || rowAxis.equals("P")) && (colAxis.equals("H") || colAxis.equals("F"))) {
                rtn = "SAGITTAL";
            } else if ((colAxis.equals("A") || colAxis.equals("P")) && (rowAxis.equals("H") || rowAxis.equals("F"))) {
                rtn = "SAGITTAL";
            }
        } else {
            rtn = "OBLIQUE";
        }
        return rtn;
    }

    private static String getMajorAxis(float x, float y, float z) {
        String axis = "";
        double obliquityThresholdCosineValue = 0.71;
        String orientationX = x < 0.0f ? "R" : "L";
        String orientationY = y < 0.0f ? "A" : "P";
        String orientationZ = z < 0.0f ? "F" : "H";
        float absX = Math.abs(x);
        float absY = Math.abs(y);
        float absZ = Math.abs(z);
        if ((double)absX > obliquityThresholdCosineValue && absX > absY && absX > absZ) {
            axis = orientationX;
        } else if ((double)absY > obliquityThresholdCosineValue && absY > absX && absY > absZ) {
            axis = orientationY;
        } else if ((double)absZ > obliquityThresholdCosineValue && absZ > absX && absZ > absY) {
            axis = orientationZ;
        }
        return axis;
    }

    public static String getRowAxis(String dcs) {
        String[] inDCS = dcs.split("\\\\");
        return DICOMReader.getMajorAxis(Float.parseFloat(inDCS[0]), Float.parseFloat(inDCS[1]), Float.parseFloat(inDCS[2]));
    }

    public static String getColumnAxis(String dcs) {
        String[] inDCS = dcs.split("\\\\");
        return DICOMReader.getMajorAxis(Float.parseFloat(inDCS[3]), Float.parseFloat(inDCS[4]), Float.parseFloat(inDCS[5]));
    }

    @Override
    public String getOrientation() {
        return ReaderUtils.getOrientationLabel(this.orientation);
    }

    @Override
    public int getOrientationForWriter() {
        return ReaderUtils.getOrientationAsInt(this.getOrientation(), false);
    }

    public double getRescaleIntercept() {
        return this.rescaleIntercept;
    }

    public double getRescaleSlope() {
        return this.rescaleSlope;
    }

    public double getWindowWidth() {
        return this.windowWidth;
    }

    public double getWindowCenter() {
        return this.windowCenter;
    }

    static {
        buf8 = new char[8];
    }
}

