/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.Reader;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public class FileScanner {
    String path;
    BufferedReader reader;
    int nBytes;
    static int scanLimit = 10000;

    public FileScanner(String path) {
        this.path = path;
        this.nBytes = 0;
    }

    public void open() throws IOException {
        FileInputStream filein = new FileInputStream(this.path);
        DataInputStream input = new DataInputStream(filein);
        InputStreamReader streamReader = new InputStreamReader(input);
        this.reader = new BufferedReader(streamReader);
        this.reader.mark(scanLimit);
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public String getDelimitedString(String pattern, String delimiter) throws IOException {
        String line;
        this.reader.reset();
        while ((line = this.reader.readLine()) != null) {
            this.nBytes += line.getBytes().length;
            if (this.nBytes > scanLimit) {
                return null;
            }
            int ind = line.indexOf(pattern);
            if (ind == -1) continue;
            ind = line.indexOf(delimiter);
            if (ind == -1) {
                System.out.println("Scanner:getDelimitedString: found pattern but not delimiter.\n");
                return null;
            }
            String totrim = line.substring(ind + delimiter.length() + 1);
            return totrim.trim();
        }
        return null;
    }
}

