/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.Reader;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.nrg.plexiViewer.utils.FileUtils;
import org.nrg.plexiViewer.utils.UnzipFile;

public abstract class ImageReaderPreparer {
    protected boolean zipped = false;

    protected String unzip(String srcDirectory, String fileName, String destDir) {
        String zext = ".gz";
        String file = srcDirectory + File.separator + fileName;
        File imageFile = new File(file);
        if (!imageFile.exists() && new File(file + zext).exists()) {
            this.zipped = true;
        }
        if (this.zipped) {
            new UnzipFile().gunzip(file, destDir);
            return destDir;
        }
        return srcDirectory;
    }

    protected void unzip(File imageFile, String destDir) {
        String zext = ".gz";
        if (!imageFile.exists() && new File(imageFile.getPath() + zext).exists()) {
            this.zipped = true;
        }
        if (this.zipped) {
            new UnzipFile().gunzip(imageFile.getPath(), destDir);
        }
    }

    protected String unzip(String directory, String fileName) throws IOException {
        String zext = ".gz";
        String file = directory + File.separator + fileName;
        File imageFile = new File(file);
        if (!imageFile.exists() && new File(file + zext).exists()) {
            this.zipped = true;
        }
        if (this.zipped) {
            File tempDir;
            String suffix = "_" + new Random().nextInt();
            File dir = File.createTempFile("NRG", suffix, tempDir = new File(FileUtils.getTempFolder()));
            if (dir.exists()) {
                dir.delete();
            }
            dir.mkdir();
            new UnzipFile().gunzip(file, dir.getPath());
            return dir.getPath();
        }
        return directory;
    }
}

