/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.Servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nrg.plexiViewer.Reader.ReadFileContents;
import org.nrg.plexiViewer.io.IOHelper;
import org.nrg.plexiViewer.lite.UserSelection;
import org.nrg.plexiViewer.lite.io.PlexiImageFile;
import org.nrg.plexiViewer.lite.utils.LiteFileUtils;
import org.nrg.plexiViewer.utils.ArchivePathManager;
import org.nrg.plexiViewer.utils.URIUtils;

public class GetRecFileContents
extends HttpServlet {
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void destroy() {
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ObjectOutputStream out = new ObjectOutputStream((OutputStream)response.getOutputStream());
        try {
            System.out.println("GetRecFileContents Servlet invoked ");
            String contentType = "application/x-java-serialized-object";
            ObjectInputStream inputFromClient = new ObjectInputStream((InputStream)request.getInputStream());
            UserSelection userOptions = (UserSelection)inputFromClient.readObject();
            PlexiImageFile pf = null;
            String cachePathLocation = ArchivePathManager.GetInstance().getCachePathLocation(userOptions.getProject(), userOptions.getSessionLabel());
            if (userOptions.hasFile()) {
                pf = userOptions.getFile();
            } else if (userOptions.hasXnatFile()) {
                pf = IOHelper.getPlexiImageFile(userOptions.getXnatFile(), cachePathLocation, userOptions.getFormattedWindowTitle() + "_" + LiteFileUtils.getFileName(userOptions.getXnatFile()));
            }
            if (pf.getXsiType().equals("plexi:imageResource") || pf.getXsiType().equals("xnat:imageResource")) {
                URIUtils u = new URIUtils(pf.getURIAsString());
                String path = u.getPath();
                String name = u.getName();
                String recFileName = path + File.separator + name + ".rec";
                File recFile = new File(recFileName);
                out.writeObject(ReadFileContents.getContents(recFile));
                out.flush();
            }
        }
        catch (Exception e) {
            System.out.println("Handling exception... ");
            out.writeObject("Rec File Details not available\n");
            out.flush();
        }
    }

    public String getServletInfo() {
        return "Short description";
    }
}

