/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.Servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nrg.plexiViewer.io.ImageLocator;
import org.nrg.plexiViewer.lite.UserSelection;
import org.nrg.plexiViewer.lite.display.MontageDisplay;
import org.nrg.plexiViewer.lite.io.PlexiImageFile;
import org.nrg.plexiViewer.lite.utils.ImageDetails;
import org.nrg.plexiViewer.lite.xml.Layout;
import org.nrg.plexiViewer.lite.xml.MontageView;
import org.nrg.plexiViewer.manager.PlexiStatusPublisherManager;
import org.nrg.plexiViewer.utils.ImageUtils;
import org.nrg.plexiViewer.utils.MailUtils;
import org.nrg.plexiViewer.utils.XnatLoginDetails;
import org.nrg.xdat.security.XDATUser;

public class ImageLoaderServlet
extends HttpServlet {
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void destroy() {
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long startTime = System.currentTimeMillis();
        ObjectOutputStream out = new ObjectOutputStream((OutputStream)response.getOutputStream());
        boolean inCache = false;
        PlexiImageFile pf = new PlexiImageFile();
        String format = null;
        String cloneWithoutFiles = "";
        String requestDetails = "";
        XDATUser user = new XnatLoginDetails().getSessionUser(request);
        try {
            System.out.println("Image Loader Servlet invoked \n");
            String contentType = "application/x-java-serialized-object";
            response.setContentType(contentType);
            ObjectInputStream inputFromClient = new ObjectInputStream((InputStream)request.getInputStream());
            UserSelection options = (UserSelection)inputFromClient.readObject();
            cloneWithoutFiles = options.toString();
            requestDetails = "Session Id : " + options.getSessionId() + " Orientation: " + options.getOrientation();
            PlexiStatusPublisherManager.GetInstance().createPublisher(cloneWithoutFiles);
            PlexiStatusPublisherManager.GetInstance().createSubscriber(cloneWithoutFiles);
            PlexiStatusPublisherManager.GetInstance().getPublisher(cloneWithoutFiles).setValue("Procuring requested Image");
            MontageView mView = null;
            Layout layout = null;
            MontageDisplay mDisplay = null;
            ImageLocator imageLocator = new ImageLocator();
            pf = imageLocator.getImage(options);
            if (pf == null) {
                PlexiStatusPublisherManager.GetInstance().getPublisher(cloneWithoutFiles).setValue("Couldnt launch image builder");
                System.out.println("Couldnt launch the conveter");
                MailUtils.send("PlexiViewer ImageLoader Error", "User " + user.getFirstname() + " " + user.getLastname() + " (" + user.getLogin() + ") from " + request.getRemoteAddr() + " couldnt fetch the requested file.\n " + requestDetails);
                out.writeObject(mDisplay);
                out.flush();
                out.writeObject(pf);
                out.flush();
                return;
            }
            format = pf.getFormat();
            layout = ImageDetails.getLayout(pf.getDimX(), pf.getDimY(), pf.getDimZ(), pf.getVoxelResX(), pf.getVoxelResY(), pf.getVoxelResZ(), pf.getFormat());
            if (mView == null) {
                mView = new MontageView();
                mView.setScale(0.65f);
                Hashtable attribs = ImageUtils.getSliceIncrement(pf.getDimZ());
                mView.addViewInfo(options.getOrientation().toUpperCase(), (Integer)attribs.get("startslice"), (Integer)attribs.get("endslice"), (Integer)attribs.get("increment"));
                mDisplay = new MontageDisplay(mView, options.getOrientation().toUpperCase(), layout);
            }
            System.out.println("Image Loader Servlet is pointing to Hi RES file in " + pf.toString());
            out.writeObject(mDisplay);
            out.flush();
            out.writeObject(pf);
            out.flush();
            System.gc();
            System.out.println("ImageLoaderServlet is about to return. Total time (s) ");
        }
        catch (Exception e) {
            System.out.println("Handling exception...");
            PlexiStatusPublisherManager.GetInstance().getPublisher(cloneWithoutFiles).setValue("Error occured");
            e.printStackTrace();
            MailUtils.send("PlexiViewer ImageLoader Exception", "User " + user.getFirstname() + " " + user.getLastname() + " (" + user.getLogin() + ")  couldnt fetch the requested file. \n " + requestDetails + "\n Stack Trace: \n" + ImageLoaderServlet.getStackTraceVector(e, "string"));
            Object mDisplay = null;
            pf = null;
            out.writeObject(mDisplay);
            out.flush();
            out.writeObject(pf);
            out.flush();
        }
    }

    public static final Object getStackTraceVector(Exception e, String rtnType) {
        ByteArrayOutputStream byteStream = null;
        PrintWriter printWriter = null;
        String stackTrace = null;
        Vector<String> stackArray = new Vector<String>();
        byteStream = new ByteArrayOutputStream();
        printWriter = new PrintWriter(byteStream, true);
        e.printStackTrace(printWriter);
        printWriter.flush();
        stackTrace = byteStream.toString();
        printWriter.close();
        if (rtnType.equalsIgnoreCase("vector")) {
            StringTokenizer tok = new StringTokenizer(stackTrace, "\n");
            while (tok.hasMoreTokens()) {
                String s = tok.nextToken();
                stackArray.add(s);
            }
            return stackArray;
        }
        return stackTrace;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Image Loader Servlet";
    }
}

