/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.Servlet;

import ij.ImagePlus;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nrg.plexiViewer.io.ImageLoader;
import org.nrg.plexiViewer.io.ImageLocator;
import org.nrg.plexiViewer.lite.UserSelection;
import org.nrg.plexiViewer.lite.display.MontageDisplay;
import org.nrg.plexiViewer.lite.io.PlexiImageFile;
import org.nrg.plexiViewer.manager.PlexiStatusPublisherManager;
import org.nrg.plexiViewer.utils.MailUtils;

public class MontageImageLoaderServlet
extends HttpServlet {
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void destroy() {
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long startTime = System.currentTimeMillis();
        ObjectOutputStream out = new ObjectOutputStream((OutputStream)response.getOutputStream());
        PlexiImageFile pf = new PlexiImageFile();
        try {
            System.out.println("Montage Image Loader Servlet invoked \n");
            String contentType = "application/x-java-serialized-object";
            response.setContentType(contentType);
            ObjectInputStream inputFromClient = new ObjectInputStream((InputStream)request.getInputStream());
            UserSelection options = (UserSelection)inputFromClient.readObject();
            Boolean sendImage = (Boolean)inputFromClient.readObject();
            String cloneWithoutFiles = options.toString();
            PlexiStatusPublisherManager.GetInstance().createPublisher(cloneWithoutFiles);
            PlexiStatusPublisherManager.GetInstance().createSubscriber(cloneWithoutFiles);
            PlexiStatusPublisherManager.GetInstance().getPublisher(cloneWithoutFiles).setValue("Procuring requested Image");
            ImageLocator imageLocator = new ImageLocator();
            pf = imageLocator.getImage(options);
            options.setFile(pf);
            ImageLoader loader = new ImageLoader(options);
            ImagePlus image = loader.getImage();
            MontageDisplay mDisplay = loader.getMontageDisplay();
            pf = loader.getPlexiImageFile();
            if (image == null) {
                System.out.println("The image is null");
                MailUtils.send("PlexiViewer MontageImageLoader Error", " Couldnt fetch the requested file " + options);
                out.writeObject(mDisplay);
                out.flush();
                out.writeObject(pf);
                out.flush();
                return;
            }
            pf.setFileType(image.getOriginalFileInfo().fileType);
            pf.setDimX(image.getWidth());
            pf.setDimY(image.getHeight());
            pf.setDimZ(image.getStackSize());
            Object[] stack = image.getStack().getImageArray();
            out.writeObject(mDisplay);
            out.flush();
            out.writeObject(pf);
            out.flush();
            if (sendImage.booleanValue()) {
                for (int i = 0; i < stack.length; ++i) {
                    Object pixels = stack[i];
                    out.writeObject(pixels);
                    out.flush();
                }
            }
            image.flush();
            System.gc();
            System.out.println("MontageImageLoaderServlet is about to return. Total time (s) ");
        }
        catch (Exception e) {
            System.out.println("Handling exception...");
            e.printStackTrace();
            MailUtils.send("PlexiViewer MontageImageDistributor Exception", "MontageImageDistributor encountered an exception " + e.getMessage());
            Object mDisplay = null;
            pf = null;
            out.writeObject(mDisplay);
            out.flush();
            out.writeObject(pf);
            out.flush();
        }
    }

    public static final Vector getStackTraceVector(Exception e) {
        ByteArrayOutputStream byteStream = null;
        PrintWriter printWriter = null;
        String stackTrace = null;
        Vector<String> stackArray = new Vector<String>();
        byteStream = new ByteArrayOutputStream();
        printWriter = new PrintWriter(byteStream, true);
        e.printStackTrace(printWriter);
        printWriter.flush();
        stackTrace = byteStream.toString();
        printWriter.close();
        StringTokenizer tok = new StringTokenizer(stackTrace, "\n");
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            stackArray.add(s);
        }
        return stackArray;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Image Loader Servlet";
    }
}

