/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.Servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nrg.plexiViewer.manager.PlexiStatusPublisherManager;
import org.nrg.plexiViewer.utils.PlexiSubscriberProxy;

public class PublisherServlet
extends HttpServlet {
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void destroy() {
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long startTime = System.currentTimeMillis();
        ObjectOutputStream out = new ObjectOutputStream((OutputStream)response.getOutputStream());
        try {
            String contentType = "application/x-java-serialized-object";
            response.setContentType(contentType);
            ObjectInputStream inputFromClient = new ObjectInputStream((InputStream)request.getInputStream());
            String options = (String)inputFromClient.readObject();
            PlexiSubscriberProxy subscriber = PlexiStatusPublisherManager.GetInstance().getSubscriberProxy(options);
            if (PlexiStatusPublisherManager.GetInstance().isHandled(options) != null) {
                if (((Boolean)PlexiStatusPublisherManager.GetInstance().isHandled(options)).booleanValue()) {
                    out.writeObject("About to receive image....Please wait");
                    out.flush();
                } else if (subscriber != null) {
                    subscriber.register();
                    if (subscriber.hasUpdate()) {
                        out.writeObject(subscriber.getMessage());
                        out.flush();
                    }
                } else {
                    out.writeObject("Processing Request....Please wait");
                    out.flush();
                }
            } else if (subscriber != null) {
                subscriber.register();
                if (subscriber.hasUpdate()) {
                    out.writeObject(subscriber.getMessage());
                    out.flush();
                }
            } else {
                out.writeObject("");
                out.flush();
            }
            long endTime = System.currentTimeMillis();
            out.close();
        }
        catch (Exception e) {
            out.writeObject("Encountered some problem.....");
            out.flush();
            out.close();
            return;
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.out.println("do Get called");
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Publisher Servlet";
    }
}

