/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.Writer;

import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.process.ImageProcessor;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.nrg.plexiViewer.Reader.ReaderUtils;

public class AnalyzeWriter {
    public void save(ImagePlus imp, String directory, String name, String orientation) {
        if (name == null) {
            return;
        }
        if (name.endsWith(".img")) {
            name = name.substring(0, name.length() - 4);
        }
        if (name.endsWith(".hdr")) {
            name = name.substring(0, name.length() - 4);
        }
        if (!directory.endsWith(File.separator)) {
            directory = directory + File.separator;
        }
        try {
            String fileName = directory + name + ".hdr";
            this.writeHeader(imp, fileName, orientation);
        }
        catch (IOException e) {
            System.out.println("FileSaver: " + e.getMessage());
        }
    }

    private void writeHeader(ImagePlus imp, String hdrfile, String orientation) throws IOException {
        int i;
        short bitsallocated;
        short datatype;
        FileOutputStream fileout = new FileOutputStream(hdrfile);
        DataOutputStream output = new DataOutputStream(fileout);
        FileInfo fi = imp.getFileInfo();
        int ori = ReaderUtils.getOrientationAsInt(orientation, true);
        switch (fi.fileType) {
            case 0: {
                datatype = 2;
                bitsallocated = 8;
                break;
            }
            case 1: 
            case 2: {
                datatype = 4;
                bitsallocated = 16;
                break;
            }
            case 3: {
                datatype = 8;
                bitsallocated = 32;
                break;
            }
            case 4: {
                datatype = 16;
                bitsallocated = 32;
                break;
            }
            default: {
                datatype = 0;
                bitsallocated = (short)(fi.getBytesPerPixel() * 8);
            }
        }
        this.writeInt(output, 348);
        for (i = 0; i < 10; ++i) {
            output.write(0);
        }
        for (i = 0; i < 18; ++i) {
            output.write(0);
        }
        this.writeInt(output, 16384);
        output.writeShort(0);
        output.writeByte(114);
        output.writeByte(0);
        this.writeShort(output, (short)4);
        this.writeShort(output, (short)fi.width);
        this.writeShort(output, (short)fi.height);
        this.writeShort(output, (short)fi.nImages);
        this.writeShort(output, (short)1);
        for (i = 0; i < 3; ++i) {
            output.writeShort(0);
        }
        output.writeBytes("mm\u0000\u0000");
        for (i = 0; i < 8; ++i) {
            output.write(0);
        }
        output.writeShort(0);
        this.writeShort(output, datatype);
        this.writeShort(output, bitsallocated);
        output.writeShort(0);
        output.writeFloat(0.0f);
        this.writeFloat(output, (float)fi.pixelWidth);
        this.writeFloat(output, (float)fi.pixelHeight);
        this.writeFloat(output, (float)fi.pixelDepth);
        for (i = 0; i < 4; ++i) {
            output.writeFloat(0.0f);
        }
        output.writeFloat(0.0f);
        output.writeFloat(1.0f);
        output.writeFloat(0.0f);
        output.writeFloat(0.0f);
        output.writeFloat(0.0f);
        output.writeFloat(0.0f);
        output.writeInt(0);
        output.writeInt(0);
        double[] glMaxMin = this.getGlobalMaxMin(imp);
        this.writeInt(output, (int)glMaxMin[0]);
        this.writeInt(output, (int)glMaxMin[1]);
        for (i = 0; i < 80; ++i) {
            output.write(0);
        }
        for (i = 0; i < 24; ++i) {
            output.write(0);
        }
        output.write(ori);
        for (i = 0; i < 10; ++i) {
            output.write(0);
        }
        for (i = 0; i < 10; ++i) {
            output.write(0);
        }
        for (i = 0; i < 10; ++i) {
            output.write(0);
        }
        for (i = 0; i < 10; ++i) {
            output.write(0);
        }
        for (i = 0; i < 10; ++i) {
            output.write(0);
        }
        for (i = 0; i < 10; ++i) {
            output.write(0);
        }
        for (i = 0; i < 3; ++i) {
            output.write(0);
        }
        output.writeInt(0);
        output.writeInt(0);
        output.writeInt(0);
        output.writeInt(0);
        output.writeInt(0);
        output.writeInt(0);
        output.writeInt(0);
        output.writeInt(0);
        output.close();
        fileout.close();
    }

    private void writeInt(DataOutputStream input, int value) throws IOException {
        input.writeInt(value);
    }

    private void writeShort(DataOutputStream input, short value) throws IOException {
        input.writeShort(value);
    }

    private void writeFloat(DataOutputStream input, float value) throws IOException {
        this.writeInt(input, Float.floatToIntBits(value));
    }

    boolean isSigned16Bit(ImagePlus imp) {
        if (imp.getType() != 1) {
            return false;
        }
        return imp.getCalibration().getCValue(0) == -32768.0;
    }

    void add(ImagePlus imp, int value) {
        ImageStack stack = imp.getStack();
        for (int slice = 1; slice <= stack.getSize(); ++slice) {
            ImageProcessor ip = stack.getProcessor(slice);
            short[] pixels = (short[])ip.getPixels();
            for (int i = 0; i < pixels.length; ++i) {
                pixels[i] = (short)((pixels[i] & 0xFFFF) + value);
            }
        }
    }

    double[] getGlobalMaxMin(ImagePlus imp) {
        double[] rtn = new double[2];
        double glmax = 0.0;
        double glmin = 0.0;
        for (int i = 1; i <= imp.getStackSize(); ++i) {
            imp.setSlice(i);
            if (glmax < imp.getStatistics().max) {
                glmax = imp.getStatistics().max;
            }
            if (!(glmin > imp.getStatistics().min)) continue;
            glmin = imp.getStatistics().min;
        }
        rtn[0] = glmax;
        rtn[1] = glmin;
        return rtn;
    }
}

