/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.apps;

import java.util.ArrayList;
import org.nrg.plexiViewer.apps.PlexiConverter;
import org.nrg.plexiViewer.converter.NiftiAsAnalyzeConverter;
import org.nrg.plexiViewer.utils.FileUtils;

public class ExplicitPlexiConverter
extends PlexiConverter {
    public ExplicitPlexiConverter(String[] args) {
        super(args);
    }

    @Override
    void parseFileAndCallConverter(String sessionFile) {
        ArrayList list = FileUtils.parseFile(this.sessionListFile);
        for (String lineInFile : list) {
            String[] lineCols = lineInFile.split("#");
            String fromPath = lineCols[0];
            String fromFile = lineCols[1];
            String toPath = lineCols[2];
            String format = lineCols[3];
            String outOrientation = lineCols[4];
            int sliceNo = Integer.parseInt(lineCols[5]);
            String inOrientation = lineCols[6];
            NiftiAsAnalyzeConverter converter = new NiftiAsAnalyzeConverter(fromPath, fromFile, toPath, inOrientation);
            converter.setFormat(format);
            if (this.minIntensity != -1.0f && this.maxIntensity != -1.0f) {
                converter.setMinIntensity(this.minIntensity);
                converter.setMaxIntensity(this.maxIntensity);
            }
            converter.createThumbnail(outOrientation, sliceNo);
        }
    }

    @Override
    String getUsage() {
        String usage = "Usage: ExplicitPlexiConverter -file <path to file containing session ids> \n";
        usage = usage + "-minIntensity <min intensity> [used only with -file]\n";
        usage = usage + "-maxIntensity <max intensity> [used only with -file]\n";
        usage = usage + "The file passed should have # separated information\n";
        usage = usage + "<path to file>#<name of input file>#<path to write to>#<Image Format>#<orientation>#<slice no>#<Image Orientation>\n";
        return usage;
    }

    public static void main(String[] args) {
        try {
            int status = new ExplicitPlexiConverter(args).create();
            System.out.println("All done");
            System.exit(status);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

