/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.apps;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.util.Hashtable;

public class PlexiMontageMaker {
    public PlexiMontageMaker(String[] argv) {
        CommandLineArguments commandLineArgs = new CommandLineArguments(argv);
    }

    private class CommandLineArguments {
        final String MIN_THRESHOLD = "minThreshold";
        final String MAX_THRESHOLD = "maxThreshold";
        final String FILE = "file";
        final String STARTAT = "startAt";
        final String INCREMENT = "increment";
        final String COLOR_MAP = "colormap";
        Hashtable commandLineArgs = new Hashtable();
        int noOfRequiredArguments = 5;
        boolean colormapDefined = false;

        public CommandLineArguments(String[] argv) {
            int c;
            int foundArgs = 0;
            this.commandLineArgs = new Hashtable();
            LongOpt[] longopts = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("file", 1, null, 102), new LongOpt("minThreshold", 1, null, 109), new LongOpt("maxThreshold", 1, null, 120), new LongOpt("startAt", 1, null, 115), new LongOpt("increment", 1, null, 105), new LongOpt("colormap", 1, null, 99)};
            Getopt g = new Getopt("PlexiMontageMaker", argv, "f:m:x:s:i:c:h;", longopts, true);
            g.setOpterr(false);
            while ((c = g.getopt()) != -1) {
                switch (c) {
                    case 102: {
                        this.commandLineArgs.put("file", g.getOptarg());
                        ++foundArgs;
                        break;
                    }
                    case 109: {
                        this.commandLineArgs.put("minThreshold", new Double(Double.parseDouble(g.getOptarg())));
                        ++foundArgs;
                        break;
                    }
                    case 120: {
                        this.commandLineArgs.put("maxThreshold", new Double(Double.parseDouble(g.getOptarg())));
                        ++foundArgs;
                        break;
                    }
                    case 115: {
                        this.commandLineArgs.put("startAt", new Integer(Integer.parseInt(g.getOptarg())));
                        ++foundArgs;
                        break;
                    }
                    case 105: {
                        this.commandLineArgs.put("increment", new Integer(Integer.parseInt(g.getOptarg())));
                        ++foundArgs;
                        break;
                    }
                    case 99: {
                        this.commandLineArgs.put("colormap", g.getOptarg());
                        this.colormapDefined = true;
                    }
                }
            }
            if (foundArgs < this.noOfRequiredArguments) {
                this.printUsage();
                System.exit(1);
            }
        }

        public void printUsage() {
            System.out.println("PlexiMontageMaker ");
            System.out.println("-file<path to image file whose montage is to be created>");
            System.out.println("-minThreshold<min threshold value (double)>");
            System.out.println("-maxThreshold<max threshold value (double)>");
            System.out.println("-startAt<start slice for the montage (int)>");
            System.out.println("-increment<increment slices for the montage (int)>");
            System.out.println("-colormap<path to color map file>");
        }

        public String getFile() {
            return (String)this.commandLineArgs.get("file");
        }

        public double getMinThreshold() {
            return (Double)this.commandLineArgs.get("minThreshold");
        }

        public double getMaxThreshold() {
            return (Double)this.commandLineArgs.get("maxThreshold");
        }

        public int getStartSlice() {
            return (Integer)this.commandLineArgs.get("startAt");
        }

        public int getIncrement() {
            return (Integer)this.commandLineArgs.get("increment");
        }
    }
}

