/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.converter;

import java.lang.reflect.Constructor;
import java.net.URISyntaxException;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.nrg.plexiViewer.converter.plexiLoResConverterI;
import org.nrg.plexiViewer.lite.UserSelection;
import org.nrg.plexiViewer.lite.io.PlexiImageFile;
import org.nrg.plexiViewer.lite.utils.CreateUtils;

public class ConverterUtils {
    public static synchronized PlexiImageFile convert(UserSelection u) {
        int exitStatus = 0;
        String converterClassName = "org.nrg.plexiViewer.converter.DefaultConverter";
        PlexiImageFile pf = null;
        try {
            Class[] intArgsClass = new Class[]{u.getClass()};
            Object[] intArgs = new Object[]{(UserSelection)u.clone()};
            Class<?> imgConverterClass = Class.forName(converterClassName);
            Constructor<?> intArgsConstructor = imgConverterClass.getConstructor(intArgsClass);
            plexiLoResConverterI imgConverter = (plexiLoResConverterI)CreateUtils.createObject(intArgsConstructor, intArgs);
            System.out.println("Invoking " + imgConverter.getClass().getName());
            exitStatus = imgConverter.convertAndSave(u);
            if (exitStatus != 0) {
                System.out.println("Couldnt launch the conveter");
                return pf;
            }
            pf = imgConverter.getFileLocationAndName();
        }
        catch (ClassNotFoundException e) {
            System.out.println(e);
        }
        catch (NoSuchMethodException e1) {
            System.out.println(e1);
        }
        catch (URISyntaxException e2) {
            System.out.println(e2);
        }
        catch (Exception e3) {
            System.out.println(e3);
        }
        System.out.println("Converter Utils created file in " + pf.toString());
        return pf;
    }

    public static void matchPattern(String fileName, String pattern) {
        Object rtn = null;
        try {
            RE r = new RE(pattern);
            boolean found = r.match(fileName);
        }
        catch (RESyntaxException reE) {
            reE.printStackTrace();
        }
    }
}

