/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.converter;

import ij.ImagePlus;
import ij.process.StackProcessor;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import org.nrg.plexiViewer.io.PlexiFileOpener;
import org.nrg.plexiViewer.lite.io.PlexiFileSaver;
import org.nrg.plexiViewer.lite.io.PlexiImageFile;
import org.nrg.plexiViewer.utils.FileUtils;
import org.nrg.plexiViewer.utils.Transform.PlexiImageOrientor;
import org.nrg.plexiViewer.utils.Transform.PlexiIntensitySetter;
import org.nrg.plexiViewer.utils.Transform.plexiViewerImageRelayer;

public class NonXnatConverter {
    String fromFileName;
    String fromPath;
    String toFileName;
    String toPath;
    String baseOrientation;
    boolean isRadiologic;
    String format = null;
    float minIntensity = -1.0f;
    float maxIntensity = -1.0f;

    public NonXnatConverter(String fPath, String fFileName, String tPath) {
        this.fromFileName = fFileName;
        this.fromPath = fPath;
        this.toPath = tPath;
        this.isRadiologic = false;
    }

    protected ImagePlus openBaseFile(PlexiImageFile pf) {
        if (this.format == null) {
            System.out.println("Missing format");
            return null;
        }
        PlexiFileOpener pfo = new PlexiFileOpener(this.format, pf);
        ImagePlus image = null;
        image = pfo.getImagePlus();
        if (image == null) {
            System.out.println("Image Converter....couldnt find the  Image File");
            return null;
        }
        this.baseOrientation = pfo.getOrientation();
        return image;
    }

    private void setToFileName(String orientation, int sliceNo) {
        this.toFileName = FileUtils.getThumbnailFileName(this.fromFileName, orientation, sliceNo);
    }

    public int createThumbnail(String outOrientation, int slice) {
        try {
            PlexiImageFile pf = new PlexiImageFile();
            pf.setPath(this.fromPath);
            pf.setName(this.fromFileName);
            pf.setXsiType("plexi:imageResource");
            try {
                if (pf.getPath().endsWith("/")) {
                    pf.setURIAsString(pf.getPath() + pf.getName());
                } else {
                    pf.setURIAsString(pf.getPath() + "/" + pf.getName());
                }
            }
            catch (Exception e) {
                System.out.println("URI Exception " + pf.getPath() + " " + pf.getName());
            }
            ImagePlus img = this.openBaseFile(pf);
            if (img == null) {
                return -1;
            }
            PlexiImageOrientor pio = new PlexiImageOrientor(img, this.format);
            img = pio.getImage(this.baseOrientation, outOrientation + "F");
            if (this.minIntensity != -1.0f && this.maxIntensity != -1.0f) {
                PlexiIntensitySetter piSetter = new PlexiIntensitySetter(this.minIntensity, this.maxIntensity);
                piSetter.setIntensities(img, true);
            }
            if (!this.isRadiologic() && img != null && !this.isRadiologic()) {
                StackProcessor sp = new StackProcessor(img.getStack(), img.getProcessor());
                sp.flipHorizontal();
                if (outOrientation.equalsIgnoreCase("sagittal")) {
                    img = new plexiViewerImageRelayer(outOrientation).reverseStacks(img);
                }
            }
            if (!FileUtils.dirExists(this.toPath)) {
                FileUtils.createDirectory(this.toPath);
            }
            String radMarker = "R";
            this.setToFileName(outOrientation, slice);
            img.setSlice(slice);
            img.updateImage();
            if (this.isRadiologic()) {
                radMarker = "L";
            }
            if (!outOrientation.equalsIgnoreCase("SAGITTAL")) {
                img.getProcessor().setColor(new Color(50, 200, 25));
                img.getProcessor().setFont(new Font("Serif", 1, 12));
                img.getProcessor().drawString(radMarker, img.getWidth() - 20, 15);
                img.updateImage();
            }
            PlexiFileSaver fs = new PlexiFileSaver(img.getImage());
            fs.saveImageAsGif(this.toPath + File.separator + this.toFileName);
            System.out.println(this.getClass().getName() + " Created file " + this.toPath + File.separator + this.toFileName);
            pio.clearImage();
            if (img != null) {
                img.flush();
            }
            img = null;
            return 0;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return -1;
        }
    }

    public boolean isRadiologic() {
        return this.isRadiologic;
    }

    public void setRadiologic(boolean isRadiologic) {
        this.isRadiologic = isRadiologic;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public float getMaxIntensity() {
        return this.maxIntensity;
    }

    public void setMaxIntensity(float maxIntensity) {
        this.maxIntensity = maxIntensity;
    }

    public float getMinIntensity() {
        return this.minIntensity;
    }

    public void setMinIntensity(float minIntensity) {
        this.minIntensity = minIntensity;
    }

    public static void main(String[] args) {
        NonXnatConverter converter = new NonXnatConverter("C:\\Archive\\disc1\\OAS1_0001_MR1\\PROCESSED\\MPRAGE\\T88_111", "OAS1_0001_MR1_mpr_n4_anon_111_t88_gfc.img", "C:\\Archive\\disc1\\OAS1_0001_MR1");
        converter.setFormat("ANALYZE");
        converter.createThumbnail("CORONAL", 66);
        System.out.println("Created file");
    }
}

