/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.converter;

import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.FileSaver;
import java.io.File;
import java.net.URISyntaxException;
import java.util.Enumeration;
import org.nrg.plexiViewer.Writer.AnalyzeWriter;
import org.nrg.plexiViewer.converter.CNL4dfp8BITConverter;
import org.nrg.plexiViewer.converter.plexiLoResConverterI;
import org.nrg.plexiViewer.io.PlexiFileOpener;
import org.nrg.plexiViewer.lite.UserSelection;
import org.nrg.plexiViewer.lite.io.PlexiImageFile;
import org.nrg.plexiViewer.lite.xml.HiRes;
import org.nrg.plexiViewer.lite.xml.LoRes;
import org.nrg.plexiViewer.lite.xml.ViewableItem;
import org.nrg.plexiViewer.manager.PlexiSpecDocReader;
import org.nrg.plexiViewer.utils.FileUtils;
import org.nrg.plexiViewer.utils.ImageUtils;
import org.nrg.plexiViewer.utils.Transform.AffineTransformer;
import org.nrg.plexiViewer.utils.Transform.PlexiImageOrientor;
import org.nrg.plexiViewer.utils.Transform.PlexiIntensitySetter;
import org.nrg.plexiViewer.utils.Transform.TransformationTools;
import org.nrg.plexiViewer.utils.Transform.plexiViewerImageRelayer;
import org.nrg.xft.XFT;

public class OasisDefaultConverter
implements plexiLoResConverterI {
    HiRes hRes;
    LoRes lRes = null;
    UserSelection options;
    FileInfo fi;
    String fromFileName;
    String toFileName = null;
    String fromPath;
    String toPath = null;
    String cachePath;
    String baseOrientation;
    double minIntensity;
    double maxIntensity;
    boolean single = false;
    ViewableItem viewableItem;

    public OasisDefaultConverter(UserSelection options) {
        this.options = options;
        this.viewableItem = PlexiSpecDocReader.GetInstance().getSpecDoc(options.getProject()).getViewableItem(options.getDataType());
        this.hRes = this.viewableItem.getHiRes();
        if (options.getLoResType() != null) {
            this.lRes = this.viewableItem.getLoRes(options.getLoResType());
        }
    }

    public int convert() {
        if (this.options.getHiResLayerNum() >= 0 && this.options.getOrientation() != null) {
            this.single = true;
        } else if (this.options.hasFile() && this.options.getOrientation() != null) {
            this.single = true;
        }
        System.out.println("Create for a single file: " + this.single);
        return this.doConvert();
    }

    private ImagePlus getImage(Integer layerNum) {
        String sessionId = this.options.getSessionId();
        String scanNo = this.options.getScanNo();
        PlexiImageFile pf = FileUtils.getHiResFilePath(sessionId, this.options.getProject(), this.options.getDataType(), layerNum, this.options.getScanNo());
        this.fromPath = pf.getPath();
        this.fromFileName = pf.getName();
        System.out.println("From File Name is " + this.fromFileName);
        this.cachePath = pf.getCachePath();
        ImagePlus image = null;
        image = this.openBaseFile(pf);
        if (image == null) {
            System.out.println("Couldnt create HiRes image...Exiting\n");
            return null;
        }
        return image;
    }

    private ImagePlus getImage() {
        String sessionId = this.options.getSessionId();
        String scanNo = this.options.getScanNo();
        PlexiImageFile pf = this.options.getFile();
        if (pf == null) {
            pf = FileUtils.getHiResFilePath(sessionId, this.options.getProject(), this.options.getDataType(), this.options.getHiResLayerNum(), this.options.getScanNo());
        }
        this.fromPath = pf.getPath();
        this.fromFileName = pf.getName();
        this.cachePath = pf.getCachePath();
        ImagePlus image = null;
        image = this.openBaseFile(pf);
        if (image == null) {
            System.out.println("Couldnt create HiRes image...Exiting\n");
            return null;
        }
        return image;
    }

    private String getToFileName() {
        return this.toFileName;
    }

    private String setToFileName() {
        String ext = "HiRes";
        if (this.options.getLoResType() != null) {
            ext = this.options.getLoResType();
        }
        this.toFileName = FileUtils.getLoResFileName(this.fromFileName, ext, this.options.getOrientation());
        return this.toFileName;
    }

    private void setNames(ImagePlus image) {
        this.setToFileName();
        if (this.toPath == null) {
            this.toPath = this.toPath = PlexiSpecDocReader.GetInstance().getSpecDoc(this.options.getProject()).getLoResArchiveLocation(this.options.getSessionId());
        }
        if (!FileUtils.fileExists(this.toPath, this.toFileName) || this.options.canOverwrite()) {
            ImagePlus adjust = new ImagePlus();
            adjust.setCalibration(image.getCalibration());
            adjust.setStack("", image.getStack());
            adjust.setFileInfo(image.getOriginalFileInfo());
            this.doPerform(adjust);
            image.flush();
            image = null;
            adjust.flush();
            Object var2_2 = null;
        } else {
            System.out.println("File already exists" + this.toPath + File.separator + this.toFileName);
        }
    }

    private int doConvert() {
        String sessionId = this.options.getSessionId();
        int status = 0;
        if (this.single) {
            ImagePlus image = this.getImage();
            if (image == null) {
                System.out.println("DefaultConvereter::doConvert image is null");
                return 1;
            }
            this.setNames(image);
            if (image != null) {
                image.flush();
            }
            image = null;
        } else {
            Enumeration e = this.hRes.getLayersHash().keys();
            while (e.hasMoreElements()) {
                Integer layerNum = (Integer)e.nextElement();
                ImagePlus image = this.getImage(layerNum);
                if (image == null) {
                    return 1;
                }
                String oldOri = this.options.getOrientation();
                this.options.setOrientation("Transverse");
                this.setNames(image);
                image = this.getImage(layerNum);
                this.options.setOrientation("Coronal");
                this.setNames(image);
                image = this.getImage(layerNum);
                this.options.setOrientation("Sagittal");
                this.setNames(image);
                this.options.setOrientation(oldOri);
                if (image != null) {
                    image.flush();
                }
                image = null;
            }
        }
        System.gc();
        return status;
    }

    private ImagePlus openBaseFile(PlexiImageFile pf) {
        PlexiFileOpener pfo = new PlexiFileOpener(this.viewableItem.getHiRes().getFormat(), pf);
        ImagePlus image = null;
        image = pfo.getImagePlus();
        if (image == null) {
            System.out.println("Image Converter....couldnt find the  Image File");
            return null;
        }
        this.baseOrientation = pfo.getOrientation();
        System.out.println("The in ori is " + this.baseOrientation);
        if (this.viewableItem.getHiRes().getFormat().equalsIgnoreCase("IFH")) {
            image = new plexiViewerImageRelayer(this.baseOrientation).Format4dfpImageForImageJ(image);
            this.baseOrientation = pfo.getOrientation() + "F";
        }
        return image;
    }

    private int doPerform(ImagePlus img) {
        try {
            if (this.lRes != null) {
                if (this.lRes.getCropDetails().deleteSlices()) {
                    img = TransformationTools.dropSlices(img, this.lRes.getCropDetails().getStartSlice(), this.lRes.getCropDetails().getEndSlice());
                }
                if (this.lRes.getCropDetails().crop()) {
                    img = TransformationTools.crop(img, this.lRes.getCropDetails().getBoundingRectangle());
                }
            }
            AffineTransformer affineTransformer = new AffineTransformer();
            img = affineTransformer.transform(img);
            PlexiImageOrientor pio = new PlexiImageOrientor(img, this.viewableItem.getHiRes().getFormat());
            ImagePlus img1 = pio.getImage(this.baseOrientation, this.options.getOrientation() + "F");
            PlexiIntensitySetter piSetter = new PlexiIntensitySetter(this.hRes);
            piSetter.setIntensities(img1, true);
            if (!FileUtils.dirExists(this.toPath)) {
                FileUtils.createDirectory(this.toPath);
            }
            new FileSaver(img1).saveAsRawStack(this.toPath + File.separator + this.toFileName);
            img1.setFileInfo(ImageUtils.getFileInfo(img1.getCalibration(), img1.getWidth(), img1.getHeight(), img1.getStackSize()));
            new AnalyzeWriter().save(img1, this.toPath, this.toFileName, this.options.getOrientation() + "F");
            pio.clearImage();
            img1.flush();
            img1 = null;
            if (img != null) {
                img.flush();
            }
            img = null;
            System.out.println(this.getClass().getName() + " Created file " + this.toPath + File.separator + this.toFileName);
            return 0;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return -1;
        }
    }

    @Override
    public PlexiImageFile getFileLocationAndName() throws URISyntaxException {
        PlexiImageFile pf = new PlexiImageFile();
        pf.setName(this.toFileName);
        pf.setPath(this.toPath);
        pf.setCachePath(this.cachePath);
        return pf;
    }

    @Override
    public int convertAndSave(UserSelection u) {
        this.options = u;
        return this.convert();
    }

    public static void main(String[] args) {
        UserSelection u = new UserSelection();
        u.setSessionId("000115_92046");
        u.setLoResType("8bit");
        u.setDataType("RAW");
        u.setOrientation("SAGITTAL");
        u.setDisplay("STACK");
        u.setHiResLayerNum(0);
        try {
            XFT.init((String)"C:\\jakarta-tomcat-5.5.4\\webapps\\cnda_xnat", (boolean)true, (boolean)true);
            CNL4dfp8BITConverter c = new CNL4dfp8BITConverter(u);
            c.convertAndSave(u);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

