/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.converter;

import ij.ImagePlus;
import java.io.File;
import org.nrg.pipeline.xmlbeans.xnat.AbstractResource;
import org.nrg.pipeline.xmlbeans.xnat.ImageResource;
import org.nrg.pipeline.xmlbeans.xnat.PETSessionDocument;
import org.nrg.pipeline.xmlbeans.xnat.PetSessionData;
import org.nrg.pipeline.xmlreader.XmlReader;
import org.nrg.plexiViewer.io.IOHelper;
import org.nrg.plexiViewer.io.PlexiFileOpener;
import org.nrg.plexiViewer.lite.io.PlexiFileSaver;
import org.nrg.plexiViewer.lite.io.PlexiImageFile;
import org.nrg.plexiViewer.utils.FileUtils;
import org.nrg.plexiViewer.utils.LUTApplier;
import org.nrg.plexiViewer.utils.Transform.PlexiImageOrientor;
import org.nrg.plexiViewer.utils.Transform.PlexiMontageMaker;
import org.nrg.xnattools.xml.XMLSearch;

public class PIBQCImageCreator {
    String session;
    String xnatId;
    String host;
    String user;
    String pwd;
    boolean radiologic = false;
    int exitStatus = 0;
    String lkupfile;
    String petimageContent;
    String mrimageContent;
    String archiveDir;
    Double minThreshold;
    Double maxThreshold;

    public PIBQCImageCreator(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-session")) {
                if (i + 1 >= args.length) continue;
                this.session = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-xnatId")) {
                if (i + 1 >= args.length) continue;
                this.xnatId = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-host")) {
                if (i + 1 >= args.length) continue;
                this.host = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-u")) {
                if (i + 1 >= args.length) continue;
                this.user = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-pwd")) {
                if (i + 1 >= args.length) continue;
                this.pwd = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-r")) {
                this.radiologic = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-lut")) {
                this.lkupfile = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-pc")) {
                this.petimageContent = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-mc")) {
                this.mrimageContent = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-a")) {
                this.archiveDir = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-mtmin")) {
                this.minThreshold = Double.valueOf(args[i + 1]);
                continue;
            }
            if (!args[i].equalsIgnoreCase("-mtmax")) continue;
            this.maxThreshold = Double.valueOf(args[i + 1]);
        }
        if (this.session == null || this.host == null || this.user == null || this.pwd == null || this.lkupfile == null || this.petimageContent == null || this.mrimageContent == null || this.archiveDir == null) {
            this.handleError();
        }
    }

    public void createQCRawImages() {
        File qcFolder = null;
        try {
            String createdFile = new XMLSearch(this.host, this.user, this.pwd).searchFirst("xnat:petSessionData.ID", this.xnatId, "=", "xnat:petSessionData", FileUtils.getTempFolder());
            PETSessionDocument petSession = (PETSessionDocument)new XmlReader().read(createdFile, true);
            String sessionPath = this.archiveDir + File.separator + petSession.getPETSession().getLabel();
            qcFolder = new File(sessionPath + File.separator + "QC");
            if (!qcFolder.exists()) {
                qcFolder.mkdir();
            }
            ImageResource rsc = this.getImage(petSession, this.petimageContent);
            ImageResource mrrsc = this.getImage(petSession, this.mrimageContent);
            if (!rsc.getURI().startsWith("/")) {
                rsc.setURI(this.getPath(petSession, rsc.getURI()));
            }
            if (!mrrsc.getURI().startsWith("/")) {
                mrrsc.setURI(this.getPath(petSession, mrrsc.getURI()));
            }
            PlexiImageFile pf = IOHelper.getPlexiImageFileFromImageResource((AbstractResource)rsc);
            ImagePlus petimg = PlexiFileOpener.openBaseFile(pf, this.radiologic);
            this.setMinValueToZero(petimg);
            LUTApplier lut = new LUTApplier(this.lkupfile);
            petimg = lut.applyLUT(petimg);
            pf = IOHelper.getPlexiImageFileFromImageResource((AbstractResource)mrrsc);
            ImagePlus mrimg = PlexiFileOpener.openBaseFile(pf, this.radiologic);
            this.threshold(mrimg);
            String filename = qcFolder + File.separator + petSession.getPETSession().getLabel() + "_QC";
            this.createMontage(filename, petimg, mrimg, pf.getOrientation());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.exitStatus = 1;
        }
        if (this.exitStatus == 0) {
            System.out.println("Created QC file in " + qcFolder);
        }
    }

    private void threshold(ImagePlus img) {
        img.getProcessor().setMinAndMax(150.0, 1400.0);
    }

    private void setMinValueToZero(ImagePlus img) {
        double max = img.getProcessor().getMax();
        this.setMinValue(img, 0.0, max);
    }

    private void setMinValue(ImagePlus img, double min, double max) {
        img.getProcessor().setMinAndMax(min, max);
    }

    private void createMontage(String rootfilename, ImagePlus petimage, ImagePlus mrimage, String acquiredOrientation) {
        int cols = 7;
        int rows = 4;
        int increment = 2;
        int startslice = 10;
        for (int i = 0; i < rows; ++i) {
            int end = startslice + (cols - 1) * increment;
            this.createJpeg(rootfilename + "_p" + i + "_t.jpg", petimage, cols, startslice, end, increment);
            this.createJpeg(rootfilename + "_m" + i + "_t.jpg", mrimage, cols, startslice, end, increment);
            startslice = end + increment;
        }
        PlexiImageOrientor pio = new PlexiImageOrientor(petimage, "IFH");
        ImagePlus petimage1 = pio.getImage(acquiredOrientation, "sagittalF");
        pio = new PlexiImageOrientor(mrimage, "IFH");
        ImagePlus mrimage1 = pio.getImage(acquiredOrientation, "sagittalF");
        cols = 6;
        rows = 1;
        increment = 4;
        startslice = 54;
        for (int i = 0; i < rows; ++i) {
            int end = startslice + (cols - 1) * increment;
            this.createJpeg(rootfilename + "_ps" + i + "_t.jpg", petimage1, cols, startslice, end, increment);
            this.createJpeg(rootfilename + "_ms" + i + "_t.jpg", mrimage1, cols, startslice, end, increment);
            startslice = end + increment;
        }
    }

    private String getPath(PETSessionDocument petSession, String uri) {
        String rtn = null;
        int indexofSession = uri.indexOf(petSession.getPETSession().getLabel());
        int indexOfProcessed = uri.indexOf("/PROCESSED/");
        if (indexofSession != -1) {
            String sessionPostfix = uri.substring(indexofSession, indexOfProcessed);
            rtn = this.archiveDir + File.separator + sessionPostfix + uri.substring(indexOfProcessed);
        }
        return rtn;
    }

    private void createJpeg(String filename, ImagePlus img, int cols, int startslice, int endslice, int increment) {
        PlexiMontageMaker mm = new PlexiMontageMaker();
        ImagePlus montage = mm.makeMontage(img, cols, 1, 1.0, startslice, endslice, increment, true, false);
        PlexiFileSaver fs = new PlexiFileSaver();
        fs = new PlexiFileSaver();
        fs.saveAsJpeg(montage, filename, 100);
    }

    private ImageResource getImage(PETSessionDocument petSession, String imageContent) throws Exception {
        PetSessionData petSessionData = petSession.getPETSession();
        ImageResource rtn = null;
        if (petSessionData.isSetReconstructions()) {
            for (int i = 0; i < petSessionData.getReconstructions().getReconstructedImageArray(0).getOut().sizeOfFileArray(); ++i) {
                AbstractResource outFile = petSessionData.getReconstructions().getReconstructedImageArray(0).getOut().getFileArray(i);
                ImageResource rsc = (ImageResource)outFile.changeType(ImageResource.type);
                if (!rsc.getContent().equalsIgnoreCase(imageContent)) continue;
                rtn = rsc;
                break;
            }
        }
        return rtn;
    }

    private void handleException(String methodName, String msg, Exception e) {
        System.out.println(" PIBQCImageCreator." + methodName + " encountered problem " + (e == null ? "" : e.getMessage()) + " \n MSG: " + msg);
        System.exit(this.exitStatus);
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    private void handleError() {
        System.out.println("Insufficient arguments");
        this.printUsage();
        System.exit(1);
    }

    protected void printUsage() {
        System.out.println("PIBQCImageCreator OPTIONS:");
        System.out.println("\t\t-session <pet-session label>");
        System.out.println("\t\t-xnatId <pet-session xnat id>");
        System.out.println("\t\t-host <xnat host>");
        System.out.println("\t\t-u <xnat username>");
        System.out.println("\t\t-pwd <xnat password>");
        System.out.println("\t\t-lut <lkup file>");
        System.out.println("\t\t-pc <PET Image Content Code>");
        System.out.println("\t\t-mc <MR Image Content Code>");
        System.out.println("\t\t-a <Root archive path>");
        System.out.println("\t\t-mtmin <Min threshold for MR Image>");
        System.out.println("\t\t-mtmax <Max threshold for MR Image>");
    }

    public static void main(String[] args) {
        PIBQCImageCreator qc = new PIBQCImageCreator(args);
        qc.createQCRawImages();
        System.out.println("All done");
        System.exit(qc.getExitStatus());
    }
}

