/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.converter;

import ij.ImagePlus;
import ij.ImageStack;
import ij.process.StackProcessor;
import java.awt.Color;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.List;
import javax.xml.rpc.ServiceException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.xmlbeans.XmlException;
import org.nrg.pipeline.xmlbeans.xnat.AbstractResource;
import org.nrg.pipeline.xmlbeans.xnat.DicomSeries;
import org.nrg.pipeline.xmlbeans.xnat.ImageResource;
import org.nrg.pipeline.xmlbeans.xnat.ImageScanData;
import org.nrg.pipeline.xmlbeans.xnat.Resource;
import org.nrg.pipeline.xmlbeans.xnat.ResourceCatalog;
import org.nrg.pipeline.xmlbeans.xnat.ResourceSeries;
import org.nrg.plexiViewer.io.IOHelper;
import org.nrg.plexiViewer.io.PlexiFileOpener;
import org.nrg.plexiViewer.lite.io.PlexiFileSaver;
import org.nrg.plexiViewer.lite.io.PlexiImageFile;
import org.nrg.plexiViewer.utils.ImageUtils;
import org.nrg.plexiViewer.utils.Transform.BitConverter;
import org.nrg.plexiViewer.utils.Transform.IntensitySetter;
import org.nrg.plexiViewer.utils.Transform.PlexiMontageMaker;
import org.nrg.xdat.bean.ArcProjectBean;
import org.nrg.xdat.bean.XnatAbstractresourceBean;
import org.nrg.xdat.bean.XnatDicomseriesBean;
import org.nrg.xdat.bean.XnatImageresourceBean;
import org.nrg.xdat.bean.XnatImageresourceseriesBean;
import org.nrg.xdat.bean.XnatImagescandataBean;
import org.nrg.xdat.bean.XnatImagesessiondataBean;
import org.nrg.xdat.bean.XnatResourceBean;
import org.nrg.xdat.bean.XnatResourcecatalogBean;
import org.nrg.xdat.bean.XnatResourceseriesBean;
import org.nrg.xdat.bean.base.BaseElement;
import org.nrg.xdat.bean.reader.XDATXMLReader;
import org.nrg.xnattools.service.WebServiceClient;
import org.nrg.xnattools.xml.XMLSearch;
import org.xml.sax.SAXException;

public class WebBasedQCImageCreator {
    String session;
    String xnatId;
    String host;
    String user;
    String pwd;
    String cachepath;
    String workflowid = null;
    String projectId;
    boolean raw = false;
    boolean radiologic = false;
    int exitStatus = 0;

    public WebBasedQCImageCreator(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-project")) {
                if (i + 1 >= args.length) continue;
                this.projectId = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-xnatId")) {
                if (i + 1 >= args.length) continue;
                this.xnatId = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-session")) {
                if (i + 1 >= args.length) continue;
                this.session = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-host")) {
                if (i + 1 >= args.length) continue;
                this.host = args[i + 1];
                if (!this.host.endsWith("/")) continue;
                this.host = this.host.substring(0, this.host.length() - 1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-u")) {
                if (i + 1 >= args.length) continue;
                this.user = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-pwd")) {
                if (i + 1 >= args.length) continue;
                this.pwd = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-raw")) {
                this.raw = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-r")) {
                this.radiologic = true;
                continue;
            }
            if (!args[i].equalsIgnoreCase("-workflowid") || i + 1 >= args.length) continue;
            this.workflowid = args[i + 1];
        }
        if (this.session == null || this.xnatId == null || this.host == null || this.user == null || this.pwd == null) {
            this.handleError();
        }
    }

    public void createQCImages() throws URISyntaxException, SAXException, ServiceException, MalformedURLException, RemoteException, IOException, XmlException {
        String uriString = "REST/projects/" + this.projectId + "/archive_spec";
        WebServiceClient webServiceClient = new WebServiceClient(this.host, this.user, this.pwd);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        webServiceClient.connect(uriString, (OutputStream)out);
        ByteArrayInputStream inStream = new ByteArrayInputStream(out.toByteArray());
        XDATXMLReader reader = new XDATXMLReader();
        BaseElement base = reader.parse((InputStream)inStream);
        ArcProjectBean arcProject = (ArcProjectBean)base;
        this.cachepath = arcProject.getPaths().getCachepath();
        out.close();
        ((InputStream)inStream).close();
        this.checkFolders();
        if (this.raw) {
            this.createQCRawImages();
        }
    }

    private void checkFolders() {
        if (!this.cachepath.endsWith(this.session)) {
            this.cachepath = this.cachepath + File.separator + this.session;
        }
        this.checkFolders(this.cachepath);
    }

    private void checkFolders(String path) {
        File tbFolder;
        if (path == null) {
            this.handleError();
        }
        if (!(tbFolder = new File(path)).exists()) {
            try {
                boolean success = tbFolder.mkdirs();
                if (!success) {
                    this.handleException("checkFolders", "Failed to create " + path, null, null);
                }
            }
            catch (Exception e) {
                this.handleException("checkFolders", "Unable to create thumbnail folder " + path, e, null);
            }
        }
    }

    private void handleException(String methodName, String msg, Exception e, String service_session) {
        if (service_session != null) {
            try {
                WebServiceClient webServiceClient = new WebServiceClient(this.host, this.user, this.pwd);
                webServiceClient.closeServiceSession(service_session);
            }
            catch (Exception e1) {
                e.printStackTrace();
            }
        }
        System.out.println(" QCImageCreator." + methodName + " encountered problem " + (e == null ? "" : e.getMessage()) + " \n MSG: " + msg);
        System.exit(this.exitStatus);
    }

    private void handleError() {
        System.out.println("Insufficient arguments");
        this.printUsage();
        System.exit(1);
    }

    protected void printUsage() {
        System.out.println("QCImageCreator OPTIONS:");
        System.out.println("\t\t-session <proejct mr-session id>");
        System.out.println("\t\t-project <proejct that the mr-session belongs to>");
        System.out.println("\t\t-xnatId <xnat mr-session id>");
        System.out.println("\t\t-host <xnat host>");
        System.out.println("\t\t-u <xnat username>");
        System.out.println("\t\t-pwd <xnat password>");
        System.out.println("\t\t-raw <create QC files for raw scans only>");
    }

    private XnatAbstractresourceBean getScanFile(XnatImagesessiondataBean imageession, XnatImagescandataBean scan) {
        XnatAbstractresourceBean file = null;
        String scanType = scan.getType();
        String rawScanContentCode = scanType + "_RAW";
        List files = scan.getFile();
        if (files.size() > 0) {
            if (files.size() == 1) {
                file = (XnatAbstractresourceBean)files.get(0);
            } else {
                file = this.getFileByContent(scan, rawScanContentCode);
                if (file == null) {
                    file = this.getFileByContent(scan, "RAW");
                }
            }
        }
        return file;
    }

    private AbstractResource getFileByContent(ImageScanData mrScan, String content) {
        AbstractResource rtn = null;
        try {
            for (int i = 0; i < mrScan.sizeOfFileArray(); ++i) {
                ResourceCatalog resourceCat;
                ResourceSeries resourceSeries;
                AbstractResource f = mrScan.getFileArray(i);
                if (f.schemaType().getName().getLocalPart().equals(Resource.type.getName().getLocalPart())) {
                    Resource resource = (Resource)f.changeType(Resource.type);
                    if (!resource.getContent().equals(content)) continue;
                    rtn = f;
                    continue;
                }
                if (f.schemaType().getName().getLocalPart().equals(ImageResource.type.getName().getLocalPart())) {
                    ImageResource imageResource = (ImageResource)f.changeType(ImageResource.type);
                    if (!imageResource.getContent().equals(content)) continue;
                    rtn = f;
                    continue;
                }
                if (f.schemaType().getName().getLocalPart().equals(ResourceSeries.type.getName().getLocalPart())) {
                    resourceSeries = (ResourceSeries)f.changeType(ResourceSeries.type);
                    if (!resourceSeries.getContent().equals(content)) continue;
                    rtn = f;
                    continue;
                }
                if (f.schemaType().getName().getLocalPart().equals(DicomSeries.type.getName().getLocalPart())) {
                    resourceSeries = (DicomSeries)f.changeType(DicomSeries.type);
                    if (!resourceSeries.getContent().equals(content)) continue;
                    rtn = f;
                    continue;
                }
                if (!f.schemaType().getName().getLocalPart().equals(ResourceCatalog.type.getName().getLocalPart()) || !(resourceCat = (ResourceCatalog)f.changeType(ResourceCatalog.type)).getContent().equals(content)) continue;
                rtn = f;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rtn;
    }

    private XnatAbstractresourceBean getFileByContent(XnatImagescandataBean scan, String content) {
        XnatAbstractresourceBean rtn = null;
        try {
            List files = scan.getFile();
            for (int i = 0; i < files.size(); ++i) {
                XnatResourceseriesBean resourceSeries;
                XnatAbstractresourceBean f = (XnatAbstractresourceBean)files.get(i);
                if (f instanceof XnatResourceBean) {
                    XnatResourceBean resource = (XnatResourceBean)f;
                    if (!resource.getContent().equals(content)) continue;
                    rtn = f;
                } else if (f instanceof XnatImageresourceBean) {
                    XnatImageresourceBean imageResource = (XnatImageresourceBean)f;
                    if (!imageResource.getContent().equals(content)) continue;
                    rtn = f;
                } else if (f instanceof XnatResourceseriesBean) {
                    resourceSeries = (XnatResourceseriesBean)f;
                    if (!resourceSeries.getContent().equals(content)) continue;
                    rtn = f;
                } else if (f instanceof XnatDicomseriesBean) {
                    resourceSeries = (XnatDicomseriesBean)f;
                    if (!resourceSeries.getContent().equals(content)) continue;
                    rtn = f;
                } else {
                    XnatResourcecatalogBean resourceCat;
                    if (!(f instanceof XnatResourcecatalogBean) || !(resourceCat = (XnatResourcecatalogBean)f).getContent().equals(content)) continue;
                    rtn = f;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void createQCRawImages() {
        WebServiceClient webserviceClient = null;
        String service_session = null;
        webserviceClient = new WebServiceClient(this.host, this.user, this.pwd);
        service_session = webserviceClient.createServiceSession();
        BaseElement baseElement = new XMLSearch(this.host, this.user, this.pwd).getBeanFromHost(this.xnatId, true);
        XnatImagesessiondataBean imageSessionBean = (XnatImagesessiondataBean)baseElement;
        List scans = imageSessionBean.getScans_scan();
        if (scans.size() > 0) {
            for (int i = 0; i < scans.size(); ++i) {
                PlexiImageFile pf;
                XnatImagescandataBean scan;
                block21: {
                    XnatAbstractresourceBean file;
                    scan = (XnatImagescandataBean)scans.get(i);
                    service_session = webserviceClient.refreshServiceSession(service_session);
                    List files = scan.getFile();
                    if (files.size() <= 0 || (file = this.getScanFile(imageSessionBean, scan)) == null) continue;
                    pf = new PlexiImageFile();
                    try {
                        XnatImageresourceseriesBean imageResourceSeries;
                        pf = this.getPlexiImageFile(file, scan.getId());
                        if (!(file instanceof XnatImageresourceseriesBean) || !(imageResourceSeries = (XnatImageresourceseriesBean)file).getFormat().equalsIgnoreCase("IMA")) break block21;
                        pf.setPath(this.cachepath);
                        pf.setName(pf.getName() + ".4dfp.img");
                        pf.setXsiType("plexi:imageResource");
                        pf.setFormat("IFH");
                        try {
                            if (pf.getPath().endsWith("/")) {
                                pf.setURIAsString(pf.getPath() + pf.getName());
                                break block21;
                            }
                            pf.setURIAsString(pf.getPath() + "/" + pf.getName());
                        }
                        catch (Exception e) {
                            System.out.println("URI Exception " + pf.getPath() + " " + pf.getName());
                        }
                    }
                    catch (Exception e) {
                        this.handleException("createQCRawImages", "Unable to open imageresource images", e, service_session);
                    }
                }
                try {
                    ImagePlus baseimage = PlexiFileOpener.openBaseFile(pf, this.radiologic);
                    if (baseimage == null) {
                        throw new Exception("Image File is null for scan " + scan.getId());
                    }
                    this.createThumbnail(baseimage, scan, service_session);
                    if (baseimage != null) {
                        baseimage.flush();
                    }
                    baseimage = null;
                    continue;
                }
                catch (Exception e) {
                    System.out.println("QCImageCreator failed for session " + this.session + " scan " + scan.getId() + " CAUSE " + e.getMessage());
                    e.printStackTrace();
                    this.exitStatus = 2;
                }
            }
        }
        if (webserviceClient == null) return;
        try {
            webserviceClient.closeServiceSession(service_session);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.exitStatus = 1;
        }
        return;
        catch (Exception e) {
            try {
                System.out.println("WebBasedQCImageCreator failed for session " + this.session + " CAUSE " + e.getMessage());
                e.printStackTrace();
                this.exitStatus = 1;
                this.handleException("CreateQCRawImages", "", e, service_session == null ? "" : service_session);
                if (webserviceClient == null) return;
            }
            catch (Throwable throwable) {
                if (webserviceClient == null) throw throwable;
                try {
                    webserviceClient.closeServiceSession(service_session);
                    throw throwable;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    this.exitStatus = 1;
                }
                throw throwable;
            }
            try {
                webserviceClient.closeServiceSession(service_session);
                return;
            }
            catch (Exception e3) {
                e3.printStackTrace();
                this.exitStatus = 1;
            }
            return;
        }
    }

    private ImagePlus getSnapshot(ImagePlus baseimage, boolean montage) {
        ImagePlus rtn = null;
        if (montage) {
            rtn = this.createMontage(baseimage);
        } else if (baseimage != null) {
            int sliceNo = 5;
            if (baseimage.getStackSize() == 1) {
                sliceNo = 1;
            } else if (baseimage.getStackSize() < sliceNo) {
                sliceNo = 2;
            }
            baseimage.setSlice(sliceNo);
            baseimage.updateImage();
            baseimage.getProcessor().setColor(Color.WHITE);
            baseimage.getProcessor().setFont(new Font("Serif", 1, 10));
            baseimage.getProcessor().drawString("Frame: " + sliceNo, baseimage.getWidth() - 50, baseimage.getHeight() - 5);
            baseimage.updateImage();
            rtn = baseimage;
        }
        return rtn;
    }

    private void createThumbnail(ImagePlus baseimage, XnatImagescandataBean scan, String uri, String service_session) throws Exception {
        ImagePlus snapshot = null;
        snapshot = scan.getType() != null ? (!scan.getType().equalsIgnoreCase("BOLD") ? this.getSnapshot(baseimage, true) : this.getSnapshot(baseimage, false)) : this.getSnapshot(baseimage, true);
        if (snapshot != null) {
            BitConverter converter = new BitConverter();
            converter.convertTo8BitColor(snapshot);
            String tbfilenameroot = this.xnatId + "_" + scan.getId() + "_qc";
            PlexiFileSaver fs = new PlexiFileSaver(snapshot.getImage());
            String fileName = tbfilenameroot + ".gif";
            String filePath = this.cachepath + File.separator + fileName;
            boolean saved = fs.saveImageAsGif(filePath);
            if (!saved) {
                throw new Exception("Couldnt save file snapshot for scan " + scan.getId() + " at the location " + filePath);
            }
            File targetFile = new File(filePath);
            this.postFile(uri, targetFile, service_session, "SNAPSHOT", "ORIGINAL");
            this.deleteFile(targetFile);
            filePath = this.generateScaledDownImage(snapshot, tbfilenameroot);
            if (filePath != null) {
                targetFile = new File(filePath);
                this.postFile(uri, targetFile, service_session, "SNAPSHOT", "THUMBNAIL");
                this.deleteFile(targetFile);
            }
            snapshot.flush();
        }
    }

    private void deleteFile(File f) {
        if (f != null && f.exists()) {
            f.delete();
        }
    }

    private String generateScaledDownImage(ImagePlus baseimage, String tbfilenameroot) {
        String rtn = null;
        StackProcessor tbproc = new StackProcessor(baseimage.getStack(), baseimage.getProcessor());
        ImageStack tb = tbproc.resize(baseimage.getWidth() / 2, baseimage.getHeight() / 2);
        baseimage.setStack("", tb);
        PlexiFileSaver fs = new PlexiFileSaver(baseimage.getImage());
        String filePath = this.cachepath + File.separator + tbfilenameroot + "_t.gif";
        boolean saved = fs.saveImageAsGif(filePath);
        if (saved) {
            rtn = this.cachepath + File.separator + tbfilenameroot + "_t.gif";
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postFile(String uri, File file, String service_session, String label, String content) throws Exception {
        PostMethod filePost = new PostMethod(uri);
        String queryStringPrefix = "";
        if (this.workflowid != null) {
            queryStringPrefix = "event_id=" + this.workflowid + "&";
        }
        filePost.setQueryString(queryStringPrefix + "overwrite=true&format=GIF&content=" + content);
        try {
            filePost.setRequestHeader("Cookie", "JSESSIONID=" + service_session);
            Part[] parts = new Part[]{new FilePart(file.getName(), file)};
            filePost.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, filePost.getParams()));
            HttpClient client = new HttpClient();
            client.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
            int status = client.executeMethod((HttpMethod)filePost);
            if (status != 200) {
                throw new Exception("Couldnt post file to " + uri);
            }
        }
        finally {
            filePost.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createThumbnail(ImagePlus baseimage, XnatImagescandataBean scan, String service_session) throws Exception {
        block4: {
            XnatResourcecatalogBean rscCatalog = new XnatResourcecatalogBean();
            rscCatalog.setLabel("SNAPSHOTS");
            rscCatalog.setContent("SNAPSHOTS");
            rscCatalog.setFormat("GIF");
            StringWriter stringWriter = new StringWriter();
            rscCatalog.toXML((Writer)stringWriter, true);
            String strURL = this.host + "/REST/experiments/" + this.xnatId + "/scans/" + scan.getId() + "/resources";
            PostMethod post = new PostMethod(strURL);
            post.setRequestHeader("Cookie", "JSESSIONID=" + service_session);
            StringRequestEntity entity = new StringRequestEntity(stringWriter.toString(), "text/xml;charset=ISO-8859-1", null);
            post.setRequestEntity((RequestEntity)entity);
            HttpClient httpclient = new HttpClient();
            String filesURI = "";
            try {
                int result = httpclient.executeMethod((HttpMethod)post);
                System.out.println("Response status code: " + result);
                if (result == 200) {
                    filesURI = post.getResponseBodyAsString();
                    this.createThumbnail(baseimage, scan, filesURI + "/files", service_session);
                    break block4;
                }
                throw new Exception("Couldnt post to " + strURL + " got a response " + filesURI);
            }
            finally {
                post.releaseConnection();
            }
        }
    }

    private PlexiImageFile getPlexiImageFile(XnatAbstractresourceBean file, String scanId) throws Exception {
        PlexiImageFile pf = new PlexiImageFile();
        if (file instanceof XnatImageresourceBean) {
            pf = IOHelper.getPlexiImageFileFromImageResource(file);
        } else if (file instanceof XnatImageresourceseriesBean) {
            pf = IOHelper.getPlexiImageFileFromImageResourceSeries(file, this.cachepath);
        } else if (file instanceof XnatDicomseriesBean) {
            pf = IOHelper.getPlexiImageFileFromDicomSeries(file, this.cachepath, this.session + "_" + scanId);
        } else if (file instanceof XnatResourcecatalogBean) {
            pf = IOHelper.getPlexiImageFileFromResourceCatalog(file, this.cachepath, this.session + "_" + scanId);
        }
        return pf;
    }

    private ImagePlus createMontage(ImagePlus image) {
        PlexiMontageMaker mm = new PlexiMontageMaker();
        int columns = 1;
        int rows = 1;
        if (image.getStackSize() == 1) {
            columns = 1;
            rows = 1;
        } else if (image.getStackSize() == 2) {
            rows = 1;
            columns = 2;
        } else if (image.getStackSize() == 3) {
            rows = 1;
            columns = 3;
        } else {
            while (columns * columns <= image.getStackSize()) {
                ++columns;
            }
            rows = --columns;
        }
        if (columns > 7) {
            rows = columns = 7;
        }
        Hashtable attribs = ImageUtils.getSliceIncrement(image, columns * rows);
        int startslice = (Integer)attribs.get("startslice");
        int endslice = (Integer)attribs.get("endslice");
        int increment = (Integer)attribs.get("increment");
        IntensitySetter is = new IntensitySetter(image, true);
        is.autoAdjust(image, image.getProcessor());
        image = mm.makeMontage(image, columns, rows, 0.5, startslice, endslice, increment, true, false);
        image.getProcessor().resetMinAndMax();
        return image;
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    public static void main(String[] args) {
        try {
            WebBasedQCImageCreator qc = new WebBasedQCImageCreator(args);
            qc.createQCImages();
            System.out.println("All done");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

