/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.io;

import ij.ImagePlus;
import ij.io.FileSaver;
import ij.process.StackProcessor;
import java.io.File;
import java.util.Hashtable;
import org.nrg.plexiViewer.Writer.AnalyzeWriter;
import org.nrg.plexiViewer.io.ImageLoaderI;
import org.nrg.plexiViewer.io.PlexiFileOpener;
import org.nrg.plexiViewer.io.plexiViewerImageRelayer;
import org.nrg.plexiViewer.lite.UserSelection;
import org.nrg.plexiViewer.lite.display.MontageDisplay;
import org.nrg.plexiViewer.lite.io.PlexiImageFile;
import org.nrg.plexiViewer.lite.utils.ImageDetails;
import org.nrg.plexiViewer.lite.xml.Layout;
import org.nrg.plexiViewer.lite.xml.MontageView;
import org.nrg.plexiViewer.utils.ArchivePathManager;
import org.nrg.plexiViewer.utils.FileUtils;
import org.nrg.plexiViewer.utils.ImageUtils;
import org.nrg.plexiViewer.utils.Transform.ReOrientMakeMontage;
import org.nrg.plexiViewer.utils.URIUtils;
import org.nrg.xft.XFT;

public class LoResLoader
implements ImageLoaderI {
    private UserSelection userOptions;
    private MontageView mView;
    private Layout layout;
    private MontageDisplay mDisplay;
    private PlexiImageFile openedImageFile;

    public LoResLoader(UserSelection opt) {
        this.userOptions = opt;
    }

    @Override
    public ImagePlus load() throws Exception {
        ImagePlus image = null;
        PlexiImageFile pf = this.userOptions.getFile();
        this.layout = ImageDetails.getLayout(pf.getDimX(), pf.getDimY(), pf.getDimZ(), pf.getVoxelResX(), pf.getVoxelResY(), pf.getVoxelResZ(), pf.getFormat());
        String loresLocation = ArchivePathManager.GetInstance().getLoResLocation(this.userOptions.getProject(), this.userOptions.getSessionLabel());
        String loresType = ImageDetails.getDefaultLoresType();
        pf.setPath(URIUtils.getURI(loresLocation).toString());
        if (pf.getFormat() != null && pf.getFormat().equals("IMA")) {
            pf.setName(FileUtils.getLoResFileName(pf.getName() + ".4dfp.img", loresType, this.userOptions.getOrientation()));
        } else {
            pf.setName(FileUtils.getLoResFileName(pf.getName(), loresType, this.userOptions.getOrientation()));
        }
        if (pf.getPath().endsWith("/")) {
            pf.setURIAsString(pf.getPath() + pf.getName());
        } else {
            pf.setURIAsString(pf.getPath() + "/" + pf.getName());
        }
        pf.setCachePath(pf.getCachePath());
        pf.setXsiType("plexi:imageResource");
        String format = ImageDetails.getDefaultLoresFormat();
        pf.setFormat(format);
        System.out.println("Looking out for the Lo Res file " + pf.getPath() + File.separator + pf.getName());
        PlexiFileOpener pfo = new PlexiFileOpener(pf.getFormat(), pf);
        image = pfo.getImagePlus();
        if (this.mView == null) {
            this.mView = new MontageView();
            this.mView.setScale(0.65f);
            Hashtable attribs = ImageUtils.getSliceIncrement(pf.getDimZ());
            this.mView.addViewInfo(this.userOptions.getOrientation().toUpperCase(), (Integer)attribs.get("startslice"), (Integer)attribs.get("endslice"), (Integer)attribs.get("increment"));
            this.mDisplay = new MontageDisplay(this.mView, this.userOptions.getOrientation().toUpperCase(), this.layout);
        }
        this.mDisplay = new MontageDisplay(this.mView, this.userOptions.getOrientation().toUpperCase(), this.layout);
        ReOrientMakeMontage rm = new ReOrientMakeMontage(this.userOptions, pf.getFormat(), this.getMontageDisplay());
        image = rm.doPerform(image);
        this.openedImageFile = pf;
        System.out.println("LoResLoader openedImageFIle " + this.getPlexiImageFile().toString());
        pf.flush();
        this.openedImageFile.flush();
        return image;
    }

    @Override
    public PlexiImageFile getPlexiImageFile() {
        return this.openedImageFile;
    }

    public MontageView getMontageView() {
        return this.mView;
    }

    public Layout getLayout() {
        return this.layout;
    }

    @Override
    public MontageDisplay getMontageDisplay() {
        return this.mDisplay;
    }

    public static void main(String[] args) {
        UserSelection u = new UserSelection();
        u.setSessionId("000115_92046");
        u.setLoResType("8bit");
        u.setDataType("RAW");
        u.setOrientation("SAGITTAL");
        u.setDisplay("STACK");
        u.setHiResLayerNum(0);
        try {
            XFT.init((String)"C:\\jakarta-tomcat-5.5.4\\webapps\\cnda_xnat", (boolean)true, (boolean)true);
            LoResLoader l = new LoResLoader(u);
            ImagePlus img = l.load();
            img = new plexiViewerImageRelayer(u.getOrientation()).reverseStacks(img);
            StackProcessor sp = new StackProcessor(img.getStack(), img.getProcessor());
            sp.flipHorizontal();
            new FileSaver(img).saveAsRawStack("C:\\Mohana\\Temp\\LoRes\\3491-4_8bit_sag.img");
            new AnalyzeWriter().save(img, "C:\\Mohana\\Temp\\LoRes", "3491-4_8bit_sag.img", u.getOrientation() + "F");
            System.out.println("LoResLoader Done");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

